/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.permissions;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.luck.picture.lib.base.BaseSelectorFragment;
import com.luck.picture.lib.config.MediaType;
import com.luck.picture.lib.helper.ActivityCompatHelper;
import com.luck.picture.lib.permissions.OnPermissionResultListener;
import com.luck.picture.lib.permissions.PermissionUtil;
import com.luck.picture.lib.utils.SdkVersionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011\u00a2\u0006\u0002\u0010\u0012J!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J\u0016\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J\u001a\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"J+\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\b\u0010'\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0002\u0010(J.\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00110*2\b\u0010+\u001a\u0004\u0018\u00010\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/luck/picture/lib/permissions/PermissionChecker;", "", "()V", "CAMERA", "", "READ_EXTERNAL_STORAGE", "READ_MEDIA_AUDIO", "READ_MEDIA_IMAGES", "READ_MEDIA_VIDEO", "REQUEST_CODE", "", "WRITE_EXTERNAL_STORAGE", "checkSelfPermission", "", "ctx", "Landroid/content/Context;", "permissions", "", "(Landroid/content/Context;[Ljava/lang/String;)Z", "getReadPermissionArray", "context", "mediaType", "Lcom/luck/picture/lib/config/MediaType;", "(Landroid/content/Context;Lcom/luck/picture/lib/config/MediaType;)[Ljava/lang/String;", "isCheckReadAudio", "isCheckReadExternalStorage", "isCheckReadImages", "isCheckReadStorage", "isCheckReadVideo", "onRequestPermissionsResult", "", "grantResults", "", "action", "Lcom/luck/picture/lib/permissions/OnPermissionResultListener;", "requestPermissions", "fragment", "Landroidx/fragment/app/Fragment;", "permissionArray", "listenerOn", "(Landroidx/fragment/app/Fragment;[Ljava/lang/String;Lcom/luck/picture/lib/permissions/OnPermissionResultListener;)V", "permissionGroupList", "", "onPermissionResultListener", "selector_release"})
public final class PermissionChecker {
    @NotNull
    public static final PermissionChecker INSTANCE = new PermissionChecker();
    private static final int REQUEST_CODE = 10086;
    @NotNull
    public static final String CAMERA = "android.permission.CAMERA";
    @NotNull
    private static final String READ_MEDIA_AUDIO = "android.permission.READ_MEDIA_AUDIO";
    @NotNull
    private static final String READ_MEDIA_IMAGES = "android.permission.READ_MEDIA_IMAGES";
    @NotNull
    private static final String READ_MEDIA_VIDEO = "android.permission.READ_MEDIA_VIDEO";
    @NotNull
    private static final String READ_EXTERNAL_STORAGE = "android.permission.READ_EXTERNAL_STORAGE";
    @NotNull
    private static final String WRITE_EXTERNAL_STORAGE = "android.permission.WRITE_EXTERNAL_STORAGE";

    private PermissionChecker() {
    }

    public final void requestPermissions(@NotNull Fragment fragment, @NotNull String[] permissionArray, @Nullable OnPermissionResultListener listenerOn) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)permissionArray, (String)"permissionArray");
        List groupList = new ArrayList();
        groupList.add(permissionArray);
        this.requestPermissions(fragment, groupList, listenerOn);
    }

    private final void requestPermissions(Fragment fragment, List<String[]> permissionGroupList, OnPermissionResultListener onPermissionResultListener) {
        block6: {
            block7: {
                if (ActivityCompatHelper.INSTANCE.isDestroy((Activity)fragment.getActivity())) {
                    return;
                }
                if (!(fragment instanceof BaseSelectorFragment)) break block6;
                if (Build.VERSION.SDK_INT < 23) {
                    OnPermissionResultListener onPermissionResultListener2 = onPermissionResultListener;
                    if (onPermissionResultListener2 != null) {
                        onPermissionResultListener2.onGranted();
                    }
                    return;
                }
                FragmentActivity fragmentActivity = fragment.requireActivity();
                Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"fragment.requireActivity()");
                Activity activity = (Activity)fragmentActivity;
                List permissionList = new ArrayList();
                Iterator<String[]> iterator = permissionGroupList.iterator();
                while (iterator.hasNext()) {
                    for (String permission : iterator.next()) {
                        if (ContextCompat.checkSelfPermission((Context)((Context)activity), (String)permission) == 0) continue;
                        permissionList.add(permission);
                    }
                }
                if (permissionList.size() <= 0) break block7;
                ((BaseSelectorFragment)fragment).setOnPermissionResultListener(onPermissionResultListener);
                Collection $this$toTypedArray$iv = permissionList;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                String[] requestArray = stringArray;
                fragment.requestPermissions(requestArray, 10086);
                ActivityCompat.requestPermissions((Activity)activity, (String[])requestArray, (int)10086);
                break block6;
            }
            OnPermissionResultListener onPermissionResultListener3 = onPermissionResultListener;
            if (onPermissionResultListener3 == null) break block6;
            onPermissionResultListener3.onGranted();
        }
    }

    public final void onRequestPermissionsResult(@Nullable int[] grantResults, @Nullable OnPermissionResultListener action) {
        block1: {
            block0: {
                if (!PermissionUtil.isAllGranted(grantResults)) break block0;
                OnPermissionResultListener onPermissionResultListener = action;
                if (onPermissionResultListener == null) break block1;
                onPermissionResultListener.onGranted();
                break block1;
            }
            OnPermissionResultListener onPermissionResultListener = action;
            if (onPermissionResultListener == null) break block1;
            onPermissionResultListener.onDenied();
        }
    }

    public final boolean isCheckReadStorage(@NotNull Context context, @NotNull MediaType mediaType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        if (SdkVersionUtils.INSTANCE.isTIRAMISU()) {
            switch (WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
                case 1: {
                    bl = this.isCheckReadImages(context);
                    break;
                }
                case 2: {
                    bl = this.isCheckReadVideo(context);
                    break;
                }
                case 3: {
                    bl = this.isCheckReadAudio(context);
                    break;
                }
                default: {
                    if (this.isCheckReadImages(context) && this.isCheckReadVideo(context)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
        } else {
            bl = this.isCheckReadExternalStorage(context);
        }
        return bl;
    }

    @RequiresApi(api=33)
    public final boolean isCheckReadImages(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String[] stringArray = new String[]{READ_MEDIA_IMAGES};
        return this.checkSelfPermission(context, stringArray);
    }

    @RequiresApi(api=33)
    public final boolean isCheckReadVideo(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String[] stringArray = new String[]{READ_MEDIA_VIDEO};
        return this.checkSelfPermission(context, stringArray);
    }

    @RequiresApi(api=33)
    public final boolean isCheckReadAudio(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String[] stringArray = new String[]{READ_MEDIA_AUDIO};
        return this.checkSelfPermission(context, stringArray);
    }

    private final boolean isCheckReadExternalStorage(Context context) {
        String[] stringArray = new String[]{READ_EXTERNAL_STORAGE};
        return this.checkSelfPermission(context, stringArray);
    }

    public final boolean checkSelfPermission(@NotNull Context ctx, @NotNull String[] permissions) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        boolean isAllGranted = true;
        for (String permission : permissions) {
            if (ContextCompat.checkSelfPermission((Context)ctx.getApplicationContext(), (String)permission) == 0) continue;
            isAllGranted = false;
            break;
        }
        return isAllGranted;
    }

    @NotNull
    public final String[] getReadPermissionArray(@NotNull Context context, @NotNull MediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)mediaType), (String)"mediaType");
        if (SdkVersionUtils.INSTANCE.isTIRAMISU()) {
            String[] stringArray;
            int targetSdkVersion = context.getApplicationInfo().targetSdkVersion;
            if (mediaType == MediaType.IMAGE) {
                if (targetSdkVersion >= 33) {
                    String[] stringArray2 = new String[]{READ_MEDIA_IMAGES};
                    stringArray = stringArray2;
                } else {
                    String[] stringArray3 = new String[]{READ_MEDIA_IMAGES, READ_EXTERNAL_STORAGE};
                    stringArray = stringArray3;
                }
            } else if (mediaType == MediaType.VIDEO) {
                if (targetSdkVersion >= 33) {
                    String[] stringArray4 = new String[]{READ_MEDIA_VIDEO};
                    stringArray = stringArray4;
                } else {
                    String[] stringArray5 = new String[]{READ_MEDIA_VIDEO, READ_EXTERNAL_STORAGE};
                    stringArray = stringArray5;
                }
            } else if (mediaType == MediaType.AUDIO) {
                if (targetSdkVersion >= 33) {
                    String[] stringArray6 = new String[]{READ_MEDIA_AUDIO};
                    stringArray = stringArray6;
                } else {
                    String[] stringArray7 = new String[]{READ_MEDIA_AUDIO, READ_EXTERNAL_STORAGE};
                    stringArray = stringArray7;
                }
            } else if (targetSdkVersion >= 33) {
                String[] stringArray8 = new String[]{READ_MEDIA_IMAGES, READ_MEDIA_VIDEO};
                stringArray = stringArray8;
            } else {
                String[] stringArray9 = new String[]{READ_MEDIA_IMAGES, READ_MEDIA_VIDEO, READ_EXTERNAL_STORAGE};
                stringArray = stringArray9;
            }
            return stringArray;
        }
        String[] stringArray = new String[]{READ_EXTERNAL_STORAGE, WRITE_EXTERNAL_STORAGE};
        return stringArray;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MediaType.values().length];
            nArray[MediaType.IMAGE.ordinal()] = 1;
            nArray[MediaType.VIDEO.ordinal()] = 2;
            nArray[MediaType.AUDIO.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

