/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.player.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.OverScroller;
import com.luck.picture.lib.photoview.OnMatrixChangedListener;
import com.luck.picture.lib.photoview.OnScaleChangedListener;
import com.luck.picture.lib.photoview.OnSingleFlingListener;
import com.luck.picture.lib.photoview.OnViewDragListener;
import com.luck.picture.lib.photoview.OnViewTapListener;
import com.luck.picture.lib.player.widget.OnOutsideTextureTapListener;
import com.luck.picture.lib.player.widget.OnTextureTapListener;
import com.luck.picture.lib.player.widget.OnTextureViewGestureListener;
import com.luck.picture.lib.player.widget.TextureViewGestureDetector;
import com.luck.picture.lib.player.widget.TextureViewUtils;

public class TextureViewAttacher
implements View.OnTouchListener,
View.OnLayoutChangeListener {
    private static final float DEFAULT_MAX_SCALE = 3.0f;
    private static final float DEFAULT_MID_SCALE = 1.75f;
    private static final float DEFAULT_MIN_SCALE = 1.0f;
    private static final int DEFAULT_ZOOM_DURATION = 200;
    private static final int HORIZONTAL_EDGE_NONE = -1;
    private static final int HORIZONTAL_EDGE_LEFT = 0;
    private static final int HORIZONTAL_EDGE_RIGHT = 1;
    private static final int HORIZONTAL_EDGE_BOTH = 2;
    private static final int VERTICAL_EDGE_NONE = -1;
    private static final int VERTICAL_EDGE_TOP = 0;
    private static final int VERTICAL_EDGE_BOTTOM = 1;
    private static final int VERTICAL_EDGE_BOTH = 2;
    private static final int SINGLE_TOUCH = 1;
    private Interpolator mInterpolator = new AccelerateDecelerateInterpolator();
    private int mZoomDuration = 200;
    private float mMinScale = 1.0f;
    private float mMidScale = 1.75f;
    private float mMaxScale = 3.0f;
    private boolean mAllowParentInterceptOnEdge = true;
    private boolean mBlockParentIntercept = false;
    private final TextureView mTextureView;
    private GestureDetector mGestureDetector;
    private TextureViewGestureDetector mScaleDragDetector;
    private final Matrix mBaseMatrix = new Matrix();
    private final Matrix mDrawMatrix = new Matrix();
    private final Matrix mSuppMatrix = new Matrix();
    private final RectF mDisplayRect = new RectF();
    private final float[] mMatrixValues = new float[9];
    private OnMatrixChangedListener mMatrixChangeListener;
    private OnTextureTapListener mTextureTapListener;
    private OnOutsideTextureTapListener mOutsideTextureTapListener;
    private OnViewTapListener mViewTapListener;
    private View.OnClickListener mOnClickListener;
    private View.OnLongClickListener mLongClickListener;
    private OnScaleChangedListener mScaleChangeListener;
    private OnSingleFlingListener mSingleFlingListener;
    private OnViewDragListener mOnViewDragListener;
    private FlingRunnable mCurrentFlingRunnable;
    private int mHorizontalScrollEdge = 2;
    private int mVerticalScrollEdge = 2;
    private float mBaseRotation;
    private boolean mZoomEnabled = true;
    private final OnTextureViewGestureListener onTextureViewGestureListener = new OnTextureViewGestureListener(){

        @Override
        public void onDrag(float dx, float dy) {
            if (TextureViewAttacher.this.mScaleDragDetector.isScaling()) {
                return;
            }
            if (TextureViewAttacher.this.mOnViewDragListener != null) {
                TextureViewAttacher.this.mOnViewDragListener.onDrag(dx, dy);
            }
            TextureViewAttacher.this.mSuppMatrix.postTranslate(dx, dy);
            TextureViewAttacher.this.checkAndDisplayMatrix();
            ViewParent parent = TextureViewAttacher.this.mTextureView.getParent();
            if (TextureViewAttacher.this.mAllowParentInterceptOnEdge && !TextureViewAttacher.this.mScaleDragDetector.isScaling() && !TextureViewAttacher.this.mBlockParentIntercept) {
                if ((TextureViewAttacher.this.mHorizontalScrollEdge == 2 || TextureViewAttacher.this.mHorizontalScrollEdge == 0 && dx >= 1.0f || TextureViewAttacher.this.mHorizontalScrollEdge == 1 && dx <= -1.0f || TextureViewAttacher.this.mVerticalScrollEdge == 0 && dy >= 1.0f || TextureViewAttacher.this.mVerticalScrollEdge == 1 && dy <= -1.0f) && parent != null) {
                    parent.requestDisallowInterceptTouchEvent(false);
                }
            } else if (parent != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
        }

        @Override
        public void onFling(float startX, float startY, float velocityX, float velocityY) {
            TextureViewAttacher.this.mCurrentFlingRunnable = new FlingRunnable(TextureViewAttacher.this.mTextureView.getContext());
            TextureViewAttacher.this.mCurrentFlingRunnable.fling(TextureViewAttacher.this.getTextureViewWidth(TextureViewAttacher.this.mTextureView), TextureViewAttacher.this.getTextureViewHeight(TextureViewAttacher.this.mTextureView), (int)velocityX, (int)velocityY);
            TextureViewAttacher.this.mTextureView.post((Runnable)TextureViewAttacher.this.mCurrentFlingRunnable);
        }

        @Override
        public void onScale(float scaleFactor, float focusX, float focusY) {
            this.onScale(scaleFactor, focusX, focusY, 0.0f, 0.0f);
        }

        @Override
        public void onScale(float scaleFactor, float focusX, float focusY, float dx, float dy) {
            if (TextureViewAttacher.this.getScale() < TextureViewAttacher.this.mMaxScale || scaleFactor < 1.0f) {
                if (TextureViewAttacher.this.mScaleChangeListener != null) {
                    TextureViewAttacher.this.mScaleChangeListener.onScaleChange(scaleFactor, focusX, focusY);
                }
                TextureViewAttacher.this.mSuppMatrix.postScale(scaleFactor, scaleFactor, focusX, focusY);
                TextureViewAttacher.this.mSuppMatrix.postTranslate(dx, dy);
                TextureViewAttacher.this.checkAndDisplayMatrix();
            }
        }
    };

    public TextureViewAttacher(TextureView textureView) {
        this.mTextureView = textureView;
        textureView.setOnTouchListener((View.OnTouchListener)this);
        textureView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        if (textureView.isInEditMode()) {
            return;
        }
        this.mBaseRotation = 0.0f;
        this.mScaleDragDetector = new TextureViewGestureDetector(textureView.getContext(), this.onTextureViewGestureListener);
        this.mGestureDetector = new GestureDetector(textureView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent e) {
                if (TextureViewAttacher.this.mLongClickListener != null) {
                    TextureViewAttacher.this.mLongClickListener.onLongClick((View)TextureViewAttacher.this.mTextureView);
                }
            }

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                if (TextureViewAttacher.this.mSingleFlingListener != null) {
                    if (TextureViewAttacher.this.getScale() > 1.0f) {
                        return false;
                    }
                    if (e1.getPointerCount() > 1 || e2.getPointerCount() > 1) {
                        return false;
                    }
                    return TextureViewAttacher.this.mSingleFlingListener.onFling(e1, e2, velocityX, velocityY);
                }
                return false;
            }
        });
        this.mGestureDetector.setOnDoubleTapListener(new GestureDetector.OnDoubleTapListener(){

            public boolean onSingleTapConfirmed(MotionEvent e) {
                if (TextureViewAttacher.this.mOnClickListener != null) {
                    TextureViewAttacher.this.mOnClickListener.onClick((View)TextureViewAttacher.this.mTextureView);
                }
                RectF displayRect = TextureViewAttacher.this.getDisplayRect();
                float x = e.getX();
                float y = e.getY();
                if (TextureViewAttacher.this.mViewTapListener != null) {
                    TextureViewAttacher.this.mViewTapListener.onViewTap((View)TextureViewAttacher.this.mTextureView, x, y);
                }
                if (displayRect != null) {
                    if (displayRect.contains(x, y)) {
                        float xResult = (x - displayRect.left) / displayRect.width();
                        float yResult = (y - displayRect.top) / displayRect.height();
                        if (TextureViewAttacher.this.mTextureTapListener != null) {
                            TextureViewAttacher.this.mTextureTapListener.onTextureTap(TextureViewAttacher.this.mTextureView, xResult, yResult);
                        }
                        return true;
                    }
                    if (TextureViewAttacher.this.mOutsideTextureTapListener != null) {
                        TextureViewAttacher.this.mOutsideTextureTapListener.onOutsideTextureTap(TextureViewAttacher.this.mTextureView);
                    }
                }
                return false;
            }

            public boolean onDoubleTap(MotionEvent ev) {
                try {
                    float scale = TextureViewAttacher.this.getScale();
                    float x = ev.getX();
                    float y = ev.getY();
                    if (scale < TextureViewAttacher.this.getMediumScale()) {
                        TextureViewAttacher.this.setScale(TextureViewAttacher.this.getMediumScale(), x, y, true);
                    } else if (scale >= TextureViewAttacher.this.getMediumScale() && scale < TextureViewAttacher.this.getMaximumScale()) {
                        TextureViewAttacher.this.setScale(TextureViewAttacher.this.getMaximumScale(), x, y, true);
                    } else {
                        TextureViewAttacher.this.setScale(TextureViewAttacher.this.getMinimumScale(), x, y, true);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                return true;
            }

            public boolean onDoubleTapEvent(MotionEvent e) {
                return false;
            }
        });
    }

    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener newOnDoubleTapListener) {
        this.mGestureDetector.setOnDoubleTapListener(newOnDoubleTapListener);
    }

    public void setOnScaleChangeListener(OnScaleChangedListener onScaleChangeListener) {
        this.mScaleChangeListener = onScaleChangeListener;
    }

    public void setOnSingleFlingListener(OnSingleFlingListener onSingleFlingListener) {
        this.mSingleFlingListener = onSingleFlingListener;
    }

    @Deprecated
    public boolean isZoomEnabled() {
        return this.mZoomEnabled;
    }

    public RectF getDisplayRect() {
        this.checkMatrixBounds();
        return this.getDisplayRect(this.getDrawMatrix());
    }

    public void setBaseRotation(float degrees) {
        this.mBaseRotation = degrees % 360.0f;
        this.update();
        this.setRotationBy(this.mBaseRotation);
        this.checkAndDisplayMatrix();
    }

    public void setRotationTo(float degrees) {
        this.mSuppMatrix.setRotate(degrees % 360.0f);
        this.checkAndDisplayMatrix();
    }

    public void setRotationBy(float degrees) {
        this.mSuppMatrix.postRotate(degrees % 360.0f);
        this.checkAndDisplayMatrix();
    }

    public float getMinimumScale() {
        return this.mMinScale;
    }

    public float getMediumScale() {
        return this.mMidScale;
    }

    public float getMaximumScale() {
        return this.mMaxScale;
    }

    public float getScale() {
        return (float)Math.sqrt((float)Math.pow(this.getValue(this.mSuppMatrix, 0), 2.0) + (float)Math.pow(this.getValue(this.mSuppMatrix, 3), 2.0));
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (left != oldLeft || top != oldTop || right != oldRight || bottom != oldBottom) {
            this.updateBaseMatrix();
        }
    }

    public boolean onTouch(View v, MotionEvent ev) {
        boolean handled = false;
        if (this.mZoomEnabled && TextureViewUtils.INSTANCE.hasBitmap((TextureView)v)) {
            switch (ev.getAction()) {
                case 0: {
                    ViewParent parent = v.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.cancelFling();
                    break;
                }
                case 1: 
                case 3: {
                    RectF rect;
                    if (this.getScale() < this.mMinScale) {
                        rect = this.getDisplayRect();
                        if (rect == null) break;
                        v.post((Runnable)new AnimatedZoomRunnable(this.getScale(), this.mMinScale, rect.centerX(), rect.centerY()));
                        handled = true;
                        break;
                    }
                    if (!(this.getScale() > this.mMaxScale) || (rect = this.getDisplayRect()) == null) break;
                    v.post((Runnable)new AnimatedZoomRunnable(this.getScale(), this.mMaxScale, rect.centerX(), rect.centerY()));
                    handled = true;
                }
            }
            if (this.mScaleDragDetector != null) {
                boolean wasScaling = this.mScaleDragDetector.isScaling();
                boolean wasDragging = this.mScaleDragDetector.isDragging();
                handled = this.mScaleDragDetector.onTouchEvent(ev);
                boolean didntScale = !wasScaling && !this.mScaleDragDetector.isScaling();
                boolean didntDrag = !wasDragging && !this.mScaleDragDetector.isDragging();
                boolean bl = this.mBlockParentIntercept = didntScale && didntDrag;
            }
            if (this.mGestureDetector != null && this.mGestureDetector.onTouchEvent(ev)) {
                handled = true;
            }
        }
        return handled;
    }

    public void setAllowParentInterceptOnEdge(boolean allow) {
        this.mAllowParentInterceptOnEdge = allow;
    }

    public void setMinimumScale(float minimumScale) {
        TextureViewUtils.INSTANCE.checkZoomLevels(minimumScale, this.mMidScale, this.mMaxScale);
        this.mMinScale = minimumScale;
    }

    public void setMediumScale(float mediumScale) {
        TextureViewUtils.INSTANCE.checkZoomLevels(this.mMinScale, mediumScale, this.mMaxScale);
        this.mMidScale = mediumScale;
    }

    public void setMaximumScale(float maximumScale) {
        TextureViewUtils.INSTANCE.checkZoomLevels(this.mMinScale, this.mMidScale, maximumScale);
        this.mMaxScale = maximumScale;
    }

    public void setScaleLevels(float minimumScale, float mediumScale, float maximumScale) {
        TextureViewUtils.INSTANCE.checkZoomLevels(minimumScale, mediumScale, maximumScale);
        this.mMinScale = minimumScale;
        this.mMidScale = mediumScale;
        this.mMaxScale = maximumScale;
    }

    public void setOnLongClickListener(View.OnLongClickListener listener) {
        this.mLongClickListener = listener;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    public void setOnMatrixChangeListener(OnMatrixChangedListener listener) {
        this.mMatrixChangeListener = listener;
    }

    public void setOnTextureTapListener(OnTextureTapListener listener) {
        this.mTextureTapListener = listener;
    }

    public void setOnOutsideTextureTapListener(OnOutsideTextureTapListener listener) {
        this.mOutsideTextureTapListener = listener;
    }

    public void setOnViewTapListener(OnViewTapListener listener) {
        this.mViewTapListener = listener;
    }

    public void setOnViewDragListener(OnViewDragListener listener) {
        this.mOnViewDragListener = listener;
    }

    public void setScale(float scale) {
        this.setScale(scale, false);
    }

    public void setScale(float scale, boolean animate) {
        this.setScale(scale, this.mTextureView.getRight() >> 1, this.mTextureView.getBottom() >> 1, animate);
    }

    public void setScale(float scale, float focalX, float focalY, boolean animate) {
        if (scale < this.mMinScale || scale > this.mMaxScale) {
            throw new IllegalArgumentException("Scale must be within the range of minScale and maxScale");
        }
        if (animate) {
            this.mTextureView.post((Runnable)new AnimatedZoomRunnable(this.getScale(), scale, focalX, focalY));
        } else {
            this.mSuppMatrix.setScale(scale, scale, focalX, focalY);
            this.checkAndDisplayMatrix();
        }
    }

    public void setZoomInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public boolean isZoomable() {
        return this.mZoomEnabled;
    }

    public void setZoomable(boolean zoomable) {
        this.mZoomEnabled = zoomable;
        this.update();
    }

    public void update() {
        if (this.mZoomEnabled) {
            this.updateBaseMatrix();
        } else {
            this.resetMatrix();
        }
    }

    public void getDisplayMatrix(Matrix matrix) {
        matrix.set(this.getDrawMatrix());
    }

    public void getSuppMatrix(Matrix matrix) {
        matrix.set(this.mSuppMatrix);
    }

    private Matrix getDrawMatrix() {
        this.mDrawMatrix.set(this.mBaseMatrix);
        this.mDrawMatrix.postConcat(this.mSuppMatrix);
        return this.mDrawMatrix;
    }

    public Matrix getImageMatrix() {
        return this.mDrawMatrix;
    }

    public void setZoomTransitionDuration(int milliseconds) {
        this.mZoomDuration = milliseconds;
    }

    private float getValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[whichValue];
    }

    private void resetMatrix() {
        this.mSuppMatrix.reset();
        this.setRotationBy(this.mBaseRotation);
        this.setImageViewMatrix(this.getDrawMatrix());
        this.checkMatrixBounds();
    }

    private void setImageViewMatrix(Matrix matrix) {
        RectF displayRect;
        this.mTextureView.setTransform(matrix);
        if (this.mMatrixChangeListener != null && (displayRect = this.getDisplayRect(matrix)) != null) {
            this.mMatrixChangeListener.onMatrixChanged(displayRect);
        }
    }

    private void checkAndDisplayMatrix() {
        if (this.checkMatrixBounds()) {
            this.setImageViewMatrix(this.getDrawMatrix());
        }
    }

    private RectF getDisplayRect(Matrix matrix) {
        Bitmap d = this.mTextureView.getBitmap();
        if (d != null) {
            this.mDisplayRect.set(0.0f, 0.0f, (float)d.getWidth(), (float)d.getHeight());
            matrix.mapRect(this.mDisplayRect);
            return this.mDisplayRect;
        }
        return null;
    }

    private void updateBaseMatrix() {
        this.mBaseMatrix.reset();
        this.resetMatrix();
    }

    private boolean checkMatrixBounds() {
        RectF rect = this.getDisplayRect(this.getDrawMatrix());
        if (rect == null) {
            return false;
        }
        float height = rect.height();
        float width = rect.width();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int viewHeight = this.getTextureViewHeight(this.mTextureView);
        if (height <= (float)viewHeight) {
            deltaY = ((float)viewHeight - height) / 2.0f - rect.top;
            this.mVerticalScrollEdge = 2;
        } else if (rect.top > 0.0f) {
            this.mVerticalScrollEdge = 0;
            deltaY = -rect.top;
        } else if (rect.bottom < (float)viewHeight) {
            this.mVerticalScrollEdge = 1;
            deltaY = (float)viewHeight - rect.bottom;
        } else {
            this.mVerticalScrollEdge = -1;
        }
        int viewWidth = this.getTextureViewWidth(this.mTextureView);
        if (width <= (float)viewWidth) {
            deltaX = ((float)viewWidth - width) / 2.0f - rect.left;
            this.mHorizontalScrollEdge = 2;
        } else if (rect.left > 0.0f) {
            this.mHorizontalScrollEdge = 0;
            deltaX = -rect.left;
        } else if (rect.right < (float)viewWidth) {
            deltaX = (float)viewWidth - rect.right;
            this.mHorizontalScrollEdge = 1;
        } else {
            this.mHorizontalScrollEdge = -1;
        }
        this.mSuppMatrix.postTranslate(deltaX, deltaY);
        return true;
    }

    private int getTextureViewWidth(TextureView textureView) {
        return textureView.getWidth() - textureView.getPaddingLeft() - textureView.getPaddingRight();
    }

    private int getTextureViewHeight(TextureView textureView) {
        return textureView.getHeight() - textureView.getPaddingTop() - textureView.getPaddingBottom();
    }

    private void cancelFling() {
        if (this.mCurrentFlingRunnable != null) {
            this.mCurrentFlingRunnable.cancelFling();
            this.mCurrentFlingRunnable = null;
        }
    }

    private class FlingRunnable
    implements Runnable {
        private final OverScroller mScroller;
        private int mCurrentX;
        private int mCurrentY;

        public FlingRunnable(Context context) {
            this.mScroller = new OverScroller(context);
        }

        public void cancelFling() {
            this.mScroller.forceFinished(true);
        }

        public void fling(int viewWidth, int viewHeight, int velocityX, int velocityY) {
            int maxY;
            int minY;
            int maxX;
            int minX;
            RectF rect = TextureViewAttacher.this.getDisplayRect();
            if (rect == null) {
                return;
            }
            int startX = Math.round(-rect.left);
            if ((float)viewWidth < rect.width()) {
                minX = 0;
                maxX = Math.round(rect.width() - (float)viewWidth);
            } else {
                minX = maxX = startX;
            }
            int startY = Math.round(-rect.top);
            if ((float)viewHeight < rect.height()) {
                minY = 0;
                maxY = Math.round(rect.height() - (float)viewHeight);
            } else {
                minY = maxY = startY;
            }
            this.mCurrentX = startX;
            this.mCurrentY = startY;
            if (startX != maxX || startY != maxY) {
                this.mScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY, 0, 0);
            }
        }

        @Override
        public void run() {
            if (this.mScroller.isFinished()) {
                return;
            }
            if (this.mScroller.computeScrollOffset()) {
                int newX = this.mScroller.getCurrX();
                int newY = this.mScroller.getCurrY();
                TextureViewAttacher.this.mSuppMatrix.postTranslate((float)(this.mCurrentX - newX), (float)(this.mCurrentY - newY));
                TextureViewAttacher.this.checkAndDisplayMatrix();
                this.mCurrentX = newX;
                this.mCurrentY = newY;
                TextureViewAttacher.this.mTextureView.postOnAnimation((Runnable)this);
            }
        }
    }

    private class AnimatedZoomRunnable
    implements Runnable {
        private final float mFocalX;
        private final float mFocalY;
        private final long mStartTime;
        private final float mZoomStart;
        private final float mZoomEnd;

        public AnimatedZoomRunnable(float currentZoom, float targetZoom, float focalX, float focalY) {
            this.mFocalX = focalX;
            this.mFocalY = focalY;
            this.mStartTime = System.currentTimeMillis();
            this.mZoomStart = currentZoom;
            this.mZoomEnd = targetZoom;
        }

        @Override
        public void run() {
            float t = this.interpolate();
            float scale = this.mZoomStart + t * (this.mZoomEnd - this.mZoomStart);
            float deltaScale = scale / TextureViewAttacher.this.getScale();
            TextureViewAttacher.this.onTextureViewGestureListener.onScale(deltaScale, this.mFocalX, this.mFocalY);
            if (t < 1.0f) {
                TextureViewAttacher.this.mTextureView.postOnAnimation((Runnable)this);
            }
        }

        private float interpolate() {
            float t = 1.0f * (float)(System.currentTimeMillis() - this.mStartTime) / (float)TextureViewAttacher.this.mZoomDuration;
            t = Math.min(1.0f, t);
            t = TextureViewAttacher.this.mInterpolator.getInterpolation(t);
            return t;
        }
    }
}

