/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.player.widget;

import android.content.Context;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import com.luck.picture.lib.player.widget.OnTextureViewGestureListener;
import com.luck.picture.lib.player.widget.TextureViewUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/luck/picture/lib/player/widget/TextureViewGestureDetector;", "", "context", "Landroid/content/Context;", "listener", "Lcom/luck/picture/lib/player/widget/OnTextureViewGestureListener;", "(Landroid/content/Context;Lcom/luck/picture/lib/player/widget/OnTextureViewGestureListener;)V", "isDragging", "", "()Z", "setDragging", "(Z)V", "isScaling", "mActivePointerId", "", "mActivePointerIndex", "mDetector", "Landroid/view/ScaleGestureDetector;", "mLastTouchX", "", "mLastTouchY", "mListener", "mMinimumVelocity", "mTouchSlop", "mVelocityTracker", "Landroid/view/VelocityTracker;", "getActiveX", "ev", "Landroid/view/MotionEvent;", "getActiveY", "onTouchEvent", "processTouchEvent", "Companion", "selector_release"})
public final class TextureViewGestureDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mActivePointerId;
    private int mActivePointerIndex;
    @NotNull
    private final ScaleGestureDetector mDetector;
    @Nullable
    private VelocityTracker mVelocityTracker;
    private boolean isDragging;
    private float mLastTouchX;
    private float mLastTouchY;
    private final float mTouchSlop;
    private final float mMinimumVelocity;
    @NotNull
    private final OnTextureViewGestureListener mListener;
    private static final int INVALID_POINTER_ID = -1;

    public TextureViewGestureDetector(@Nullable Context context, @NotNull OnTextureViewGestureListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.mActivePointerId = -1;
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mListener = listener;
        ScaleGestureDetector.OnScaleGestureListener mScaleListener2 = new ScaleGestureDetector.OnScaleGestureListener(this){
            private float lastFocusX;
            private float lastFocusY;
            final /* synthetic */ TextureViewGestureDetector this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onScale(@NotNull ScaleGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
                float scaleFactor = detector.getScaleFactor();
                if (Float.isNaN(scaleFactor) || Float.isInfinite(scaleFactor)) {
                    return false;
                }
                if (scaleFactor >= 0.0f) {
                    TextureViewGestureDetector.access$getMListener$p(this.this$0).onScale(scaleFactor, detector.getFocusX(), detector.getFocusY(), detector.getFocusX() - this.lastFocusX, detector.getFocusY() - this.lastFocusY);
                    this.lastFocusX = detector.getFocusX();
                    this.lastFocusY = detector.getFocusY();
                }
                return true;
            }

            public boolean onScaleBegin(@NotNull ScaleGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
                this.lastFocusX = detector.getFocusX();
                this.lastFocusY = detector.getFocusY();
                return true;
            }

            public void onScaleEnd(@NotNull ScaleGestureDetector detector) {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            }
        };
        this.mDetector = new ScaleGestureDetector(context, mScaleListener2);
    }

    public final boolean isDragging() {
        return this.isDragging;
    }

    public final void setDragging(boolean bl) {
        this.isDragging = bl;
    }

    private final float getActiveX(MotionEvent ev) {
        float f;
        try {
            f = ev.getX(this.mActivePointerIndex);
        }
        catch (Exception e) {
            f = ev.getX();
        }
        return f;
    }

    private final float getActiveY(MotionEvent ev) {
        float f;
        try {
            f = ev.getY(this.mActivePointerIndex);
        }
        catch (Exception e) {
            f = ev.getY();
        }
        return f;
    }

    public final boolean isScaling() {
        return this.mDetector.isInProgress();
    }

    public final boolean onTouchEvent(@NotNull MotionEvent ev) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        try {
            this.mDetector.onTouchEvent(ev);
            bl = this.processTouchEvent(ev);
        }
        catch (IllegalArgumentException e) {
            bl = true;
        }
        return bl;
    }

    private final boolean processTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                this.mActivePointerId = ev.getPointerId(0);
                this.mVelocityTracker = VelocityTracker.obtain();
                if (this.mVelocityTracker != null) {
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    if (velocityTracker != null) {
                        velocityTracker.addMovement(ev);
                    }
                }
                this.mLastTouchX = this.getActiveX(ev);
                this.mLastTouchY = this.getActiveY(ev);
                this.isDragging = false;
                break;
            }
            case 2: {
                float x = this.getActiveX(ev);
                float y = this.getActiveY(ev);
                float dx = x - this.mLastTouchX;
                float dy = y - this.mLastTouchY;
                if (!this.isDragging) {
                    boolean bl = this.isDragging = Math.sqrt(dx * dx + dy * dy) >= (double)this.mTouchSlop;
                }
                if (!this.isDragging) break;
                this.mListener.onDrag(dx, dy);
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                if (this.mVelocityTracker == null) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                if (velocityTracker != null) {
                    velocityTracker.addMovement(ev);
                }
                break;
            }
            case 3: {
                this.mActivePointerId = -1;
                if (this.mVelocityTracker == null) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                if (velocityTracker != null) {
                    velocityTracker.recycle();
                }
                this.mVelocityTracker = null;
                break;
            }
            case 1: {
                this.mActivePointerId = -1;
                if (this.isDragging && this.mVelocityTracker != null) {
                    float vY;
                    this.mLastTouchX = this.getActiveX(ev);
                    this.mLastTouchY = this.getActiveY(ev);
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    if (velocityTracker != null) {
                        velocityTracker.addMovement(ev);
                    }
                    VelocityTracker velocityTracker2 = this.mVelocityTracker;
                    if (velocityTracker2 != null) {
                        velocityTracker2.computeCurrentVelocity(1000);
                    }
                    VelocityTracker velocityTracker3 = this.mVelocityTracker;
                    float vX = velocityTracker3 != null ? velocityTracker3.getXVelocity() : 0.0f;
                    VelocityTracker velocityTracker4 = this.mVelocityTracker;
                    float f = vY = velocityTracker4 != null ? velocityTracker4.getYVelocity() : 0.0f;
                    if (RangesKt.coerceAtLeast((float)Math.abs(vX), (float)Math.abs(vY)) >= this.mMinimumVelocity) {
                        this.mListener.onFling(this.mLastTouchX, this.mLastTouchY, -vX, -vY);
                    }
                }
                if (this.mVelocityTracker == null) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                if (velocityTracker != null) {
                    velocityTracker.recycle();
                }
                this.mVelocityTracker = null;
                break;
            }
            case 6: {
                int pointerIndex = TextureViewUtils.INSTANCE.getPointerIndex(ev.getAction());
                int pointerId = ev.getPointerId(pointerIndex);
                if (pointerId != this.mActivePointerId) break;
                int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                this.mActivePointerId = ev.getPointerId(newPointerIndex);
                this.mLastTouchX = ev.getX(newPointerIndex);
                this.mLastTouchY = ev.getY(newPointerIndex);
            }
        }
        this.mActivePointerIndex = ev.findPointerIndex(this.mActivePointerId != -1 ? this.mActivePointerId : 0);
        return true;
    }

    public static final /* synthetic */ OnTextureViewGestureListener access$getMListener$p(TextureViewGestureDetector $this) {
        return $this.mListener;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/luck/picture/lib/player/widget/TextureViewGestureDetector$Companion;", "", "()V", "INVALID_POINTER_ID", "", "selector_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

