/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.provider;

import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.provider.TempDataProvider;
import com.luck.picture.lib.utils.SelectorLogUtils;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/luck/picture/lib/provider/SelectorProviders;", "", "()V", "configQueue", "Ljava/util/LinkedList;", "Lcom/luck/picture/lib/config/SelectorConfig;", "addConfigQueue", "", "config", "destroy", "getConfig", "reset", "Companion", "InstanceHelper", "selector_release"})
public final class SelectorProviders {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedList<SelectorConfig> configQueue = new LinkedList();

    public final void addConfigQueue(@NotNull SelectorConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.configQueue.add(config);
    }

    @NotNull
    public final SelectorConfig getConfig() {
        SelectorConfig selectorConfig;
        if (this.configQueue.size() > 0) {
            SelectorConfig selectorConfig2 = this.configQueue.getLast();
            Intrinsics.checkNotNullExpressionValue((Object)selectorConfig2, (String)"configQueue.last");
            selectorConfig = selectorConfig2;
        } else {
            selectorConfig = new SelectorConfig();
        }
        return selectorConfig;
    }

    public final void destroy() {
        SelectorConfig config = this.getConfig();
        config.destroy();
        this.configQueue.remove(config);
        TempDataProvider.Companion.getInstance().reset();
        SelectorLogUtils.INSTANCE.info(System.currentTimeMillis() + ":\u9500\u6bc1");
    }

    public final void reset() {
        int n = this.configQueue.size();
        for (int i = 0; i < n; ++i) {
            this.configQueue.get(i).destroy();
        }
        this.configQueue.clear();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/luck/picture/lib/provider/SelectorProviders$Companion;", "", "()V", "getInstance", "Lcom/luck/picture/lib/provider/SelectorProviders;", "selector_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SelectorProviders getInstance() {
            return InstanceHelper.INSTANCE.getInstance();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/luck/picture/lib/provider/SelectorProviders$InstanceHelper;", "", "()V", "instance", "Lcom/luck/picture/lib/provider/SelectorProviders;", "getInstance", "()Lcom/luck/picture/lib/provider/SelectorProviders;", "selector_release"})
    public static final class InstanceHelper {
        @NotNull
        public static final InstanceHelper INSTANCE = new InstanceHelper();
        @NotNull
        private static final SelectorProviders instance = new SelectorProviders();

        private InstanceHelper() {
        }

        @NotNull
        public final SelectorProviders getInstance() {
            return instance;
        }
    }
}

