/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.registry;

import androidx.annotation.NonNull;
import com.luck.picture.lib.adapter.MediaPreviewAdapter;
import com.luck.picture.lib.adapter.base.BaseListViewHolder;
import com.luck.picture.lib.adapter.base.BaseMediaListAdapter;
import com.luck.picture.lib.adapter.base.BasePreviewMediaHolder;
import com.luck.picture.lib.base.BaseSelectorFragment;
import com.luck.picture.lib.registry.ImageCaptureComponent;
import com.luck.picture.lib.registry.SoundCaptureComponent;
import com.luck.picture.lib.registry.VideoCaptureComponent;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b&\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\r\"\u0004\b\u0000\u0010\u000e2\u000e\b\u0001\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\rH&J\u001a\u0010\u0010\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00120\rJ\u001a\u0010\u0013\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00140\rJ\u001a\u0010\u0015\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00140\rJ\u001a\u0010\u0016\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u00142\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00140\rJ\u001e\u0010\u0017\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u000e2\u000e\b\u0001\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\rH&J\u001e\u0010\u0018\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u000e2\u000e\b\u0001\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\rH&R$\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/luck/picture/lib/registry/BaseRegistry;", "", "()V", "transcoders", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/luck/picture/lib/registry/BaseRegistry$Entry;", "getTranscoders", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "setTranscoders", "(Ljava/util/concurrent/CopyOnWriteArrayList;)V", "clear", "", "get", "Ljava/lang/Class;", "Model", "targetClass", "isAssignableFromAdapter", "", "A", "isAssignableFromCapture", "V", "isAssignableFromFragment", "isAssignableFromHolder", "register", "unregister", "Entry", "selector_release"})
public abstract class BaseRegistry {
    @NotNull
    private CopyOnWriteArrayList<Entry<?>> transcoders = new CopyOnWriteArrayList();

    @NotNull
    public final CopyOnWriteArrayList<Entry<?>> getTranscoders() {
        return this.transcoders;
    }

    public final void setTranscoders(@NotNull CopyOnWriteArrayList<Entry<?>> copyOnWriteArrayList) {
        Intrinsics.checkNotNullParameter(copyOnWriteArrayList, (String)"<set-?>");
        this.transcoders = copyOnWriteArrayList;
    }

    public abstract <Model> void register(@NonNull @NotNull Class<Model> var1);

    public abstract <Model> void unregister(@NonNull @NotNull Class<Model> var1);

    @NotNull
    public abstract <Model> Class<Model> get(@NonNull @NotNull Class<Model> var1);

    public final <V> boolean isAssignableFromCapture(@NotNull Class<V> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        return VideoCaptureComponent.class.isAssignableFrom(targetClass) || ImageCaptureComponent.class.isAssignableFrom(targetClass) || SoundCaptureComponent.class.isAssignableFrom(targetClass);
    }

    public final <V> boolean isAssignableFromHolder(@NotNull Class<V> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        return BaseListViewHolder.class.isAssignableFrom(targetClass) || BasePreviewMediaHolder.class.isAssignableFrom(targetClass);
    }

    public final <V> boolean isAssignableFromFragment(@NotNull Class<V> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        return BaseSelectorFragment.class.isAssignableFrom(targetClass);
    }

    public final <A> boolean isAssignableFromAdapter(@NotNull Class<A> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        return BaseMediaListAdapter.class.isAssignableFrom(targetClass) || MediaPreviewAdapter.class.isAssignableFrom(targetClass);
    }

    public void clear() {
        if (!((Collection)this.transcoders).isEmpty()) {
            this.transcoders.clear();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\t\u001a\u00020\n2\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u000b"}, d2={"Lcom/luck/picture/lib/registry/BaseRegistry$Entry;", "Model", "", "fromClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "getFromClass", "()Ljava/lang/Class;", "setFromClass", "handles", "", "selector_release"})
    public static final class Entry<Model> {
        @NotNull
        private Class<Model> fromClass;

        public Entry(@NotNull Class<Model> fromClass) {
            Intrinsics.checkNotNullParameter(fromClass, (String)"fromClass");
            this.fromClass = fromClass;
        }

        @NotNull
        public final Class<Model> getFromClass() {
            return this.fromClass;
        }

        public final void setFromClass(@NotNull Class<Model> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"<set-?>");
            this.fromClass = clazz;
        }

        public final boolean handles(@NotNull Class<?> fromClass) {
            Intrinsics.checkNotNullParameter(fromClass, (String)"fromClass");
            return fromClass.isAssignableFrom(this.fromClass);
        }
    }
}

