/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.registry;

import com.luck.picture.lib.registry.AdapterRegistry;
import com.luck.picture.lib.registry.BaseRegistry;
import com.luck.picture.lib.registry.CaptureRegistry;
import com.luck.picture.lib.registry.FragmentRegistry;
import com.luck.picture.lib.registry.ViewHolderRegistry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000eH\u0016J\u001c\u0010\u0011\u001a\u00020\f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000eH\u0016J\u001c\u0010\u0012\u001a\u00020\f\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/luck/picture/lib/registry/Registry;", "Lcom/luck/picture/lib/registry/BaseRegistry;", "()V", "adapterRegistry", "Lcom/luck/picture/lib/registry/AdapterRegistry;", "captureRegistry", "Lcom/luck/picture/lib/registry/CaptureRegistry;", "fragmentRegistry", "Lcom/luck/picture/lib/registry/FragmentRegistry;", "viewHolderRegistry", "Lcom/luck/picture/lib/registry/ViewHolderRegistry;", "clear", "", "get", "Ljava/lang/Class;", "Model", "targetClass", "register", "unregister", "selector_release"})
public final class Registry
extends BaseRegistry {
    @NotNull
    private CaptureRegistry captureRegistry = new CaptureRegistry();
    @NotNull
    private AdapterRegistry adapterRegistry = new AdapterRegistry();
    @NotNull
    private FragmentRegistry fragmentRegistry = new FragmentRegistry();
    @NotNull
    private ViewHolderRegistry viewHolderRegistry = new ViewHolderRegistry();

    @Override
    public <Model> void register(@NotNull Class<Model> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        if (this.isAssignableFromCapture(targetClass)) {
            this.captureRegistry.register(targetClass);
        } else if (this.isAssignableFromFragment(targetClass)) {
            this.fragmentRegistry.register(targetClass);
        } else if (this.isAssignableFromHolder(targetClass)) {
            this.viewHolderRegistry.register(targetClass);
        } else if (this.isAssignableFromAdapter(targetClass)) {
            this.adapterRegistry.register(targetClass);
        }
    }

    @Override
    public <Model> void unregister(@NotNull Class<Model> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        if (this.isAssignableFromCapture(targetClass)) {
            this.captureRegistry.unregister(targetClass);
        } else if (this.isAssignableFromFragment(targetClass)) {
            this.fragmentRegistry.unregister(targetClass);
        } else if (this.isAssignableFromHolder(targetClass)) {
            this.viewHolderRegistry.unregister(targetClass);
        } else if (this.isAssignableFromAdapter(targetClass)) {
            this.adapterRegistry.unregister(targetClass);
        }
    }

    @Override
    @NotNull
    public <Model> Class<Model> get(@NotNull Class<Model> targetClass) {
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        if (this.isAssignableFromCapture(targetClass)) {
            return this.captureRegistry.get(targetClass);
        }
        if (this.isAssignableFromFragment(targetClass)) {
            return this.fragmentRegistry.get(targetClass);
        }
        if (this.isAssignableFromHolder(targetClass)) {
            return this.viewHolderRegistry.get(targetClass);
        }
        if (this.isAssignableFromAdapter(targetClass)) {
            return this.adapterRegistry.get(targetClass);
        }
        throw new IllegalStateException(targetClass + " not found");
    }

    @Override
    public void clear() {
        this.captureRegistry.clear();
        this.adapterRegistry.clear();
        this.fragmentRegistry.clear();
        this.viewHolderRegistry.clear();
    }
}

