/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/luck/picture/lib/utils/BitmapUtils;", "", "()V", "ARGB_8888_MEMORY_BYTE", "", "MAX_BITMAP_SIZE", "computeSize", "width", "height", "getComputeImageSize", "", "imageWidth", "imageHeight", "getTotalMemory", "", "selector_release"})
public final class BitmapUtils {
    @NotNull
    public static final BitmapUtils INSTANCE = new BitmapUtils();
    private static final int ARGB_8888_MEMORY_BYTE = 4;
    private static final int MAX_BITMAP_SIZE = 0x6400000;

    private BitmapUtils() {
    }

    @NotNull
    public final int[] getComputeImageSize(int imageWidth, int imageHeight) {
        int maxWidth = -1;
        int maxHeight = -1;
        if (imageWidth == 0 && imageHeight == 0) {
            int[] nArray = new int[]{maxWidth, maxHeight};
            return nArray;
        }
        int inSampleSize = this.computeSize(imageWidth, imageHeight);
        long totalMemory = this.getTotalMemory();
        boolean decodeAttemptSuccess = false;
        while (!decodeAttemptSuccess) {
            maxWidth = imageWidth / inSampleSize;
            maxHeight = imageHeight / inSampleSize;
            int bitmapSize = maxWidth * maxHeight * 4;
            if ((long)bitmapSize > totalMemory) {
                inSampleSize *= 2;
                continue;
            }
            decodeAttemptSuccess = true;
        }
        int[] nArray = new int[]{maxWidth, maxHeight};
        return nArray;
    }

    private final int computeSize(int width, int height) {
        int srcWidth = width;
        int srcHeight = height;
        srcWidth = srcWidth % 2 == 1 ? srcWidth + 1 : srcWidth;
        srcHeight = srcHeight % 2 == 1 ? srcHeight + 1 : srcHeight;
        int longSide = Math.max(srcWidth, srcHeight);
        int shortSide = Math.min(srcWidth, srcHeight);
        float scale = (float)shortSide / (float)longSide;
        return scale <= 1.0f && (double)scale > 0.5625 ? (longSide < 1664 ? 1 : (longSide < 4990 ? 2 : ((4991 <= longSide ? longSide < 10240 : false) ? 4 : longSide / 1280))) : ((double)scale <= 0.5625 && (double)scale > 0.5 ? (longSide / 1280 == 0 ? 1 : longSide / 1280) : (int)Math.ceil((double)longSide / (1280.0 / (double)scale)));
    }

    private final long getTotalMemory() {
        long totalMemory = Runtime.getRuntime().totalMemory();
        return totalMemory > 0x6400000L ? 0x6400000L : totalMemory;
    }
}

