/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.content.Context;
import com.luck.picture.lib.R;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nJ\b\u0010\u0011\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fJ\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\fJ\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/luck/picture/lib/utils/DateUtils;", "", "()V", "sdfYear", "Ljava/text/SimpleDateFormat;", "sf", "getSf", "()Ljava/text/SimpleDateFormat;", "sfYm", "dateDiffer", "", "duration", "", "formatDurationTime", "", "timeMs", "isAdjust", "getCurrentTimeMillis", "getDataFormat", "context", "Landroid/content/Context;", "time", "getYearDataFormat", "isThisMonth", "isThisWeek", "selector_release"})
public final class DateUtils {
    @NotNull
    public static final DateUtils INSTANCE = new DateUtils();
    @NotNull
    private static final SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ENGLISH);
    @NotNull
    private static final SimpleDateFormat sdfYear = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    @NotNull
    private static final SimpleDateFormat sfYm = new SimpleDateFormat("yyyy-MM", Locale.ENGLISH);

    private DateUtils() {
    }

    @NotNull
    public final SimpleDateFormat getSf() {
        return sf;
    }

    @NotNull
    public final String formatDurationTime(long timeMs) {
        return this.formatDurationTime(timeMs, true);
    }

    @NotNull
    public final String formatDurationTime(long timeMs, boolean isAdjust) {
        String string2;
        if (isAdjust && timeMs < 1000L) {
            Locale locale = Locale.getDefault();
            String string3 = "%s%02d:%02d";
            Object[] objectArray = new Object[]{"", 0, 1};
            String string4 = String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(locale, format, *args)");
            return string4;
        }
        String prefix = timeMs < 0L ? "-" : "";
        long absTimeMs = Math.abs(timeMs);
        long totalSeconds = absTimeMs / (long)1000;
        long seconds = totalSeconds % (long)60;
        long minutes = totalSeconds / (long)60 % (long)60;
        long hours = totalSeconds / (long)3600;
        if (hours > 0L) {
            Locale locale = Locale.getDefault();
            String string5 = "%s%d:%02d:%02d";
            Object[] objectArray = new Object[]{prefix, hours, minutes, seconds};
            String string6 = String.format(locale, string5, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(locale, format, *args)");
        } else {
            Locale locale = Locale.getDefault();
            String string7 = "%s%02d:%02d";
            Object[] objectArray = new Object[]{prefix, minutes, seconds};
            String string8 = String.format(locale, string7, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(locale, format, *args)");
        }
        return string2;
    }

    @NotNull
    public final String getYearDataFormat(long time) {
        long newTime = String.valueOf(time).length() > 10 ? time : time * (long)1000;
        String string2 = sdfYear.format(newTime);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdfYear.format(newTime)");
        return string2;
    }

    @Nullable
    public final String getDataFormat(@NotNull Context context, long time) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        long newTime = String.valueOf(time).length() > 10 ? time : time * (long)1000;
        return this.isThisWeek(newTime) ? context.getString(R.string.ps_current_week) : (this.isThisMonth(newTime) ? context.getString(R.string.ps_current_month) : sfYm.format(newTime));
    }

    private final boolean isThisWeek(long time) {
        Calendar calendar = Calendar.getInstance();
        int currentWeek = calendar.get(3);
        calendar.setTime(new Date(time));
        int paramWeek = calendar.get(3);
        return paramWeek == currentWeek;
    }

    private final boolean isThisMonth(long time) {
        Date date = new Date(time);
        String string2 = sfYm.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sfYm.format(date)");
        String param = string2;
        String string3 = sfYm.format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sfYm.format(Date())");
        String now = string3;
        return Intrinsics.areEqual((Object)param, (Object)now);
    }

    public final boolean dateDiffer(long duration) {
        return (int)Math.abs(this.getCurrentTimeMillis() - duration) <= 1;
    }

    private final long getCurrentTimeMillis() {
        long l;
        String timeToString = String.valueOf(System.currentTimeMillis());
        if (timeToString.length() > 10) {
            String string2 = timeToString.substring(0, 10);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            l = Long.parseLong(string2);
        } else {
            l = Long.parseLong(timeToString);
        }
        return l;
    }
}

