/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import com.luck.picture.lib.immersive.RomUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\r\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\b\u0010\u0016\u001a\u00020\u0004H\u0002J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u001b"}, d2={"Lcom/luck/picture/lib/utils/DensityUtil;", "", "()V", "dip2px", "", "context", "Landroid/content/Context;", "dpValue", "", "getInternalDimensionSize", "key", "", "getNavigationBarHeight", "getNavigationBarWidth", "getRealScreenHeight", "getRealScreenWidth", "getResNameById", "id", "getScreenHeight", "getSmallestWidthDp", "activity", "Landroid/app/Activity;", "getStatusBarHeight", "getStatusNavigationBarHeight", "isNavBarVisible", "", "isNavigationAtBottom", "selector_release"})
public final class DensityUtil {
    @NotNull
    public static final DensityUtil INSTANCE = new DensityUtil();

    private DensityUtil() {
    }

    public final int dip2px(@NotNull Context context, float dpValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float scale = context.getApplicationContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public final int getRealScreenWidth(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getApplicationContext().getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Point point = new Point();
        wm.getDefaultDisplay().getRealSize(point);
        return point.x;
    }

    public final int getRealScreenHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getApplicationContext().getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Point point = new Point();
        wm.getDefaultDisplay().getRealSize(point);
        return point.y;
    }

    public final int getScreenHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getRealScreenHeight(context) - this.getStatusNavigationBarHeight(context);
    }

    private final int getStatusNavigationBarHeight(Context context) {
        return this.isNavBarVisible(context) ? this.getStatusBarHeight(context) + this.getNavigationBarHeight(context) : this.getStatusBarHeight(context);
    }

    public final int getStatusBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int result = 0;
        Resources resources = Resources.getSystem();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        try {
            if (resourceId > 0) {
                float densityOne;
                float densityTwo;
                float f;
                int sizeOne = context.getResources().getDimensionPixelSize(resourceId);
                int sizeTwo = resources.getDimensionPixelSize(resourceId);
                result = sizeTwo >= sizeOne ? sizeTwo : ((f = (float)sizeOne * (densityTwo = resources.getDisplayMetrics().density) / (densityOne = context.getResources().getDisplayMetrics().density)) >= 0.0f ? (int)(f + 0.5f) : (int)(f - 0.5f));
            }
        }
        catch (Exception ignored) {
            result = this.getStatusBarHeight();
        }
        return result == 0 ? this.dip2px(context, 26.0f) : result;
    }

    private final int getStatusBarHeight() {
        Resources resources = Resources.getSystem();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    public final boolean isNavigationAtBottom(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Resources res = activity.getResources();
        boolean mInPortrait = res.getConfiguration().orientation == 1;
        return this.getSmallestWidthDp(activity) >= 600.0f || mInPortrait;
    }

    @SuppressLint(value={"NewApi"})
    private final float getSmallestWidthDp(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 16) {
            activity.getWindowManager().getDefaultDisplay().getRealMetrics(metrics);
        } else {
            activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        }
        float widthDp = (float)metrics.widthPixels / metrics.density;
        float heightDp = (float)metrics.heightPixels / metrics.density;
        return Math.min(widthDp, heightDp);
    }

    @TargetApi(value=14)
    public final int getNavigationBarWidth(@Nullable Context context) {
        int result = 0;
        if (Build.VERSION.SDK_INT >= 14 && this.isNavBarVisible(context)) {
            Context context2 = context;
            Intrinsics.checkNotNull((Object)context2);
            return this.getInternalDimensionSize(context2, "navigation_bar_width");
        }
        return result;
    }

    @TargetApi(value=14)
    public final int getNavigationBarHeight(@NotNull Context context) {
        boolean mInPortrait;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int result = 0;
        Resources res = context.getResources();
        boolean bl = mInPortrait = res.getConfiguration().orientation == 1;
        if (this.isNavBarVisible(context)) {
            String key = mInPortrait ? "navigation_bar_height" : "navigation_bar_height_landscape";
            return this.getInternalDimensionSize(context, key);
        }
        return result;
    }

    private final int getInternalDimensionSize(Context context, String key) {
        int result = 0;
        try {
            int resourceId = Resources.getSystem().getIdentifier(key, "dimen", "android");
            if (resourceId > 0) {
                float densityOne;
                float densityTwo;
                float f;
                int sizeOne = context.getResources().getDimensionPixelSize(resourceId);
                int sizeTwo = Resources.getSystem().getDimensionPixelSize(resourceId);
                return sizeTwo >= sizeOne ? sizeTwo : (int)((f = (float)sizeOne * (densityTwo = Resources.getSystem().getDisplayMetrics().density) / (densityOne = context.getResources().getDisplayMetrics().density)) >= 0.0f ? f + 0.5f : f - 0.5f);
            }
        }
        catch (Resources.NotFoundException ignored) {
            return 0;
        }
        return result;
    }

    public final boolean isNavBarVisible(@Nullable Context context) {
        boolean isVisible = false;
        if (!(context instanceof Activity)) {
            return false;
        }
        Window window = ((Activity)context).getWindow();
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        int count = decorView.getChildCount();
        for (int i = 0; i < count; ++i) {
            String resourceEntryName;
            View child = decorView.getChildAt(i);
            int id2 = child.getId();
            if (id2 == -1 || !Intrinsics.areEqual((Object)"navigationBarBackground", (Object)(resourceEntryName = String.valueOf(this.getResNameById(context, id2)))) || child.getVisibility() != 0) continue;
            isVisible = true;
            break;
        }
        if (isVisible) {
            int visibility;
            if (RomUtils.INSTANCE.isSamsung() && Build.VERSION.SDK_INT >= 17 && Build.VERSION.SDK_INT < 29) {
                try {
                    return Settings.Global.getInt((ContentResolver)((Activity)context).getContentResolver(), (String)"navigationbar_hide_bar_enabled") == 0;
                }
                catch (Exception child) {
                    // empty catch block
                }
            }
            isVisible = ((visibility = decorView.getSystemUiVisibility()) & 2) == 0;
        }
        return isVisible;
    }

    private final String getResNameById(Context context, int id2) {
        String string2;
        try {
            Resources resources = context.getResources();
            string2 = resources != null ? resources.getResourceEntryName(id2) : null;
        }
        catch (Exception ignore) {
            string2 = "";
        }
        return string2;
    }
}

