/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.content.Context;
import android.net.Uri;
import com.luck.picture.lib.utils.DateUtils;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.ValueOf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J \u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006\u0018"}, d2={"Lcom/luck/picture/lib/utils/FileUtils;", "", "()V", "close", "", "c", "Ljava/io/Closeable;", "copyFile", "", "context", "Landroid/content/Context;", "from", "target", "createFileName", "tag", "formatAccurateUnitFileSize", "byteSize", "", "writeFileFromIS", "", "input", "Ljava/io/InputStream;", "os", "Ljava/io/OutputStream;", "selector_release"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String copyFile(@NotNull Context context, @NotNull String from, @NotNull String target) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        BufferedInputStream inBuffer = null;
        BufferedOutputStream osBuffer = null;
        InputStream fileInputStream = null;
        try {
            fileInputStream = MediaUtils.INSTANCE.isContent(from) ? context.getContentResolver().openInputStream(Uri.parse((String)from)) : (InputStream)new FileInputStream(from);
            inBuffer = new BufferedInputStream(fileInputStream);
            osBuffer = new BufferedOutputStream(new FileOutputStream(target));
            byte[] data = new byte[1024];
            int len = 0;
            while (true) {
                int n;
                int it = n = inBuffer.read(data);
                boolean bl = false;
                len = it;
                if (n == -1) break;
                osBuffer.write(data, 0, len);
            }
            osBuffer.flush();
            string2 = target;
        }
        catch (Exception e) {
            e.printStackTrace();
            string2 = null;
        }
        finally {
            this.close(inBuffer);
            this.close(osBuffer);
            this.close(fileInputStream);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean writeFileFromIS(@NotNull InputStream input, @NotNull OutputStream os) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        OutputStream osBuffer = null;
        BufferedInputStream isBuffer = null;
        try {
            isBuffer = new BufferedInputStream(input);
            osBuffer = new BufferedOutputStream(os);
            byte[] data = new byte[1024];
            int len = 0;
            while (true) {
                int n;
                int it = n = isBuffer.read(data);
                boolean bl2 = false;
                len = it;
                if (n == -1) break;
                os.write(data, 0, len);
            }
            os.flush();
            bl = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            bl = false;
        }
        finally {
            this.close(isBuffer);
            this.close(osBuffer);
        }
        return bl;
    }

    @NotNull
    public final String createFileName(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return tag + '_' + DateUtils.INSTANCE.getSf().format(System.currentTimeMillis());
    }

    @NotNull
    public final String formatAccurateUnitFileSize(long byteSize) {
        String unit = "";
        double newByteSize = 0.0;
        if (!(byteSize >= 0L)) {
            boolean bl = false;
            String string2 = "byteSize shouldn't be less than zero!";
            throw new IllegalArgumentException(string2.toString());
        }
        if (byteSize < 1000L) {
            newByteSize = byteSize;
        } else if (byteSize < 1000000L) {
            unit = "KB";
            newByteSize = (double)byteSize / (double)1000;
        } else if (byteSize < 1000000000L) {
            unit = "MB";
            newByteSize = (double)byteSize / (double)1000000;
        } else {
            unit = "GB";
            newByteSize = (double)byteSize / (double)1000000000;
        }
        Locale locale = new Locale("zh");
        String string3 = "%.2f";
        Object[] objectArray = new Object[]{newByteSize};
        String string4 = String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(locale, format, *args)");
        String format = string4;
        return ((double)MathKt.roundToInt((double)ValueOf.toDouble$default(ValueOf.INSTANCE, format, 0, 2, null)) - ValueOf.toDouble$default(ValueOf.INSTANCE, format, 0, 2, null) == 0.0 ? Integer.valueOf(MathKt.roundToInt((double)ValueOf.toDouble$default(ValueOf.INSTANCE, format, 0, 2, null))) : format) + unit;
    }

    public final void close(@Nullable Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

