/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import com.luck.picture.lib.utils.SdkVersionUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/luck/picture/lib/utils/MediaStoreUtils;", "", "()V", "insertImage", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "fileName", "", "insertVideo", "selector_release"})
public final class MediaStoreUtils {
    @NotNull
    public static final MediaStoreUtils INSTANCE = new MediaStoreUtils();

    private MediaStoreUtils() {
    }

    @Nullable
    public final Uri insertImage(@NotNull Context context, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        ContentValues values = new ContentValues(3);
        values.put("_display_name", fileName);
        values.put("mime_type", "image/jpg");
        if (SdkVersionUtils.INSTANCE.isQ()) {
            values.put("datetaken", Long.valueOf(System.currentTimeMillis()));
            values.put("relative_path", Environment.DIRECTORY_DCIM + "/Camera");
        }
        return Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted") ? context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values) : context.getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, values);
    }

    @Nullable
    public final Uri insertVideo(@NotNull Context context, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        ContentValues values = new ContentValues(3);
        values.put("_display_name", fileName);
        values.put("mime_type", "video/mp4");
        if (SdkVersionUtils.INSTANCE.isQ()) {
            values.put("datetaken", Long.valueOf(System.currentTimeMillis()));
            values.put("relative_path", Environment.DIRECTORY_MOVIES);
        }
        return Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted") ? context.getContentResolver().insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, values) : context.getContentResolver().insert(MediaStore.Video.Media.INTERNAL_CONTENT_URI, values);
    }
}

