/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.media.ExifInterface;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import androidx.core.content.FileProvider;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.MediaInfo;
import com.luck.picture.lib.utils.DateUtils;
import com.luck.picture.lib.utils.FileUtils;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.SelectorLogUtils;
import com.luck.picture.lib.utils.ValueOf;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b#\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J!\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0006H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J#\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0006H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0006H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J9\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\u001dJ!\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0006H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J+\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010 \u001a\u00020\u0006H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\u0012\u0010#\u001a\u0004\u0018\u00010\u00062\b\u0010 \u001a\u0004\u0018\u00010\u0006J\u0018\u0010$\u001a\u0004\u0018\u00010\u00062\u0006\u0010%\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010&\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0006J\u0013\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002\u00a2\u0006\u0002\u0010)J\u0018\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\u0006J\u0012\u0010,\u001a\u0004\u0018\u00010\u00062\b\u0010-\u001a\u0004\u0018\u00010\u0006J\u0010\u0010.\u001a\u00020/2\b\u0010!\u001a\u0004\u0018\u00010\u0006J\u0010\u00100\u001a\u00020/2\b\u0010!\u001a\u0004\u0018\u00010\u0006J\u0010\u00101\u001a\u00020/2\b\u0010!\u001a\u0004\u0018\u00010\u0006J\u0010\u00102\u001a\u00020/2\b\u0010!\u001a\u0004\u0018\u00010\u0006J\u0010\u00103\u001a\u00020/2\b\u0010-\u001a\u0004\u0018\u00010\u0006J\u000e\u00104\u001a\u00020/2\u0006\u0010-\u001a\u00020\u0006J\u0010\u00105\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u00106\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u00107\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u00108\u001a\u00020/2\b\u0010!\u001a\u0004\u0018\u00010\u0006J\u0010\u00109\u001a\u00020/2\b\u0010!\u001a\u0004\u0018\u00010\u0006J\u0010\u0010:\u001a\u00020/2\b\u0010!\u001a\u0004\u0018\u00010\u0006J\u000e\u0010;\u001a\u00020/2\u0006\u0010 \u001a\u00020\u0006J\u0010\u0010<\u001a\u00020/2\b\u0010!\u001a\u0004\u0018\u00010\u0006J\u0016\u0010=\u001a\u00020/2\u0006\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\nJ\u0010\u0010@\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010A\u001a\u00020/2\b\u0010-\u001a\u0004\u0018\u00010\u0006J\u0010\u0010B\u001a\u00020/2\b\u0010-\u001a\u0004\u0018\u00010\u0006J\u0006\u0010C\u001a\u00020\u0006J\u0006\u0010D\u001a\u00020\u0006J\u0006\u0010E\u001a\u00020\u0006J\u0006\u0010F\u001a\u00020\u0006J\u0006\u0010G\u001a\u00020\u0006J\u0006\u0010H\u001a\u00020\u0006J\u0006\u0010I\u001a\u00020\u0006J\u0006\u0010J\u001a\u00020\u0006J\u0006\u0010K\u001a\u00020\u0006J\u0006\u0010L\u001a\u00020\u0006J\u0006\u0010M\u001a\u00020\u0006J\u0006\u0010N\u001a\u00020\u0006J\u0006\u0010O\u001a\u00020\u0006J\u0006\u0010P\u001a\u00020\u0006J\u0016\u0010Q\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010R\u001a\u00020SJ\u0016\u0010T\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u001a\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006U"}, d2={"Lcom/luck/picture/lib/utils/MediaUtils;", "", "()V", "createQueryArgsBundle", "Landroid/os/Bundle;", "selection", "", "selectionArgs", "", "limitCount", "", "offset", "orderBy", "(Ljava/lang/String;[Ljava/lang/String;IILjava/lang/String;)Landroid/os/Bundle;", "deleteUri", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "getAssignFileMedia", "Lcom/luck/picture/lib/entity/LocalMedia;", "absolutePath", "(Landroid/content/Context;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAssignPathMedia", "getDCIMLastId", "", "absoluteDir", "getDataColumn", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getMediaInfo", "Lcom/luck/picture/lib/entity/MediaInfo;", "path", "mimeType", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMimeType", "getPath", "ctx", "getPostfix", "defPostfix", "getProjection", "()[Ljava/lang/String;", "getRealPathUri", "id", "getUrlMimeType", "url", "hasMimeTypeOfAudio", "", "hasMimeTypeOfImage", "hasMimeTypeOfUnknown", "hasMimeTypeOfVideo", "hasUrlOfVideo", "isContent", "isDownloadsDocument", "isExternalStorageDocument", "isGooglePhotosUri", "isHasBMP", "isHasGif", "isHasHeic", "isHasHttp", "isHasWebp", "isLongImage", "width", "height", "isMediaDocument", "isUrlHasGif", "isUrlHasWebp", "of3GP", "ofAVI", "ofBMP", "ofGIF", "ofHeic", "ofJPEG", "ofJPG", "ofMP4", "ofMPEG", "ofPNG", "ofVNDBMP", "ofWebm", "ofWebp", "ofXMSBMP", "parUri", "cameraFile", "Ljava/io/File;", "remove", "selector_release"})
public final class MediaUtils {
    @NotNull
    public static final MediaUtils INSTANCE = new MediaUtils();

    private MediaUtils() {
    }

    public final boolean hasMimeTypeOfImage(@Nullable String mimeType) {
        return mimeType != null && StringsKt.startsWith$default((String)mimeType, (String)"image", (boolean)false, (int)2, null);
    }

    public final boolean hasMimeTypeOfVideo(@Nullable String mimeType) {
        return mimeType != null && StringsKt.startsWith$default((String)mimeType, (String)"video", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasUrlOfVideo(@Nullable String url) {
        if (url == null) return false;
        String string2 = url;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.endsWith$default((String)string3, (String)".mp4", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean hasMimeTypeOfAudio(@Nullable String mimeType) {
        return mimeType != null && StringsKt.startsWith$default((String)mimeType, (String)"audio", (boolean)false, (int)2, null);
    }

    public final boolean hasMimeTypeOfUnknown(@Nullable String mimeType) {
        return mimeType != null && StringsKt.startsWith$default((String)mimeType, (String)"image/*", (boolean)false, (int)2, null);
    }

    public final boolean isLongImage(int width, int height) {
        return width <= 0 || height <= 0 ? false : height > width * 3;
    }

    public final boolean isHasGif(@Nullable String mimeType) {
        return mimeType != null && (Intrinsics.areEqual((Object)mimeType, (Object)"image/gif") || Intrinsics.areEqual((Object)mimeType, (Object)"image/GIF"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUrlHasGif(@Nullable String url) {
        if (url == null) return false;
        String string2 = url;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.endsWith$default((String)string3, (String)".gif", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean isHasWebp(@Nullable String mimeType) {
        return mimeType != null && Intrinsics.areEqual((Object)mimeType, (Object)"image/webp");
    }

    public final boolean isHasBMP(@Nullable String mimeType) {
        return mimeType != null && Intrinsics.areEqual((Object)mimeType, (Object)"image/bmp");
    }

    public final boolean isHasHeic(@Nullable String mimeType) {
        return mimeType != null && Intrinsics.areEqual((Object)mimeType, (Object)"image/heic");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUrlHasWebp(@Nullable String url) {
        if (url == null) return false;
        String string2 = url;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        if (!StringsKt.endsWith$default((String)string3, (String)".webp", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public final boolean isHasHttp(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return TextUtils.isEmpty((CharSequence)path) ? false : StringsKt.startsWith$default((String)path, (String)"http", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path, (String)"https", (boolean)false, (int)2, null);
    }

    public final boolean isContent(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return TextUtils.isEmpty((CharSequence)url) ? false : StringsKt.startsWith$default((String)url, (String)"content://", (boolean)false, (int)2, null);
    }

    @NotNull
    public final String ofGIF() {
        return "image/gif";
    }

    @NotNull
    public final String ofBMP() {
        return "image/bmp";
    }

    @NotNull
    public final String ofXMSBMP() {
        return "image/x-ms-bmp";
    }

    @NotNull
    public final String ofVNDBMP() {
        return "image/vnd.wap.wbmp";
    }

    @NotNull
    public final String ofHeic() {
        return "image/heic";
    }

    @NotNull
    public final String ofWebp() {
        return "image/webp";
    }

    @NotNull
    public final String ofJPEG() {
        return "image/jpeg";
    }

    @NotNull
    public final String ofJPG() {
        return "image/jpg";
    }

    @NotNull
    public final String ofPNG() {
        return "image/png";
    }

    @NotNull
    public final String of3GP() {
        return "video/3gp";
    }

    @NotNull
    public final String ofMP4() {
        return "video/mp4";
    }

    @NotNull
    public final String ofWebm() {
        return "video/webm";
    }

    @NotNull
    public final String ofAVI() {
        return "video/avi";
    }

    @NotNull
    public final String ofMPEG() {
        return "video/mpeg";
    }

    @Nullable
    public final String getUrlMimeType(@Nullable String url) {
        String postfix;
        if (url == null || TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        String string2 = url.substring(StringsKt.lastIndexOf$default((CharSequence)url, (String)".", (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        String string3 = postfix = string2;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
        String lowercase = string4;
        if (Intrinsics.areEqual((Object)lowercase, (Object)"jpg") || Intrinsics.areEqual((Object)lowercase, (Object)"jpeg") || Intrinsics.areEqual((Object)lowercase, (Object)"png") || Intrinsics.areEqual((Object)lowercase, (Object)"gif") || Intrinsics.areEqual((Object)lowercase, (Object)"webp") || Intrinsics.areEqual((Object)lowercase, (Object)"bmp")) {
            return "image/" + postfix;
        }
        if (Intrinsics.areEqual((Object)lowercase, (Object)"mp4") || Intrinsics.areEqual((Object)lowercase, (Object)"avi")) {
            return "video/" + postfix;
        }
        if (Intrinsics.areEqual((Object)lowercase, (Object)"mp3") || Intrinsics.areEqual((Object)lowercase, (Object)"amr") || Intrinsics.areEqual((Object)postfix, (Object)"m4a")) {
            return "audio/" + postfix;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getMimeType(@Nullable String path) {
        String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)path);
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        Intrinsics.checkNotNullExpressionValue((Object)fileExtension, (String)"fileExtension");
        String string2 = fileExtension;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String mimeType = mimeTypeMap.getMimeTypeFromExtension(string3);
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            String string4;
            FileNameMap fileNameMap;
            FileNameMap fileNameMap2 = fileNameMap = URLConnection.getFileNameMap();
            String string5 = path;
            if (string5 != null) {
                void it;
                String string6 = string5;
                FileNameMap fileNameMap3 = fileNameMap2;
                boolean bl = false;
                string4 = new File((String)it).getName();
                fileNameMap2 = fileNameMap3;
            } else {
                string4 = null;
            }
            mimeType = fileNameMap2.getContentTypeFor(string4);
        }
        return mimeType;
    }

    @NotNull
    public final String getRealPathUri(long id2, @Nullable String mimeType) {
        Uri uri;
        if (this.hasMimeTypeOfImage(mimeType)) {
            Uri uri2 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            uri = uri2;
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"{\n                MediaS\u2026CONTENT_URI\n            }");
        } else if (this.hasMimeTypeOfVideo(mimeType)) {
            Uri uri3 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            uri = uri3;
            Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"{\n                MediaS\u2026CONTENT_URI\n            }");
        } else if (this.hasMimeTypeOfAudio(mimeType)) {
            Uri uri4 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
            uri = uri4;
            Intrinsics.checkNotNullExpressionValue((Object)uri4, (String)"{\n                MediaS\u2026CONTENT_URI\n            }");
        } else {
            Uri uri5 = MediaStore.Files.getContentUri((String)"external");
            uri = uri5;
            Intrinsics.checkNotNullExpressionValue((Object)uri5, (String)"{\n                MediaS\u2026\"external\")\n            }");
        }
        Uri contentUri = uri;
        String string2 = ContentUris.withAppendedId((Uri)contentUri, (long)id2).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"withAppendedId(contentUri, id).toString()");
        return string2;
    }

    @NotNull
    public final String getPostfix(@NotNull Context context, @NotNull String path, @NotNull String defPostfix) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)defPostfix, (String)"defPostfix");
        if (this.isContent(path)) {
            Uri uri = Uri.parse((String)path);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(path)");
            String realPath = this.getPath(context, uri);
            if (realPath == null || TextUtils.isEmpty((CharSequence)realPath)) {
                string2 = defPostfix;
            } else {
                String string3 = realPath.substring(StringsKt.lastIndexOf$default((CharSequence)realPath, (String)".", (int)0, (boolean)false, (int)6, null) + 1);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            }
        } else {
            String string4 = path.substring(StringsKt.lastIndexOf$default((CharSequence)path, (String)".", (int)0, (boolean)false, (int)6, null) + 1);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
        }
        return string2;
    }

    @NotNull
    public final Bundle createQueryArgsBundle(@NotNull String selection, @NotNull String[] selectionArgs, int limitCount, int offset, @Nullable String orderBy) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)selectionArgs, (String)"selectionArgs");
        Bundle queryArgs = new Bundle();
        if (SdkVersionUtils.INSTANCE.isO()) {
            queryArgs.putString("android:query-arg-sql-selection", selection);
            queryArgs.putStringArray("android:query-arg-sql-selection-args", selectionArgs);
            queryArgs.putString("android:query-arg-sql-sort-order", orderBy);
        }
        if (SdkVersionUtils.INSTANCE.isR()) {
            queryArgs.putString("android:query-arg-sql-limit", limitCount + " offset " + offset);
        }
        return queryArgs;
    }

    @Nullable
    public final Object getMediaInfo(@NotNull Context context, @NotNull String path, @NotNull Continuation<? super MediaInfo> $completion) {
        return this.getMediaInfo(context, this.getMimeType(path), path, $completion);
    }

    @Nullable
    public final Object getMediaInfo(@NotNull Context context, @Nullable String mimeType, @NotNull String path, @NotNull Continuation<? super MediaInfo> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MediaInfo>, Object>(mimeType, path, context, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ String $mimeType;
            final /* synthetic */ String $path;
            final /* synthetic */ Context $context;
            {
                this.$mimeType = $mimeType;
                this.$path = $path;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        String string2 = this.$mimeType;
                        String string3 = this.$path;
                        Context context = this.$context;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        this.L$0 = string2;
                        this.L$1 = string3;
                        this.L$2 = context;
                        this.label = 1;
                        Continuation uCont$iv = (Continuation)this;
                        boolean bl = false;
                        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted((Continuation)uCont$iv), 1);
                        cancellable$iv.initCancellability();
                        CancellableContinuation it = (CancellableContinuation)cancellable$iv;
                        boolean bl2 = false;
                        MediaInfo mediaInfo = new MediaInfo();
                        mediaInfo.setMimeType(string2);
                        if (MediaUtils.INSTANCE.hasMimeTypeOfImage(string2)) {
                            ExifInterface exif = null;
                            InputStream inputStream = null;
                            if (MediaUtils.INSTANCE.isContent(string3)) {
                                inputStream = context.getContentResolver().openInputStream(Uri.parse((String)string3));
                                if (Build.VERSION.SDK_INT >= 24 && inputStream != null) {
                                    exif = new ExifInterface(inputStream);
                                }
                            } else {
                                exif = new ExifInterface(string3);
                            }
                            ExifInterface exifInterface = exif;
                            if (exifInterface != null) {
                                ExifInterface exifInterface2;
                                ExifInterface exifInterface3 = exifInterface2 = exifInterface;
                                boolean bl3 = false;
                                int orientation = exifInterface3.getAttributeInt("Orientation", 1);
                                int width = exifInterface3.getAttributeInt("ImageWidth", 0);
                                int height = exifInterface3.getAttributeInt("ImageLength", 0);
                                switch (orientation) {
                                    case 3: 
                                    case 6: 
                                    case 7: 
                                    case 8: {
                                        mediaInfo.setWidth(height);
                                        mediaInfo.setHeight(width);
                                        break;
                                    }
                                    default: {
                                        mediaInfo.setWidth(width);
                                        mediaInfo.setHeight(height);
                                    }
                                }
                            }
                            InputStream inputStream2 = inputStream;
                            if (inputStream2 != null) {
                                InputStream inputStream3;
                                InputStream inputStream4 = inputStream3 = inputStream2;
                                boolean bl4 = false;
                                FileUtils.INSTANCE.close(inputStream4);
                            }
                        } else if (MediaUtils.INSTANCE.hasMimeTypeOfVideo(string2)) {
                            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
                            if (MediaUtils.INSTANCE.isContent(string3)) {
                                retriever.setDataSource(context, Uri.parse((String)string3));
                            } else {
                                retriever.setDataSource(string3);
                            }
                            String string4 = retriever.extractMetadata(9);
                            if (string4 != null) {
                                long duration = Long.parseLong(string4);
                                boolean bl5 = false;
                                mediaInfo.setDuration(duration);
                            }
                            string4 = retriever.extractMetadata(24);
                            if (string4 != null) {
                                int n = Integer.parseInt(string4);
                                boolean bl6 = false;
                                mediaInfo.setOrientation(n);
                            }
                            if (mediaInfo.getOrientation() == 90 || mediaInfo.getOrientation() == 270) {
                                string4 = retriever.extractMetadata(18);
                                if (string4 != null) {
                                    int n = Integer.parseInt(string4);
                                    boolean bl7 = false;
                                    mediaInfo.setHeight(n);
                                }
                                string4 = retriever.extractMetadata(19);
                                if (string4 != null) {
                                    int n = Integer.parseInt(string4);
                                    boolean bl8 = false;
                                    mediaInfo.setWidth(n);
                                }
                            } else {
                                string4 = retriever.extractMetadata(18);
                                if (string4 != null) {
                                    int n = Integer.parseInt(string4);
                                    boolean bl9 = false;
                                    mediaInfo.setWidth(n);
                                }
                                string4 = retriever.extractMetadata(19);
                                if (string4 != null) {
                                    int n = Integer.parseInt(string4);
                                    boolean bl10 = false;
                                    mediaInfo.setHeight(n);
                                }
                            }
                        } else if (MediaUtils.INSTANCE.hasMimeTypeOfAudio(string2)) {
                            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
                            if (MediaUtils.INSTANCE.isContent(string3)) {
                                retriever.setDataSource(context, Uri.parse((String)string3));
                            } else {
                                retriever.setDataSource(string3);
                            }
                            String string5 = retriever.extractMetadata(9);
                            if (string5 != null) {
                                long duration = Long.parseLong(string5);
                                boolean bl11 = false;
                                mediaInfo.setDuration(duration);
                            }
                        }
                        ((Continuation)it).resumeWith(Result.constructor-impl((Object)mediaInfo));
                        Object object3 = cancellable$iv.getResult();
                        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)this));
                        }
                        Object object4 = object3;
                        if (object3 != object2) return object4;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$suspendCancellableCoroutine = false;
                        Context cfr_ignored_0 = (Context)this.L$2;
                        String cfr_ignored_1 = (String)this.L$1;
                        String cfr_ignored_2 = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return object4;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super MediaInfo> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object getAssignFileMedia(@NotNull Context context, @NotNull String absolutePath, @NotNull Continuation<? super LocalMedia> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LocalMedia>, Object>(absolutePath, context, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ String $absolutePath;
            final /* synthetic */ Context $context;
            {
                this.$absolutePath = $absolutePath;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        media = new LocalMedia();
                        file = new File(this.$absolutePath);
                        media.setId(file.hashCode());
                        media.setPath(this.$absolutePath);
                        media.setAbsolutePath(this.$absolutePath);
                        media.setDisplayName(file.getName());
                        media.setBucketId(-2L);
                        v0 = file.getParentFile();
                        media.setBucketDisplayName(v0 != null ? v0.getName() : null);
                        media.setMimeType(MediaUtils.INSTANCE.getMimeType(media.getAbsolutePath()));
                        this.L$0 = media;
                        this.L$1 = file;
                        this.label = 1;
                        v1 = MediaUtils.INSTANCE.getMediaInfo(this.$context, media.getMimeType(), this.$absolutePath, (Continuation<? super MediaInfo>)((Continuation)this));
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl27
                    }
                    case 1: {
                        file = (File)this.L$1;
                        media = (LocalMedia)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl27:
                        // 2 sources

                        mediaInfo = (MediaInfo)v1;
                        media.setOrientation(mediaInfo.getOrientation());
                        media.setDuration(mediaInfo.getDuration());
                        media.setSize(file.length());
                        media.setDateAdded(file.lastModified());
                        if (media.getOrientation() == 90 || media.getOrientation() == 270) {
                            media.setWidth(mediaInfo.getHeight());
                            media.setHeight(mediaInfo.getWidth());
                        } else {
                            media.setWidth(mediaInfo.getWidth());
                            media.setHeight(mediaInfo.getHeight());
                        }
                        return media;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super LocalMedia> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object getAssignPathMedia(@NotNull Context context, @NotNull String absolutePath, @NotNull Continuation<? super LocalMedia> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LocalMedia>, Object>(absolutePath, context, null){
            int label;
            final /* synthetic */ String $absolutePath;
            final /* synthetic */ Context $context;
            {
                this.$absolutePath = $absolutePath;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Cursor cursor;
                        ResultKt.throwOnFailure((Object)object);
                        String selection = "_data like ?";
                        String[] stringArray = new String[]{'%' + this.$absolutePath + '%'};
                        String[] selectionArgs = stringArray;
                        if (SdkVersionUtils.INSTANCE.isR()) {
                            Bundle queryArgs = MediaUtils.INSTANCE.createQueryArgsBundle(selection, selectionArgs, 1, 0, "_id DESC");
                            cursor = this.$context.getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), MediaUtils.access$getProjection(MediaUtils.INSTANCE), queryArgs, null);
                        } else {
                            void var3_4;
                            void var2_2;
                            cursor = this.$context.getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), MediaUtils.access$getProjection(MediaUtils.INSTANCE), (String)var2_2, (String[])var3_4, "_id DESC limit 1 offset 0");
                        }
                        Cursor cursor2 = cursor;
                        if (cursor2 != null) {
                            Closeable closeable = (Closeable)cursor2;
                            Throwable throwable = null;
                            try {
                                Cursor data = (Cursor)closeable;
                                boolean bl = false;
                                if (data.getCount() > 0 && data.moveToFirst()) {
                                    LocalMedia media = new LocalMedia();
                                    media.setId(data.getLong(data.getColumnIndexOrThrow("_id")));
                                    media.setBucketId(data.getLong(data.getColumnIndexOrThrow("bucket_id")));
                                    media.setDisplayName(data.getString(data.getColumnIndexOrThrow("_display_name")));
                                    media.setBucketDisplayName(data.getString(data.getColumnIndexOrThrow("bucket_display_name")));
                                    media.setAbsolutePath(data.getString(data.getColumnIndexOrThrow("_data")));
                                    media.setMimeType(data.getString(data.getColumnIndexOrThrow("mime_type")));
                                    if (MediaUtils.INSTANCE.hasMimeTypeOfUnknown(media.getMimeType())) {
                                        String mimeType = MediaUtils.INSTANCE.getMimeType(media.getAbsolutePath());
                                        media.setMimeType(TextUtils.isEmpty((CharSequence)mimeType) ? media.getMimeType() : mimeType);
                                    }
                                    media.setPath(SdkVersionUtils.INSTANCE.isQ() ? MediaUtils.INSTANCE.getRealPathUri(media.getId(), media.getMimeType()) : media.getAbsolutePath());
                                    media.setOrientation(data.getInt(data.getColumnIndexOrThrow("orientation")));
                                    media.setDuration(data.getLong(data.getColumnIndexOrThrow("duration")));
                                    media.setSize(data.getLong(data.getColumnIndexOrThrow("_size")));
                                    media.setDateAdded(data.getLong(data.getColumnIndexOrThrow("date_added")));
                                    if (media.getOrientation() == 90 || media.getOrientation() == 270) {
                                        media.setWidth(data.getInt(data.getColumnIndexOrThrow("height")));
                                        media.setHeight(data.getInt(data.getColumnIndexOrThrow("width")));
                                    } else {
                                        media.setWidth(data.getInt(data.getColumnIndexOrThrow("width")));
                                        media.setHeight(data.getInt(data.getColumnIndexOrThrow("height")));
                                    }
                                    LocalMedia localMedia = media;
                                    return localMedia;
                                }
                                data.close();
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                        return null;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super LocalMedia> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getDCIMLastId(@NotNull Context var1_1, @NotNull String var2_2, @NotNull Continuation<? super Long> var3_3) {
        if (!(var3_3 instanceof getDCIMLastId.1)) ** GOTO lbl-1000
        var5_4 = var3_3;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ MediaUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getDCIMLastId(null, null, (Continuation<? super Long>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>((String)absoluteDir, (Context)context, null){
                    int label;
                    final /* synthetic */ String $absoluteDir;
                    final /* synthetic */ Context $context;
                    {
                        this.$absoluteDir = $absoluteDir;
                        this.$context = $context;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Cursor cursor;
                                ResultKt.throwOnFailure((Object)object);
                                String selection = "_data like ?";
                                String[] stringArray = new String[]{'%' + this.$absoluteDir + '%'};
                                String[] selectionArgs = stringArray;
                                ContentResolver contentResolver = this.$context.getContentResolver();
                                if (SdkVersionUtils.INSTANCE.isR()) {
                                    Bundle queryArgs = MediaUtils.INSTANCE.createQueryArgsBundle(selection, selectionArgs, 1, 0, "_id DESC");
                                    cursor = contentResolver.query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, queryArgs, null);
                                } else {
                                    void var3_4;
                                    void var2_2;
                                    String orderBy = "_id DESC limit 1 offset 0";
                                    cursor = contentResolver.query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, (String)var2_2, (String[])var3_4, orderBy);
                                }
                                Cursor cursor2 = cursor;
                                if (cursor2 == null) return null;
                                Closeable closeable = (Closeable)cursor2;
                                Throwable throwable = null;
                                try {
                                    Cursor data = (Cursor)closeable;
                                    boolean bl = false;
                                    if (data.getCount() > 0 && data.moveToFirst()) {
                                        long id2 = data.getLong(data.getColumnIndex("_id"));
                                        long date = data.getLong(data.getColumnIndex("date_added"));
                                        Long l = Boxing.boxLong((long)(DateUtils.INSTANCE.dateDiffer(date) ? id2 : -1L));
                                        return l;
                                    }
                                    data.close();
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                }
                                Unit unit = Unit.INSTANCE;
                                return unit;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<Object> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                return Boxing.boxLong((long)-1L);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String[] getProjection() {
        String[] stringArray = new String[]{"_id", "_data", "mime_type", "width", "height", "duration", "_size", "bucket_display_name", "_display_name", "bucket_id", "date_added", "orientation"};
        return stringArray;
    }

    @NotNull
    public final Uri parUri(@NotNull Context context, @NotNull File cameraFile) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cameraFile, (String)"cameraFile");
        String authority = context.getPackageName() + ".luckProvider";
        if (Build.VERSION.SDK_INT > 23) {
            Uri uri2 = FileProvider.getUriForFile((Context)context, (String)authority, (File)cameraFile);
            uri = uri2;
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"{\n            FileProvid\u2026ty, cameraFile)\n        }");
        } else {
            Uri uri3 = Uri.fromFile((File)cameraFile);
            uri = uri3;
            Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"{\n            Uri.fromFile(cameraFile)\n        }");
        }
        return uri;
    }

    @Nullable
    public final String getPath(@NotNull Context ctx, @NotNull Uri uri) {
        block23: {
            Context context;
            block21: {
                block22: {
                    boolean isKitKat;
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                    context = ctx.getApplicationContext();
                    boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
                    if (!isKitKat || !DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) break block21;
                    if (!this.isExternalStorageDocument(uri)) break block22;
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
                    String[] stringArray = new String[]{":"};
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)docId, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                    if (stringArray2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    String[] split = stringArray2;
                    String type = split[0];
                    if (StringsKt.equals((String)"primary", (String)type, (boolean)true)) {
                        return SdkVersionUtils.INSTANCE.isQ() ? context.getExternalFilesDir(Environment.DIRECTORY_PICTURES) + '/' + split[1] : Environment.getExternalStorageDirectory().toString() + '/' + split[1];
                    }
                    break block23;
                }
                if (this.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri uri2 = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)ValueOf.toLong$default(ValueOf.INSTANCE, id2, 0L, 2, null));
                    Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"withAppendedId(\n        \u2026ong(id)\n                )");
                    Uri contentUri = uri2;
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    return this.getDataColumn(context, contentUri, null, null);
                }
                if (!this.isMediaDocument(uri)) break block23;
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
                Object type = new String[]{":"};
                Object $this$toTypedArray$iv = StringsKt.split$default((CharSequence)docId, (String[])type, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Object thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                String[] split = stringArray;
                type = split[0];
                Uri contentUri = null;
                switch (type) {
                    case "image": {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                        break;
                    }
                    case "video": {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                        break;
                    }
                    case "audio": {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                }
                String selection = "_id=?";
                String[] stringArray3 = new String[]{split[1]};
                String[] selectionArgs = stringArray3;
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                Uri uri3 = contentUri;
                Intrinsics.checkNotNull((Object)uri3);
                return this.getDataColumn(context, uri3, selection, selectionArgs);
            }
            if (StringsKt.equals((String)"content", (String)uri.getScheme(), (boolean)true)) {
                String string2;
                if (this.isGooglePhotosUri(uri)) {
                    string2 = uri.getLastPathSegment();
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    string2 = this.getDataColumn(context, uri, null, null);
                }
                return string2;
            }
            if (StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true)) {
                return uri.getPath();
            }
        }
        return "";
    }

    public final boolean isGooglePhotosUri(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.google.android.apps.photos.content", (Object)uri.getAuthority());
    }

    private final boolean isMediaDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    private final boolean isExternalStorageDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
    }

    private final boolean isDownloadsDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        block8: {
            Cursor cursor;
            Cursor cursor2 = null;
            String column = "_data";
            Object object = new String[]{column};
            String[] projection = object;
            try {
                cursor2 = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
                if (cursor2 != null && cursor2.moveToFirst()) {
                    object = cursor2.getString(cursor2.getColumnIndexOrThrow(column));
                    cursor2.close();
                    return object;
                }
                cursor = cursor2;
            }
            catch (IllegalArgumentException ex) {
                Locale locale = Locale.getDefault();
                String string2 = "getDataColumn: _data - [%s]";
                Object[] objectArray = new Object[]{ex.getMessage()};
                String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
                SelectorLogUtils.INSTANCE.info(string3);
                break block8;
            }
            finally {
                Cursor cursor3 = cursor2;
                if (cursor3 != null) {
                    cursor3.close();
                }
            }
            if (cursor != null) {
                cursor.close();
            }
        }
        return "";
    }

    public final void deleteUri(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            context.getContentResolver().delete(uri, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void remove(@NotNull Context context, long id2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            String selection = "_id=?";
            String[] stringArray = new String[]{String.valueOf(id2)};
            contentResolver.delete(uri, selection, stringArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final /* synthetic */ String[] access$getProjection(MediaUtils $this) {
        return $this.getProjection();
    }
}

