/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

public class HorizontalItemDecoration
extends RecyclerView.ItemDecoration {
    private final int spanCount;
    private final int spacing;

    public HorizontalItemDecoration(int spanCount, int spacing) {
        this.spanCount = spanCount;
        this.spacing = spacing;
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        int column = position % this.spanCount;
        outRect.left = position == 0 ? this.spacing - column * this.spacing / this.spanCount : column * this.spacing / this.spanCount;
        outRect.right = this.spacing - (column + 1) * this.spacing / this.spanCount;
        if (position < this.spanCount) {
            outRect.top = this.spacing;
        }
        outRect.bottom = this.spacing;
    }
}

