/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.RelativeLayout;
import com.luck.picture.lib.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J(\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/luck/picture/lib/widget/RoundCornerRelativeLayout;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "cornerSize", "", "isBottomNormal", "", "isTopNormal", "mRect", "Landroid/graphics/RectF;", "path", "Landroid/graphics/Path;", "dispatchDraw", "", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldW", "oldH", "selector_release"})
public final class RoundCornerRelativeLayout
extends RelativeLayout {
    @NotNull
    private final Path path;
    private final float cornerSize;
    private final boolean isTopNormal;
    private final boolean isBottomNormal;
    @NotNull
    private final RectF mRect;

    @JvmOverloads
    public RoundCornerRelativeLayout(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mRect = new RectF();
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SelectorRoundCornerRelativeLayout, defStyleAttr, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026,\n            0\n        )");
        TypedArray a = typedArray;
        this.cornerSize = a.getDimension(R.styleable.SelectorRoundCornerRelativeLayout_psCorners, 0.0f);
        this.isTopNormal = a.getBoolean(R.styleable.SelectorRoundCornerRelativeLayout_psTopNormal, false);
        this.isBottomNormal = a.getBoolean(R.styleable.SelectorRoundCornerRelativeLayout_psBottomNormal, false);
        a.recycle();
        this.path = new Path();
    }

    public /* synthetic */ RoundCornerRelativeLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.path.reset();
        this.mRect.right = w;
        this.mRect.bottom = h;
        float[] cornerRadii = null;
        if (!this.isTopNormal && !this.isBottomNormal) {
            this.path.addRoundRect(this.mRect, this.cornerSize, this.cornerSize, Path.Direction.CW);
        } else {
            float[] fArray;
            if (this.isTopNormal) {
                fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, this.cornerSize, this.cornerSize, this.cornerSize, this.cornerSize};
                cornerRadii = fArray;
                this.path.addRoundRect(this.mRect, cornerRadii, Path.Direction.CW);
            }
            if (this.isBottomNormal) {
                fArray = new float[]{this.cornerSize, this.cornerSize, this.cornerSize, this.cornerSize, 0.0f, 0.0f, 0.0f, 0.0f};
                cornerRadii = fArray;
                this.path.addRoundRect(this.mRect, cornerRadii, Path.Direction.CW);
            }
        }
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.clipPath(this.path);
        super.dispatchDraw(canvas);
        canvas.restore();
    }

    @JvmOverloads
    public RoundCornerRelativeLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public RoundCornerRelativeLayout(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

