/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.config;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.luck.picture.lib.R;
import java.io.File;

public final class PictureMimeType {
    private static final String MIME_TYPE_PNG = "image/png";
    public static final String MIME_TYPE_JPEG = "image/jpeg";
    private static final String MIME_TYPE_JPG = "image/jpg";
    private static final String MIME_TYPE_BMP = "image/bmp";
    private static final String MIME_TYPE_GIF = "image/gif";
    private static final String MIME_TYPE_WEBP = "image/webp";
    private static final String MIME_TYPE_3GP = "video/3gp";
    private static final String MIME_TYPE_MP4 = "video/mp4";
    private static final String MIME_TYPE_MPEG = "video/mpeg";
    private static final String MIME_TYPE_AVI = "video/avi";
    public static final String JPEG = ".jpeg";
    public static final String JPG = ".jpg";
    public static final String PNG = ".png";
    public static final String WEBP = ".webp";
    public static final String AMR = ".amr";
    public static final String WAV = ".wav";
    public static final String MP3 = ".mp3";
    public static final String MP4 = ".mp4";
    public static final String AVI = ".avi";
    public static final String JPEG_Q = "image/jpeg";
    public static final String PNG_Q = "image/png";
    public static final String MP4_Q = "video/mp4";
    public static final String AVI_Q = "video/avi";
    public static final String AMR_Q = "audio/amr";
    public static final String WAV_Q = "audio/x-wav";
    public static final String MP3_Q = "audio/mpeg";
    public static final String DCIM = "DCIM/Camera";
    public static final String CAMERA = "Camera";
    public static final String MIME_TYPE_IMAGE = "image/jpeg";
    public static final String MIME_TYPE_VIDEO = "video/mp4";
    public static final String MIME_TYPE_AUDIO = "audio/mpeg";
    public static final String MIME_TYPE_AUDIO_AMR = "audio/amr";
    public static final String MIME_TYPE_PREFIX_IMAGE = "image";
    public static final String MIME_TYPE_PREFIX_VIDEO = "video";
    public static final String MIME_TYPE_PREFIX_AUDIO = "audio";

    public static int ofAll() {
        return 0;
    }

    public static int ofImage() {
        return 1;
    }

    public static int ofVideo() {
        return 2;
    }

    @Deprecated
    public static int ofAudio() {
        return 3;
    }

    public static String ofPNG() {
        return "image/png";
    }

    public static String ofJPEG() {
        return "image/jpeg";
    }

    public static String ofBMP() {
        return MIME_TYPE_BMP;
    }

    public static String ofGIF() {
        return MIME_TYPE_GIF;
    }

    public static String ofWEBP() {
        return MIME_TYPE_WEBP;
    }

    public static String of3GP() {
        return MIME_TYPE_3GP;
    }

    public static String ofMP4() {
        return "video/mp4";
    }

    public static String ofMPEG() {
        return MIME_TYPE_MPEG;
    }

    public static String ofAVI() {
        return "video/avi";
    }

    public static boolean isGif(String mimeType) {
        return mimeType != null && (mimeType.equals(MIME_TYPE_GIF) || mimeType.equals("image/GIF"));
    }

    public static boolean isWebp(String mimeType) {
        return mimeType != null && mimeType.equalsIgnoreCase(MIME_TYPE_WEBP);
    }

    public static boolean isGifForSuffix(String suffix) {
        if (TextUtils.isEmpty((CharSequence)suffix)) {
            return false;
        }
        return suffix.startsWith(".gif") || suffix.startsWith(".GIF");
    }

    public static boolean isHasVideo(String mimeType) {
        return mimeType != null && mimeType.startsWith(MIME_TYPE_PREFIX_VIDEO);
    }

    public static boolean isUrlHasVideo(String url) {
        return url.endsWith(MP4);
    }

    public static boolean isHasAudio(String mimeType) {
        return mimeType != null && mimeType.startsWith(MIME_TYPE_PREFIX_AUDIO);
    }

    public static boolean isHasImage(String mimeType) {
        return mimeType != null && mimeType.startsWith(MIME_TYPE_PREFIX_IMAGE);
    }

    public static boolean isJPEG(String mimeType) {
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return false;
        }
        return mimeType.startsWith("image/jpeg") || mimeType.startsWith(MIME_TYPE_JPG);
    }

    public static boolean isJPG(String mimeType) {
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return false;
        }
        return mimeType.startsWith(MIME_TYPE_JPG);
    }

    public static boolean isHasHttp(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return path.startsWith("http") || path.startsWith("https") || path.startsWith("/http") || path.startsWith("/https");
    }

    public static String getMimeTypeFromMediaContentUri(Context context, Uri uri) {
        String mimeType;
        if (uri.getScheme().equals("content")) {
            ContentResolver cr = context.getContentResolver();
            mimeType = cr.getType(uri);
        } else {
            String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension.toLowerCase());
        }
        return TextUtils.isEmpty((CharSequence)mimeType) ? "image/jpeg" : mimeType;
    }

    public static boolean isSuffixOfImage(String name) {
        return !TextUtils.isEmpty((CharSequence)name) && name.endsWith(".PNG") || name.endsWith(PNG) || name.endsWith(JPEG) || name.endsWith(".gif") || name.endsWith(".GIF") || name.endsWith(JPG) || name.endsWith(WEBP) || name.endsWith(".WEBP") || name.endsWith(".JPEG") || name.endsWith(".bmp");
    }

    public static boolean isMimeTypeSame(String oldMimeType, String newMimeType) {
        return PictureMimeType.getMimeType(oldMimeType) == PictureMimeType.getMimeType(newMimeType);
    }

    public static String getImageMimeType(String path) {
        try {
            if (!TextUtils.isEmpty((CharSequence)path)) {
                File file = new File(path);
                String fileName = file.getName();
                int beginIndex = fileName.lastIndexOf(".");
                String temp = beginIndex == -1 ? "jpeg" : fileName.substring(beginIndex + 1);
                return "image/" + temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "image/jpeg";
        }
        return "image/jpeg";
    }

    public static String getImageMimeType(String path, int cameraMimeType) {
        try {
            File file = new File(path);
            String fileName = file.getName();
            int beginIndex = fileName.lastIndexOf(".");
            boolean isMatchSuccess = beginIndex != -1;
            switch (cameraMimeType) {
                case 2: {
                    return isMatchSuccess ? "video/" + fileName.substring(beginIndex + 1) : "video/mp4";
                }
                case 3: {
                    return isMatchSuccess ? "audio/" + fileName.substring(beginIndex + 1) : "audio/amr";
                }
            }
            return isMatchSuccess ? "image/" + fileName.substring(beginIndex + 1) : "image/jpeg";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "image/jpeg";
        }
    }

    public static String getLastImgType(String path) {
        try {
            int index = path.lastIndexOf(".");
            if (index > 0) {
                String imageType;
                switch (imageType = path.substring(index)) {
                    case ".png": 
                    case ".PNG": 
                    case ".jpg": 
                    case ".jpeg": 
                    case ".JPEG": 
                    case ".WEBP": 
                    case ".bmp": 
                    case ".BMP": 
                    case ".webp": 
                    case ".gif": 
                    case ".GIF": {
                        return imageType;
                    }
                }
                return PNG;
            }
            return PNG;
        }
        catch (Exception e) {
            e.printStackTrace();
            return PNG;
        }
    }

    public static int getMimeType(String mimeType) {
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return 1;
        }
        if (mimeType.startsWith(MIME_TYPE_PREFIX_VIDEO)) {
            return 2;
        }
        if (mimeType.startsWith(MIME_TYPE_PREFIX_AUDIO)) {
            return 3;
        }
        return 1;
    }

    public static String getLastImgSuffix(String mineType) {
        String defaultSuffix = PNG;
        try {
            int index = mineType.lastIndexOf("/") + 1;
            if (index > 0) {
                return "." + mineType.substring(index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultSuffix;
        }
        return defaultSuffix;
    }

    public static boolean isContent(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        return url.startsWith("content://");
    }

    public static String s(Context context, String mimeType) {
        Context ctx = context.getApplicationContext();
        if (PictureMimeType.isHasVideo(mimeType)) {
            return ctx.getString(R.string.picture_video_error);
        }
        if (PictureMimeType.isHasAudio(mimeType)) {
            return ctx.getString(R.string.picture_audio_error);
        }
        return ctx.getString(R.string.picture_error);
    }
}

