/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.content.Context;
import android.content.Intent;
import android.graphics.PointF;
import android.net.Uri;
import android.os.Bundle;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.photoview.PhotoView;
import com.luck.picture.lib.tools.JumpUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.widget.longimage.ImageSource;
import com.luck.picture.lib.widget.longimage.ImageViewState;
import com.luck.picture.lib.widget.longimage.SubsamplingScaleImageView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PictureSimpleFragmentAdapter
extends PagerAdapter {
    private final List<LocalMedia> data = new ArrayList<LocalMedia>();
    private final OnCallBackActivity onBackPressed;
    private final PictureSelectionConfig config;
    private final int mScreenWidth;
    private final int mScreenHeight;
    private static final int MAX_CACHE_SIZE = 20;
    private final SparseArray<View> mCacheView = new SparseArray();

    public void clear() {
        this.mCacheView.clear();
    }

    public void removeCacheView(int position) {
        if (position < this.mCacheView.size()) {
            this.mCacheView.removeAt(position);
        }
    }

    public PictureSimpleFragmentAdapter(Context context, PictureSelectionConfig config, OnCallBackActivity onBackPressed) {
        this.config = config;
        this.onBackPressed = onBackPressed;
        this.mScreenWidth = ScreenUtils.getScreenWidth(context);
        this.mScreenHeight = ScreenUtils.getScreenHeight(context);
    }

    public void bindData(List<LocalMedia> data) {
        if (data != null) {
            this.data.clear();
            this.data.addAll(data);
        }
    }

    public List<LocalMedia> getData() {
        return this.data;
    }

    public int getSize() {
        return this.data.size();
    }

    public void remove(int currentItem) {
        if (this.getSize() > currentItem) {
            this.data.remove(currentItem);
        }
    }

    public LocalMedia getItem(int position) {
        return this.getSize() > 0 && position < this.getSize() ? this.data.get(position) : null;
    }

    public int getCount() {
        return this.data.size();
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
        if (this.mCacheView.size() > 20) {
            this.mCacheView.remove(position);
        }
    }

    public int getItemPosition(@NonNull Object object) {
        return -2;
    }

    public boolean isViewFromObject(@NotNull View view, @NotNull Object object) {
        return view == object;
    }

    @NotNull
    public Object instantiateItem(@NotNull ViewGroup container, int position) {
        View contentView = (View)this.mCacheView.get(position);
        if (contentView == null) {
            contentView = LayoutInflater.from((Context)container.getContext()).inflate(R.layout.picture_image_preview, container, false);
            this.mCacheView.put(position, (Object)contentView);
        }
        PhotoView photoView = (PhotoView)contentView.findViewById(R.id.preview_image);
        SubsamplingScaleImageView longImg = (SubsamplingScaleImageView)contentView.findViewById(R.id.longImg);
        ImageView ivPlay = (ImageView)contentView.findViewById(R.id.iv_play);
        LocalMedia media = this.getItem(position);
        if (this.config.isAutoScalePreviewImage) {
            float width = Math.min(media.getWidth(), media.getHeight());
            float height = Math.max(media.getHeight(), media.getWidth());
            if (width > 0.0f && height > 0.0f) {
                int displayHeight = (int)Math.ceil(width * height / width);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)photoView.getLayoutParams();
                layoutParams.width = this.mScreenWidth;
                layoutParams.height = displayHeight < this.mScreenHeight ? displayHeight + this.mScreenHeight : displayHeight;
                layoutParams.gravity = 17;
            }
        }
        String mimeType = media.getMimeType();
        String path = media.isCut() && !media.isCompressed() ? media.getCutPath() : (media.isCompressed() || media.isCut() && media.isCompressed() ? media.getCompressPath() : media.getPath());
        boolean isGif = PictureMimeType.isGif(mimeType);
        boolean isHasVideo = PictureMimeType.isHasVideo(mimeType);
        ivPlay.setVisibility(isHasVideo ? 0 : 8);
        ivPlay.setOnClickListener(v -> {
            if (PictureSelectionConfig.customVideoPlayCallback != null) {
                PictureSelectionConfig.customVideoPlayCallback.startPlayVideo(media);
            } else {
                Intent intent = new Intent();
                Bundle bundle = new Bundle();
                bundle.putBoolean("isExternalPreviewVideo", true);
                bundle.putString("videoPath", path);
                intent.putExtras(bundle);
                JumpUtils.startPictureVideoPlayActivity(container.getContext(), bundle, 166);
            }
        });
        boolean eqLongImg = MediaUtils.isLongImg(media);
        photoView.setVisibility(eqLongImg && !isGif ? 8 : 0);
        photoView.setOnViewTapListener((view, x, y) -> {
            if (this.onBackPressed != null) {
                this.onBackPressed.onActivityBackPressed();
            }
        });
        longImg.setVisibility(eqLongImg && !isGif ? 0 : 8);
        longImg.setOnClickListener(v -> {
            if (this.onBackPressed != null) {
                this.onBackPressed.onActivityBackPressed();
            }
        });
        if (isGif && !media.isCompressed()) {
            if (PictureSelectionConfig.imageEngine != null) {
                PictureSelectionConfig.imageEngine.loadAsGifImage(contentView.getContext(), path, (ImageView)photoView);
            }
        } else if (PictureSelectionConfig.imageEngine != null) {
            if (eqLongImg) {
                this.displayLongPic(PictureMimeType.isContent(path) ? Uri.parse((String)path) : Uri.fromFile((File)new File(path)), longImg);
            } else {
                PictureSelectionConfig.imageEngine.loadImage(contentView.getContext(), path, (ImageView)photoView);
            }
        }
        container.addView(contentView, 0);
        return contentView;
    }

    private void displayLongPic(Uri uri, SubsamplingScaleImageView longImg) {
        longImg.setQuickScaleEnabled(true);
        longImg.setZoomEnabled(true);
        longImg.setDoubleTapZoomDuration(100);
        longImg.setMinimumScaleType(2);
        longImg.setDoubleTapZoomDpi(2);
        longImg.setImage(ImageSource.uri(uri), new ImageViewState(0.0f, new PointF(0.0f, 0.0f), 0));
    }

    public static interface OnCallBackActivity {
        public void onActivityBackPressed();
    }
}

