/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.task;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.luck.picture.lib.PictureContentResolver;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.yalantis.ucrop.callback.BitmapLoadCallback;
import com.yalantis.ucrop.model.ExifInfo;
import com.yalantis.ucrop.util.BitmapLoadUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class BitmapLoadTask
extends AsyncTask<Void, Void, BitmapWorkerResult> {
    private static final String TAG = "BitmapWorkerTask";
    private static final int MAX_BITMAP_SIZE = 0x6400000;
    private final Context mContext;
    private Uri mInputUri;
    private final Uri mOutputUri;
    private final int mRequiredWidth;
    private final int mRequiredHeight;
    private final BitmapLoadCallback mBitmapLoadCallback;

    public BitmapLoadTask(@NonNull Context context, @NonNull Uri inputUri, @Nullable Uri outputUri, int requiredWidth, int requiredHeight, BitmapLoadCallback loadCallback) {
        this.mContext = context;
        this.mInputUri = inputUri;
        this.mOutputUri = outputUri;
        this.mRequiredWidth = requiredWidth;
        this.mRequiredHeight = requiredHeight;
        this.mBitmapLoadCallback = loadCallback;
    }

    @NonNull
    protected BitmapWorkerResult doInBackground(Void ... params) {
        if (this.mInputUri == null) {
            return new BitmapWorkerResult(new NullPointerException("Input Uri cannot be null"));
        }
        try {
            this.processInputUri();
        }
        catch (IOException | NullPointerException e) {
            return new BitmapWorkerResult(e);
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inSampleSize = BitmapLoadUtils.calculateInSampleSize(options, this.mRequiredWidth, this.mRequiredHeight);
        options.inJustDecodeBounds = false;
        Bitmap decodeSampledBitmap = null;
        boolean decodeAttemptSuccess = false;
        while (!decodeAttemptSuccess) {
            try {
                InputStream stream = PictureContentResolver.getContentResolverOpenInputStream(this.mContext, this.mInputUri);
                decodeSampledBitmap = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
                if (options.outWidth == -1 || options.outHeight == -1) {
                    return new BitmapWorkerResult(new IllegalArgumentException("Bounds for bitmap could not be retrieved from the Uri: [" + this.mInputUri + "]"));
                }
                if (this.checkSize(decodeSampledBitmap, options)) continue;
                decodeAttemptSuccess = true;
            }
            catch (OutOfMemoryError error) {
                Log.e((String)TAG, (String)"doInBackground: BitmapFactory.decodeFileDescriptor: ", (Throwable)error);
                options.inSampleSize *= 2;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"doInBackground: ImageDecoder.createSource: ", (Throwable)e);
                return new BitmapWorkerResult(new IllegalArgumentException("Bitmap could not be decoded from the Uri: [" + this.mInputUri + "]", e));
            }
        }
        if (decodeSampledBitmap == null) {
            return new BitmapWorkerResult(new IllegalArgumentException("Bitmap could not be decoded from the Uri: [" + this.mInputUri + "]"));
        }
        int exifOrientation = BitmapLoadUtils.getExifOrientation(this.mContext, this.mInputUri);
        int exifDegrees = BitmapLoadUtils.exifToDegrees(exifOrientation);
        int exifTranslation = BitmapLoadUtils.exifToTranslation(exifOrientation);
        ExifInfo exifInfo = new ExifInfo(exifOrientation, exifDegrees, exifTranslation);
        Matrix matrix = new Matrix();
        if (exifDegrees != 0) {
            matrix.preRotate((float)exifDegrees);
        }
        if (exifTranslation != 1) {
            matrix.postScale((float)exifTranslation, 1.0f);
        }
        if (!matrix.isIdentity()) {
            return new BitmapWorkerResult(BitmapLoadUtils.transformBitmap(decodeSampledBitmap, matrix), exifInfo);
        }
        return new BitmapWorkerResult(decodeSampledBitmap, exifInfo);
    }

    private void processInputUri() throws NullPointerException, IOException {
        String inputUriScheme = this.mInputUri.getScheme();
        Log.d((String)TAG, (String)("Uri scheme: " + inputUriScheme));
        if ("http".equals(inputUriScheme) || "https".equals(inputUriScheme)) {
            try {
                this.downloadFile(this.mInputUri, this.mOutputUri);
            }
            catch (IOException | NullPointerException e) {
                Log.e((String)TAG, (String)"Downloading failed", (Throwable)e);
                throw e;
            }
        } else if ("content".equals(inputUriScheme)) {
            String path = this.getFilePath();
            if (!TextUtils.isEmpty((CharSequence)path) && new File(path).exists()) {
                this.mInputUri = SdkVersionUtils.checkedAndroid_Q() ? this.mInputUri : Uri.fromFile((File)new File(path));
            } else {
                try {
                    this.copyFile(this.mInputUri, this.mOutputUri);
                }
                catch (IOException | NullPointerException e) {
                    Log.e((String)TAG, (String)"Copying failed", (Throwable)e);
                    throw e;
                }
            }
        } else if (!"file".equals(inputUriScheme)) {
            Log.e((String)TAG, (String)("Invalid Uri scheme " + inputUriScheme));
            throw new IllegalArgumentException("Invalid Uri scheme" + inputUriScheme);
        }
    }

    private String getFilePath() {
        if (ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0) {
            return PictureFileUtils.getPath(this.mContext, this.mInputUri);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(@NonNull Uri inputUri, @Nullable Uri outputUri) throws NullPointerException, IOException {
        Log.d((String)TAG, (String)"copyFile");
        if (outputUri == null) {
            throw new NullPointerException("Output Uri is null - cannot copy image");
        }
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int length;
            inputStream = PictureContentResolver.getContentResolverOpenInputStream(this.mContext, inputUri);
            outputStream = new FileOutputStream(outputUri.getPath());
            if (inputStream == null) {
                throw new NullPointerException("InputStream for given input Uri is null");
            }
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) > 0) {
                ((OutputStream)outputStream).write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            BitmapLoadUtils.close(outputStream);
            BitmapLoadUtils.close(inputStream);
            this.mInputUri = this.mOutputUri;
            throw throwable;
        }
        BitmapLoadUtils.close(outputStream);
        BitmapLoadUtils.close(inputStream);
        this.mInputUri = this.mOutputUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(@NonNull Uri inputUri, @Nullable Uri outputUri) throws NullPointerException, IOException {
        block8: {
            Log.d((String)TAG, (String)"downloadFile");
            if (outputUri == null) {
                throw new NullPointerException("Output Uri is null - cannot download image");
            }
            OutputStream outputStream = null;
            BufferedInputStream bin = null;
            BufferedOutputStream bout = null;
            try {
                URL u = new URL(inputUri.toString());
                byte[] buffer = new byte[1024];
                bin = new BufferedInputStream(u.openStream());
                outputStream = PictureContentResolver.getContentResolverOpenOutputStream(this.mContext, outputUri);
                if (outputStream != null) {
                    int read;
                    bout = new BufferedOutputStream(outputStream);
                    while ((read = bin.read(buffer)) > -1) {
                        bout.write(buffer, 0, read);
                    }
                    bout.flush();
                }
                this.mInputUri = this.mOutputUri;
            }
            catch (Exception e) {
                e.printStackTrace();
                break block8;
            }
            finally {
                this.mInputUri = this.mOutputUri;
                BitmapLoadUtils.close(bout);
                BitmapLoadUtils.close(bin);
                BitmapLoadUtils.close(outputStream);
            }
            BitmapLoadUtils.close(bout);
            BitmapLoadUtils.close(bin);
            BitmapLoadUtils.close(outputStream);
        }
    }

    protected void onPostExecute(@NonNull BitmapWorkerResult result) {
        if (result.mBitmapWorkerException == null) {
            String inputUriString = this.mInputUri.toString();
            this.mBitmapLoadCallback.onBitmapLoaded(result.mBitmapResult, result.mExifInfo, PictureMimeType.isContent(inputUriString) ? inputUriString : this.mInputUri.getPath(), this.mOutputUri == null ? null : this.mOutputUri.getPath());
        } else {
            this.mBitmapLoadCallback.onFailure(result.mBitmapWorkerException);
        }
    }

    private boolean checkSize(Bitmap bitmap, BitmapFactory.Options options) {
        int bitmapSize;
        int n = bitmapSize = bitmap != null ? bitmap.getByteCount() : 0;
        if (bitmapSize > 0x6400000) {
            options.inSampleSize *= 2;
            return true;
        }
        return false;
    }

    public static class BitmapWorkerResult {
        Bitmap mBitmapResult;
        ExifInfo mExifInfo;
        Exception mBitmapWorkerException;

        public BitmapWorkerResult(@NonNull Bitmap bitmapResult, @NonNull ExifInfo exifInfo) {
            this.mBitmapResult = bitmapResult;
            this.mExifInfo = exifInfo;
        }

        public BitmapWorkerResult(@NonNull Exception bitmapWorkerException) {
            this.mBitmapWorkerException = bitmapWorkerException;
        }
    }
}

