/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.io;

import com.luck.picture.lib.io.ArrayPoolProvide;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStreamWrap
extends FilterInputStream {
    public static final int DEFAULT_MARK_READ_LIMIT = 0x500000;
    private volatile byte[] buf;
    private int count;
    private int markLimit;
    private int markPos = -1;
    private int pos;

    public BufferedInputStreamWrap(InputStream in) {
        this(in, 65536);
    }

    BufferedInputStreamWrap(InputStream in, int bufferSize) {
        super(in);
        this.buf = ArrayPoolProvide.getInstance().get(bufferSize);
    }

    @Override
    public synchronized int available() throws IOException {
        InputStream localIn = this.in;
        if (this.buf == null || localIn == null) {
            return 0;
        }
        return this.count - this.pos + localIn.available();
    }

    private static IOException streamClosed() throws IOException {
        throw new IOException("BufferedInputStream is closed");
    }

    public synchronized void fixMarkLimit() {
        this.markLimit = this.buf.length;
    }

    public synchronized void release() {
        if (this.buf != null) {
            ArrayPoolProvide.getInstance().put(this.buf);
            this.buf = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buf != null) {
            ArrayPoolProvide.getInstance().put(this.buf);
            this.buf = null;
        }
        InputStream localIn = this.in;
        this.in = null;
        if (localIn != null) {
            localIn.close();
        }
    }

    private int fillbuf(InputStream localIn, byte[] localBuf) throws IOException {
        if (this.markPos == -1 || this.pos - this.markPos >= this.markLimit) {
            int result = localIn.read(localBuf);
            if (result > 0) {
                this.markPos = -1;
                this.pos = 0;
                this.count = result;
            }
            return result;
        }
        if (this.markPos == 0 && this.markLimit > localBuf.length && this.count == localBuf.length) {
            int newLength = localBuf.length * 2;
            if (newLength > this.markLimit) {
                newLength = this.markLimit;
            }
            byte[] newbuf = ArrayPoolProvide.getInstance().get(newLength);
            System.arraycopy(localBuf, 0, newbuf, 0, localBuf.length);
            byte[] oldbuf = localBuf;
            this.buf = newbuf;
            localBuf = newbuf;
            ArrayPoolProvide.getInstance().put(oldbuf);
        } else if (this.markPos > 0) {
            System.arraycopy(localBuf, this.markPos, localBuf, 0, localBuf.length - this.markPos);
        }
        this.pos -= this.markPos;
        this.markPos = 0;
        this.count = 0;
        int byteRead = localIn.read(localBuf, this.pos, localBuf.length - this.pos);
        this.count = byteRead <= 0 ? this.pos : this.pos + byteRead;
        return byteRead;
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.markLimit = Math.max(this.markLimit, readLimit);
        this.markPos = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] localBuf = this.buf;
        InputStream localIn = this.in;
        if (localBuf == null || localIn == null) {
            throw BufferedInputStreamWrap.streamClosed();
        }
        if (this.pos >= this.count && this.fillbuf(localIn, localBuf) == -1) {
            return -1;
        }
        if (localBuf != this.buf && (localBuf = this.buf) == null) {
            throw BufferedInputStreamWrap.streamClosed();
        }
        if (this.count - this.pos > 0) {
            return localBuf[this.pos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] buffer, int offset, int byteCount) throws IOException {
        int required;
        byte[] localBuf = this.buf;
        if (localBuf == null) {
            throw BufferedInputStreamWrap.streamClosed();
        }
        if (byteCount == 0) {
            return 0;
        }
        InputStream localIn = this.in;
        if (localIn == null) {
            throw BufferedInputStreamWrap.streamClosed();
        }
        if (this.pos < this.count) {
            int copylength = Math.min(this.count - this.pos, byteCount);
            System.arraycopy(localBuf, this.pos, buffer, offset, copylength);
            this.pos += copylength;
            if (copylength == byteCount || localIn.available() == 0) {
                return copylength;
            }
            offset += copylength;
            required = byteCount - copylength;
        } else {
            required = byteCount;
        }
        while (true) {
            int read;
            if (this.markPos == -1 && required >= localBuf.length) {
                read = localIn.read(buffer, offset, required);
                if (read == -1) {
                    return required == byteCount ? -1 : byteCount - required;
                }
            } else {
                if (this.fillbuf(localIn, localBuf) == -1) {
                    return required == byteCount ? -1 : byteCount - required;
                }
                if (localBuf != this.buf && (localBuf = this.buf) == null) {
                    throw BufferedInputStreamWrap.streamClosed();
                }
                read = Math.min(this.count - this.pos, required);
                System.arraycopy(localBuf, this.pos, buffer, offset, read);
                this.pos += read;
            }
            if ((required -= read) == 0) {
                return byteCount;
            }
            if (localIn.available() == 0) {
                return byteCount - required;
            }
            offset += read;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream is closed");
        }
        if (-1 == this.markPos) {
            throw new InvalidMarkException("Mark has been invalidated, pos: " + this.pos + " markLimit: " + this.markLimit);
        }
        this.pos = this.markPos;
    }

    @Override
    public synchronized long skip(long byteCount) throws IOException {
        if (byteCount < 1L) {
            return 0L;
        }
        byte[] localBuf = this.buf;
        if (localBuf == null) {
            throw BufferedInputStreamWrap.streamClosed();
        }
        InputStream localIn = this.in;
        if (localIn == null) {
            throw BufferedInputStreamWrap.streamClosed();
        }
        if ((long)(this.count - this.pos) >= byteCount) {
            this.pos = (int)((long)this.pos + byteCount);
            return byteCount;
        }
        long read = (long)this.count - (long)this.pos;
        this.pos = this.count;
        if (this.markPos != -1 && byteCount <= (long)this.markLimit) {
            if (this.fillbuf(localIn, localBuf) == -1) {
                return read;
            }
            if ((long)(this.count - this.pos) >= byteCount - read) {
                this.pos = (int)((long)this.pos + byteCount - read);
                return byteCount;
            }
            read = read + (long)this.count - (long)this.pos;
            this.pos = this.count;
            return read;
        }
        return read + localIn.skip(byteCount - read);
    }

    static class InvalidMarkException
    extends IOException {
        private static final long serialVersionUID = -4338378848813561759L;

        InvalidMarkException(String detailMessage) {
            super(detailMessage);
        }
    }
}

