/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.graphics.PointF;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.PictureContentResolver;
import com.luck.picture.lib.PictureMediaScannerConnection;
import com.luck.picture.lib.R;
import com.luck.picture.lib.broadcast.BroadcastManager;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.dialog.PictureCustomDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnImageCompleteCallback;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.photoview.PhotoView;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.tools.AttrsUtils;
import com.luck.picture.lib.tools.CameraFileUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.JumpUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.ValueOf;
import com.luck.picture.lib.widget.PreviewViewPager;
import com.luck.picture.lib.widget.longimage.ImageSource;
import com.luck.picture.lib.widget.longimage.ImageViewState;
import com.luck.picture.lib.widget.longimage.SubsamplingScaleImageView;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PictureExternalPreviewActivity
extends PictureBaseActivity
implements View.OnClickListener {
    private int mScreenWidth;
    private int mScreenHeight;
    private ImageButton ibLeftBack;
    private TextView tvTitle;
    private PreviewViewPager viewPager;
    private final List<LocalMedia> images = new ArrayList<LocalMedia>();
    private int position = 0;
    private SimpleFragmentAdapter adapter;
    private String downloadPath;
    private String mMimeType;
    private ImageButton ibDelete;
    private View mTitleBar;

    @Override
    public int getResourceId() {
        return R.layout.picture_activity_external_preview;
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        this.mTitleBar = this.findViewById(R.id.titleBar);
        this.tvTitle = (TextView)this.findViewById(R.id.picture_title);
        this.ibLeftBack = (ImageButton)this.findViewById(R.id.left_back);
        this.ibDelete = (ImageButton)this.findViewById(R.id.ib_delete);
        this.viewPager = (PreviewViewPager)this.findViewById(R.id.preview_pager);
        this.position = this.getIntent().getIntExtra("position", 0);
        this.mScreenWidth = ScreenUtils.getScreenWidth(this.getContext());
        this.mScreenHeight = ScreenUtils.getScreenHeight(this.getContext());
        ArrayList mediaList = this.getIntent().getParcelableArrayListExtra("previewSelectList");
        if (mediaList != null && mediaList.size() > 0) {
            this.images.addAll(mediaList);
        }
        this.ibLeftBack.setOnClickListener((View.OnClickListener)this);
        this.ibDelete.setOnClickListener((View.OnClickListener)this);
        this.ibDelete.setVisibility(PictureSelectionConfig.style != null ? (PictureSelectionConfig.style.pictureExternalPreviewGonePreviewDelete ? 0 : 8) : 8);
        this.initViewPageAdapterData();
    }

    @Override
    public void initPictureSelectorStyle() {
        if (PictureSelectionConfig.style != null) {
            if (PictureSelectionConfig.style.pictureTitleTextColor != 0) {
                this.tvTitle.setTextColor(PictureSelectionConfig.style.pictureTitleTextColor);
            }
            if (PictureSelectionConfig.style.pictureTitleTextSize != 0) {
                this.tvTitle.setTextSize((float)PictureSelectionConfig.style.pictureTitleTextSize);
            }
            if (PictureSelectionConfig.style.pictureLeftBackIcon != 0) {
                this.ibLeftBack.setImageResource(PictureSelectionConfig.style.pictureLeftBackIcon);
            }
            if (PictureSelectionConfig.style.pictureExternalPreviewDeleteStyle != 0) {
                this.ibDelete.setImageResource(PictureSelectionConfig.style.pictureExternalPreviewDeleteStyle);
            }
            if (PictureSelectionConfig.style.pictureTitleBarBackgroundColor != 0) {
                this.mTitleBar.setBackgroundColor(this.colorPrimary);
            }
        } else {
            int previewBgColor = AttrsUtils.getTypeValueColor(this.getContext(), R.attr.picture_ac_preview_title_bg);
            if (previewBgColor != 0) {
                this.mTitleBar.setBackgroundColor(previewBgColor);
            } else {
                this.mTitleBar.setBackgroundColor(this.colorPrimary);
            }
        }
    }

    private void initViewPageAdapterData() {
        this.tvTitle.setText((CharSequence)this.getString(R.string.picture_preview_image_num, new Object[]{this.position + 1, this.images.size()}));
        this.adapter = new SimpleFragmentAdapter();
        this.viewPager.setAdapter(this.adapter);
        this.viewPager.setCurrentItem(this.position);
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int index) {
                PictureExternalPreviewActivity.this.tvTitle.setText((CharSequence)PictureExternalPreviewActivity.this.getString(R.string.picture_preview_image_num, new Object[]{index + 1, PictureExternalPreviewActivity.this.images.size()}));
                PictureExternalPreviewActivity.this.position = index;
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.left_back) {
            this.finish();
            this.exitAnimation();
        } else if (id2 == R.id.ib_delete && this.images.size() > 0) {
            int currentItem = this.viewPager.getCurrentItem();
            this.images.remove(currentItem);
            this.adapter.removeCacheView(currentItem);
            Bundle bundle = new Bundle();
            bundle.putInt("position", currentItem);
            BroadcastManager.getInstance(this.getContext()).action("com.luck.picture.lib.action.delete_preview_position").extras(bundle).broadcast();
            if (this.images.size() == 0) {
                this.onBackPressed();
                return;
            }
            this.tvTitle.setText((CharSequence)this.getString(R.string.picture_preview_image_num, new Object[]{this.position + 1, this.images.size()}));
            this.position = currentItem;
            this.adapter.notifyDataSetChanged();
        }
    }

    private void displayLongPic(Uri uri, SubsamplingScaleImageView longImg) {
        longImg.setQuickScaleEnabled(true);
        longImg.setZoomEnabled(true);
        longImg.setDoubleTapZoomDuration(100);
        longImg.setMinimumScaleType(2);
        longImg.setDoubleTapZoomDpi(2);
        longImg.setImage(ImageSource.uri(uri), new ImageViewState(0.0f, new PointF(0.0f, 0.0f), 0));
    }

    private void showDownLoadDialog() {
        if (!this.isFinishing() && !TextUtils.isEmpty((CharSequence)this.downloadPath)) {
            PictureCustomDialog dialog = new PictureCustomDialog(this.getContext(), R.layout.picture_wind_base_dialog);
            Button btn_cancel = (Button)dialog.findViewById(R.id.btn_cancel);
            Button btn_commit = (Button)dialog.findViewById(R.id.btn_commit);
            TextView tvTitle = (TextView)dialog.findViewById(R.id.tvTitle);
            TextView tv_content = (TextView)dialog.findViewById(R.id.tv_content);
            tvTitle.setText((CharSequence)this.getString(R.string.picture_prompt));
            tv_content.setText((CharSequence)this.getString(R.string.picture_prompt_content));
            btn_cancel.setOnClickListener(v -> {
                if (!this.isFinishing()) {
                    dialog.dismiss();
                }
            });
            btn_commit.setOnClickListener(view -> {
                if (PictureMimeType.isHasHttp(this.downloadPath)) {
                    this.showPleaseDialog();
                    PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<String>(){

                        @Override
                        public String doInBackground() {
                            return PictureExternalPreviewActivity.this.showLoadingImage(PictureExternalPreviewActivity.this.downloadPath);
                        }

                        @Override
                        public void onSuccess(String result) {
                            PictureThreadUtils.cancel(PictureThreadUtils.getIoPool());
                            PictureExternalPreviewActivity.this.onSuccessful(result);
                            PictureExternalPreviewActivity.this.dismissDialog();
                        }
                    });
                } else if (SdkVersionUtils.isQ()) {
                    this.savePictureAlbumAndroidQ(PictureMimeType.isContent(this.downloadPath) ? Uri.parse((String)this.downloadPath) : Uri.fromFile((File)new File(this.downloadPath)));
                } else {
                    this.savePictureAlbum();
                }
                if (!this.isFinishing()) {
                    dialog.dismiss();
                }
            });
            dialog.show();
        }
    }

    private void savePictureAlbum() {
        File folderDir;
        File rootDir;
        String suffix = PictureMimeType.getLastImgSuffix(this.mMimeType);
        String state = Environment.getExternalStorageState();
        File file = rootDir = state.equals("mounted") ? Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) : this.getContext().getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (rootDir != null && !rootDir.exists()) {
            rootDir.mkdirs();
        }
        if (!(folderDir = new File(SdkVersionUtils.isQ() || !state.equals("mounted") ? rootDir.getAbsolutePath() : rootDir.getAbsolutePath() + File.separator + "Camera" + File.separator)).exists()) {
            folderDir.mkdirs();
        }
        String fileName = DateUtils.getCreateFileName("IMG_") + suffix;
        File file2 = new File(folderDir, fileName);
        PictureFileUtils.copyFile(this.downloadPath, file2.getAbsolutePath());
        this.onSuccessful(file2.getAbsolutePath());
    }

    private void onSuccessful(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            ToastUtils.s(this.getContext(), this.getString(R.string.picture_save_error));
        } else {
            new PictureMediaScannerConnection(this.getContext(), filePath, null);
            ToastUtils.s(this.getContext(), this.getString(R.string.picture_save_success) + "\n" + filePath);
        }
    }

    private void savePictureAlbumAndroidQ(final Uri inputUri) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        contentValues.put("datetaken", ValueOf.toString(System.currentTimeMillis()));
        contentValues.put("mime_type", this.mMimeType);
        contentValues.put("relative_path", "DCIM/Camera");
        final Uri uri = this.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
        if (uri == null) {
            ToastUtils.s(this.getContext(), this.getString(R.string.picture_save_error));
            return;
        }
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<String>(){

            @Override
            public String doInBackground() {
                try {
                    InputStream inputStream = PictureContentResolver.getContentResolverOpenInputStream(PictureExternalPreviewActivity.this.getContext(), inputUri);
                    OutputStream outputStream = PictureContentResolver.getContentResolverOpenOutputStream(PictureExternalPreviewActivity.this.getContext(), uri);
                    boolean bufferCopy = PictureFileUtils.writeFileFromIS(inputStream, outputStream);
                    if (bufferCopy) {
                        return PictureFileUtils.getPath(PictureExternalPreviewActivity.this.getContext(), uri);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return "";
            }

            @Override
            public void onSuccess(String result) {
                PictureThreadUtils.cancel(PictureThreadUtils.getIoPool());
                PictureExternalPreviewActivity.this.onSuccessful(result);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String showLoadingImage(String urlPath) {
        InputStream inputStream;
        OutputStream outputStream;
        block11: {
            String string2;
            block10: {
                Uri outImageUri = null;
                outputStream = null;
                inputStream = null;
                try {
                    if (SdkVersionUtils.isQ()) {
                        outImageUri = CameraFileUtils.createImageUri(this.getContext(), "", this.mMimeType);
                    } else {
                        File folderDir;
                        File rootDir;
                        String suffix = PictureMimeType.getLastImgSuffix(this.mMimeType);
                        String state = Environment.getExternalStorageState();
                        File file = rootDir = state.equals("mounted") ? Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM) : this.getContext().getExternalFilesDir(Environment.DIRECTORY_PICTURES);
                        if (!rootDir.exists()) {
                            rootDir.mkdirs();
                        }
                        if (!(folderDir = new File(!state.equals("mounted") ? rootDir.getAbsolutePath() : rootDir.getAbsolutePath() + File.separator + "Camera" + File.separator)).exists()) {
                            folderDir.mkdirs();
                        }
                        String fileName = DateUtils.getCreateFileName("IMG_") + suffix;
                        File outFile = new File(folderDir, fileName);
                        outImageUri = Uri.fromFile((File)outFile);
                    }
                    outputStream = PictureContentResolver.getContentResolverOpenOutputStream(this.getContext(), outImageUri);
                    inputStream = new URL(urlPath).openStream();
                    boolean bufferCopy = PictureFileUtils.writeFileFromIS(inputStream, outputStream);
                    if (bufferCopy) {
                        string2 = PictureFileUtils.getPath((Context)this, outImageUri);
                        PictureFileUtils.close(inputStream);
                        break block10;
                    }
                    PictureFileUtils.close(inputStream);
                    break block11;
                }
                catch (Exception e) {
                    if (!SdkVersionUtils.isQ()) return null;
                    MediaUtils.deleteUri(this.getContext(), outImageUri);
                    return null;
                }
            }
            PictureFileUtils.close(outputStream);
            return string2;
        }
        PictureFileUtils.close(outputStream);
        return null;
        finally {
            PictureFileUtils.close(inputStream);
            PictureFileUtils.close(outputStream);
        }
    }

    public void onBackPressed() {
        if (SdkVersionUtils.isQ()) {
            this.finishAfterTransition();
        } else {
            super.onBackPressed();
        }
        this.finish();
        this.exitAnimation();
    }

    private void exitAnimation() {
        this.overridePendingTransition(R.anim.picture_anim_fade_in, PictureSelectionConfig.windowAnimationStyle.activityPreviewExitAnimation);
    }

    public void finish() {
        super.finish();
        if (this.adapter != null) {
            this.adapter.clear();
        }
        PictureSelectionConfig.destroy();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1) {
            for (int grantResult : grantResults) {
                if (grantResult == 0) {
                    this.showDownLoadDialog();
                    continue;
                }
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_jurisdiction));
            }
        }
    }

    public class SimpleFragmentAdapter
    extends PagerAdapter {
        private static final int MAX_CACHE_SIZE = 20;
        private final SparseArray<View> mCacheView = new SparseArray();

        private void clear() {
            this.mCacheView.clear();
        }

        public void removeCacheView(int position) {
            if (position < this.mCacheView.size()) {
                this.mCacheView.removeAt(position);
            }
        }

        public int getCount() {
            return PictureExternalPreviewActivity.this.images.size();
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
            if (this.mCacheView.size() > 20) {
                this.mCacheView.remove(position);
            }
        }

        public int getItemPosition(@NonNull Object object) {
            return -2;
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View contentView = (View)this.mCacheView.get(position);
            if (contentView == null) {
                contentView = LayoutInflater.from((Context)container.getContext()).inflate(R.layout.picture_image_preview, container, false);
                this.mCacheView.put(position, (Object)contentView);
            }
            PhotoView photoView = (PhotoView)contentView.findViewById(R.id.preview_image);
            SubsamplingScaleImageView longImageView = (SubsamplingScaleImageView)contentView.findViewById(R.id.longImg);
            ImageView ivPlay = (ImageView)contentView.findViewById(R.id.iv_play);
            LocalMedia media = (LocalMedia)PictureExternalPreviewActivity.this.images.get(position);
            if (PictureExternalPreviewActivity.this.config.isAutoScalePreviewImage) {
                float width = Math.min(media.getWidth(), media.getHeight());
                float height = Math.max(media.getHeight(), media.getWidth());
                if (width > 0.0f && height > 0.0f) {
                    int displayHeight = (int)Math.ceil(width * height / width);
                    FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)photoView.getLayoutParams();
                    layoutParams.width = PictureExternalPreviewActivity.this.mScreenWidth;
                    layoutParams.height = displayHeight < PictureExternalPreviewActivity.this.mScreenHeight ? displayHeight + PictureExternalPreviewActivity.this.mScreenHeight : displayHeight;
                    layoutParams.gravity = 17;
                }
            }
            final String path = media.isCut() && !media.isCompressed() ? media.getCutPath() : (media.isCompressed() || media.isCut() && media.isCompressed() ? media.getCompressPath() : (media.isToSandboxPath() ? media.getAndroidQToPath() : media.getPath()));
            boolean isHttp = PictureMimeType.isHasHttp(path);
            String mimeType = isHttp && TextUtils.isEmpty((CharSequence)media.getMimeType()) ? PictureMimeType.getImageMimeType(media.getPath()) : media.getMimeType();
            boolean isHasVideo = PictureMimeType.isHasVideo(mimeType);
            ivPlay.setVisibility(isHasVideo ? 0 : 8);
            boolean isGif = PictureMimeType.isGif(mimeType);
            boolean eqLongImg = MediaUtils.isLongImg(media);
            photoView.setVisibility(eqLongImg && !isGif ? 8 : 0);
            longImageView.setVisibility(eqLongImg && !isGif ? 0 : 8);
            if (PictureSelectionConfig.imageEngine != null) {
                if (isHttp) {
                    PictureSelectionConfig.imageEngine.loadImage(contentView.getContext(), path, (ImageView)photoView, longImageView, new OnImageCompleteCallback(){

                        @Override
                        public void onShowLoading() {
                            int currentItem = PictureExternalPreviewActivity.this.viewPager.getCurrentItem();
                            LocalMedia localMedia = (LocalMedia)PictureExternalPreviewActivity.this.images.get(currentItem);
                            if (TextUtils.equals((CharSequence)path, (CharSequence)localMedia.getPath())) {
                                PictureExternalPreviewActivity.this.showPleaseDialog();
                            }
                        }

                        @Override
                        public void onHideLoading() {
                            PictureExternalPreviewActivity.this.dismissDialog();
                        }
                    });
                } else if (eqLongImg) {
                    PictureExternalPreviewActivity.this.displayLongPic(PictureMimeType.isContent(path) ? Uri.parse((String)path) : Uri.fromFile((File)new File(path)), longImageView);
                } else {
                    PictureSelectionConfig.imageEngine.loadImage(contentView.getContext(), path, (ImageView)photoView);
                }
            }
            photoView.setOnViewTapListener((view, x, y) -> {
                PictureExternalPreviewActivity.this.finish();
                PictureExternalPreviewActivity.this.exitAnimation();
            });
            longImageView.setOnClickListener(v -> {
                PictureExternalPreviewActivity.this.finish();
                PictureExternalPreviewActivity.this.exitAnimation();
            });
            if (!isHasVideo) {
                longImageView.setOnLongClickListener(v -> {
                    if (PictureExternalPreviewActivity.this.config.isNotPreviewDownload) {
                        if (PermissionChecker.checkSelfPermission(PictureExternalPreviewActivity.this.getContext(), "android.permission.WRITE_EXTERNAL_STORAGE")) {
                            PictureExternalPreviewActivity.this.downloadPath = path;
                            String currentMimeType = PictureMimeType.isHasHttp(path) && TextUtils.isEmpty((CharSequence)media.getMimeType()) ? PictureMimeType.getImageMimeType(media.getPath()) : media.getMimeType();
                            PictureExternalPreviewActivity.this.mMimeType = PictureMimeType.isJPG(currentMimeType) ? "image/jpeg" : currentMimeType;
                            PictureExternalPreviewActivity.this.showDownLoadDialog();
                        } else {
                            PermissionChecker.requestPermissions((Activity)PictureExternalPreviewActivity.this, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
                        }
                    }
                    return true;
                });
            }
            if (!isHasVideo) {
                photoView.setOnLongClickListener(v -> {
                    if (PictureExternalPreviewActivity.this.config.isNotPreviewDownload) {
                        if (PermissionChecker.checkSelfPermission(PictureExternalPreviewActivity.this.getContext(), "android.permission.WRITE_EXTERNAL_STORAGE")) {
                            PictureExternalPreviewActivity.this.downloadPath = path;
                            String currentMimeType = PictureMimeType.isHasHttp(path) && TextUtils.isEmpty((CharSequence)media.getMimeType()) ? PictureMimeType.getImageMimeType(media.getPath()) : media.getMimeType();
                            PictureExternalPreviewActivity.this.mMimeType = PictureMimeType.isJPG(currentMimeType) ? "image/jpeg" : currentMimeType;
                            PictureExternalPreviewActivity.this.showDownLoadDialog();
                        } else {
                            PermissionChecker.requestPermissions((Activity)PictureExternalPreviewActivity.this, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
                        }
                    }
                    return true;
                });
            }
            ivPlay.setOnClickListener(v -> {
                if (PictureSelectionConfig.customVideoPlayCallback != null) {
                    PictureSelectionConfig.customVideoPlayCallback.startPlayVideo(media);
                } else {
                    Intent intent = new Intent();
                    Bundle bundle = new Bundle();
                    bundle.putString("videoPath", path);
                    intent.putExtras(bundle);
                    JumpUtils.startPictureVideoPlayActivity(container.getContext(), bundle, 166);
                }
            });
            container.addView(contentView, 0);
            return contentView;
        }
    }
}

