/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.camera;

import android.content.ContentValues;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.VideoCapture;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import com.luck.picture.lib.R;
import com.luck.picture.lib.camera.listener.CameraListener;
import com.luck.picture.lib.camera.listener.CaptureListener;
import com.luck.picture.lib.camera.listener.ClickListener;
import com.luck.picture.lib.camera.listener.ImageCallbackListener;
import com.luck.picture.lib.camera.listener.TypeListener;
import com.luck.picture.lib.camera.view.CaptureLayout;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.tools.CameraFileUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.StringUtils;
import java.io.File;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public class CustomCameraView
extends RelativeLayout {
    public static final int DEFAULT_MIN_RECORD_VIDEO = 1500;
    private static final int TYPE_FLASH_AUTO = 33;
    private static final int TYPE_FLASH_ON = 34;
    private static final int TYPE_FLASH_OFF = 35;
    private int type_flash = 35;
    private PictureSelectionConfig mConfig;
    private PreviewView mCameraPreviewView;
    private ProcessCameraProvider mCameraProvider;
    private ImageCapture mImageCapture;
    private VideoCapture mVideoCapture;
    private int useCameraCases = 1;
    private int lensFacing = 1;
    private CameraListener mCameraListener;
    private ClickListener mOnClickListener;
    private ImageCallbackListener mImageCallbackListener;
    private ImageView mImagePreview;
    private ImageView mSwitchCamera;
    private ImageView mFlashLamp;
    private CaptureLayout mCaptureLayout;
    private MediaPlayer mMediaPlayer;
    private TextureView mTextureView;
    private long recordTime = 0L;
    private final TextureView.SurfaceTextureListener surfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            CustomCameraView.this.startVideoPlay(((CustomCameraView)CustomCameraView.this).mConfig.cameraPath);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            return false;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }
    };

    private boolean isImageCaptureEnabled() {
        return this.useCameraCases == 1;
    }

    public CustomCameraView(Context context) {
        super(context);
        this.initView();
    }

    public CustomCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public CustomCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        CustomCameraView.inflate((Context)this.getContext(), (int)R.layout.picture_camera_view, (ViewGroup)this);
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_black));
        this.mCameraPreviewView = (PreviewView)this.findViewById(R.id.cameraPreviewView);
        this.mTextureView = (TextureView)this.findViewById(R.id.video_play_preview);
        this.mImagePreview = (ImageView)this.findViewById(R.id.image_preview);
        this.mSwitchCamera = (ImageView)this.findViewById(R.id.image_switch);
        this.mFlashLamp = (ImageView)this.findViewById(R.id.image_flash);
        this.mCaptureLayout = (CaptureLayout)this.findViewById(R.id.capture_layout);
        this.mSwitchCamera.setImageResource(R.drawable.picture_ic_camera);
        this.mFlashLamp.setOnClickListener(v -> {
            ++this.type_flash;
            if (this.type_flash > 35) {
                this.type_flash = 33;
            }
            this.setFlashMode();
        });
        this.mCaptureLayout.setDuration(15000);
        this.mSwitchCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomCameraView.this.toggleCamera();
            }
        });
        this.mCaptureLayout.setCaptureListener(new CaptureListener(){

            @Override
            public void takePictures() {
                ImageCapture.OutputFileOptions fileOptions;
                String cameraFileName;
                if (!CustomCameraView.this.mCameraProvider.isBound((UseCase)CustomCameraView.this.mImageCapture)) {
                    CustomCameraView.this.bindCameraImageUseCases();
                }
                CustomCameraView.this.useCameraCases = 1;
                CustomCameraView.this.mCaptureLayout.setButtonCaptureEnabled(false);
                CustomCameraView.this.mSwitchCamera.setVisibility(4);
                CustomCameraView.this.mFlashLamp.setVisibility(4);
                if (TextUtils.isEmpty((CharSequence)((CustomCameraView)CustomCameraView.this).mConfig.cameraFileName)) {
                    cameraFileName = "";
                } else {
                    boolean isSuffixOfImage = PictureMimeType.isSuffixOfImage(((CustomCameraView)CustomCameraView.this).mConfig.cameraFileName);
                    ((CustomCameraView)CustomCameraView.this).mConfig.cameraFileName = !isSuffixOfImage ? StringUtils.renameSuffix(((CustomCameraView)CustomCameraView.this).mConfig.cameraFileName, ".jpg") : ((CustomCameraView)CustomCameraView.this).mConfig.cameraFileName;
                    String string2 = cameraFileName = ((CustomCameraView)CustomCameraView.this).mConfig.camera ? ((CustomCameraView)CustomCameraView.this).mConfig.cameraFileName : StringUtils.rename(((CustomCameraView)CustomCameraView.this).mConfig.cameraFileName);
                }
                if (SdkVersionUtils.isQ() && TextUtils.isEmpty((CharSequence)((CustomCameraView)CustomCameraView.this).mConfig.outPutCameraPath)) {
                    ContentValues contentValues = CameraFileUtils.buildImageContentValues(cameraFileName, ((CustomCameraView)CustomCameraView.this).mConfig.cameraImageFormatForQ);
                    fileOptions = new ImageCapture.OutputFileOptions.Builder(CustomCameraView.this.getContext().getContentResolver(), MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues).build();
                } else {
                    File cameraFile = PictureFileUtils.createCameraFile(CustomCameraView.this.getContext(), 1, cameraFileName, ((CustomCameraView)CustomCameraView.this).mConfig.cameraImageFormat, ((CustomCameraView)CustomCameraView.this).mConfig.outPutCameraPath);
                    fileOptions = new ImageCapture.OutputFileOptions.Builder(cameraFile).build();
                }
                CustomCameraView.this.mImageCapture.takePicture(fileOptions, ContextCompat.getMainExecutor((Context)CustomCameraView.this.getContext()), (ImageCapture.OnImageSavedCallback)new MyImageResultCallback(CustomCameraView.this.mImagePreview, CustomCameraView.this.mCaptureLayout, CustomCameraView.this.mImageCallbackListener, CustomCameraView.this.mCameraListener, CustomCameraView.this.mConfig));
            }

            @Override
            public void recordStart() {
                VideoCapture.OutputFileOptions fileOptions;
                String cameraFileName;
                if (!CustomCameraView.this.mCameraProvider.isBound((UseCase)CustomCameraView.this.mVideoCapture)) {
                    CustomCameraView.this.bindCameraVideoUseCases();
                }
                CustomCameraView.this.useCameraCases = 4;
                CustomCameraView.this.mSwitchCamera.setVisibility(4);
                CustomCameraView.this.mFlashLamp.setVisibility(4);
                if (TextUtils.isEmpty((CharSequence)((CustomCameraView)CustomCameraView.this).mConfig.cameraFileName)) {
                    cameraFileName = "";
                } else {
                    boolean isSuffixOfImage = PictureMimeType.isSuffixOfImage(((CustomCameraView)CustomCameraView.this).mConfig.cameraFileName);
                    ((CustomCameraView)CustomCameraView.this).mConfig.cameraFileName = isSuffixOfImage ? StringUtils.renameSuffix(((CustomCameraView)CustomCameraView.this).mConfig.cameraFileName, ".mp4") : ((CustomCameraView)CustomCameraView.this).mConfig.cameraFileName;
                    String string2 = cameraFileName = ((CustomCameraView)CustomCameraView.this).mConfig.camera ? ((CustomCameraView)CustomCameraView.this).mConfig.cameraFileName : StringUtils.rename(((CustomCameraView)CustomCameraView.this).mConfig.cameraFileName);
                }
                if (SdkVersionUtils.isQ() && TextUtils.isEmpty((CharSequence)((CustomCameraView)CustomCameraView.this).mConfig.outPutCameraPath)) {
                    ContentValues contentValues = CameraFileUtils.buildVideoContentValues(cameraFileName, ((CustomCameraView)CustomCameraView.this).mConfig.cameraImageFormatForQ);
                    fileOptions = new VideoCapture.OutputFileOptions.Builder(CustomCameraView.this.getContext().getContentResolver(), MediaStore.Video.Media.EXTERNAL_CONTENT_URI, contentValues).build();
                } else {
                    File cameraFile = PictureFileUtils.createCameraFile(CustomCameraView.this.getContext(), 2, cameraFileName, ((CustomCameraView)CustomCameraView.this).mConfig.cameraVideoFormat, ((CustomCameraView)CustomCameraView.this).mConfig.outPutCameraPath);
                    fileOptions = new VideoCapture.OutputFileOptions.Builder(cameraFile).build();
                }
                CustomCameraView.this.mVideoCapture.startRecording(fileOptions, ContextCompat.getMainExecutor((Context)CustomCameraView.this.getContext()), new VideoCapture.OnVideoSavedCallback(){

                    public void onVideoSaved(@NonNull @NotNull VideoCapture.OutputFileResults outputFileResults) {
                        long minSecond;
                        long l = minSecond = ((CustomCameraView)CustomCameraView.this).mConfig.recordVideoMinSecond <= 0 ? 1500L : (long)((CustomCameraView)CustomCameraView.this).mConfig.recordVideoMinSecond * 1000L;
                        if (CustomCameraView.this.recordTime < minSecond || outputFileResults.getSavedUri() == null) {
                            return;
                        }
                        Uri savedUri = outputFileResults.getSavedUri();
                        String url = savedUri.toString();
                        ((CustomCameraView)CustomCameraView.this).mConfig.cameraPath = PictureMimeType.isContent(url) ? url : savedUri.getPath();
                        CustomCameraView.this.mTextureView.setVisibility(0);
                        CustomCameraView.this.mCameraPreviewView.setVisibility(4);
                        if (CustomCameraView.this.mTextureView.isAvailable()) {
                            CustomCameraView.this.startVideoPlay(((CustomCameraView)CustomCameraView.this).mConfig.cameraPath);
                        } else {
                            CustomCameraView.this.mTextureView.setSurfaceTextureListener(CustomCameraView.this.surfaceTextureListener);
                        }
                    }

                    public void onError(int videoCaptureError, @NonNull @NotNull String message, @Nullable @org.jetbrains.annotations.Nullable Throwable cause) {
                        if (CustomCameraView.this.mCameraListener != null) {
                            CustomCameraView.this.mCameraListener.onError(videoCaptureError, message, cause);
                        }
                    }
                });
            }

            @Override
            public void recordShort(long time) {
                CustomCameraView.this.recordTime = time;
                CustomCameraView.this.mSwitchCamera.setVisibility(0);
                CustomCameraView.this.mFlashLamp.setVisibility(0);
                CustomCameraView.this.mCaptureLayout.resetCaptureLayout();
                CustomCameraView.this.mCaptureLayout.setTextWithAnimation(CustomCameraView.this.getContext().getString(R.string.picture_recording_time_is_short));
                CustomCameraView.this.mVideoCapture.stopRecording();
            }

            @Override
            public void recordEnd(long time) {
                CustomCameraView.this.recordTime = time;
                CustomCameraView.this.mVideoCapture.stopRecording();
            }

            @Override
            public void recordZoom(float zoom) {
            }

            @Override
            public void recordError() {
                if (CustomCameraView.this.mCameraListener != null) {
                    CustomCameraView.this.mCameraListener.onError(0, "An unknown error", null);
                }
            }
        });
        this.mCaptureLayout.setTypeListener(new TypeListener(){

            @Override
            public void cancel() {
                CustomCameraView.this.onCancelMedia();
            }

            @Override
            public void confirm() {
                if (CustomCameraView.this.isImageCaptureEnabled()) {
                    CustomCameraView.this.mImagePreview.setVisibility(4);
                    if (CustomCameraView.this.mCameraListener != null) {
                        CustomCameraView.this.mCameraListener.onPictureSuccess(((CustomCameraView)CustomCameraView.this).mConfig.cameraPath);
                    }
                } else {
                    CustomCameraView.this.stopVideoPlay();
                    if (CustomCameraView.this.mCameraListener != null) {
                        CustomCameraView.this.mCameraListener.onRecordSuccess(((CustomCameraView)CustomCameraView.this).mConfig.cameraPath);
                    }
                }
            }
        });
        this.mCaptureLayout.setLeftClickListener(new ClickListener(){

            @Override
            public void onClick() {
                if (CustomCameraView.this.mOnClickListener != null) {
                    CustomCameraView.this.mOnClickListener.onClick();
                }
            }
        });
    }

    public void initCamera() {
        this.mConfig = PictureSelectionConfig.getInstance();
        int n = this.lensFacing = this.mConfig.isCameraAroundState ? 0 : 1;
        if (ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.CAMERA") == 0) {
            final ListenableFuture cameraProviderFuture = ProcessCameraProvider.getInstance((Context)this.getContext());
            cameraProviderFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        CustomCameraView.this.mCameraProvider = (ProcessCameraProvider)cameraProviderFuture.get();
                        CustomCameraView.this.bindCameraUseCases();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, ContextCompat.getMainExecutor((Context)this.getContext()));
        }
    }

    private void bindCameraUseCases() {
        if (this.mConfig.buttonFeatures == 259 || this.mConfig.buttonFeatures == 257) {
            this.bindCameraImageUseCases();
        } else {
            this.bindCameraVideoUseCases();
        }
    }

    private void bindCameraImageUseCases() {
        try {
            int screenAspectRatio = this.aspectRatio(ScreenUtils.getScreenWidth(this.getContext()), ScreenUtils.getScreenHeight(this.getContext()));
            CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(this.lensFacing).build();
            Preview preview = new Preview.Builder().setTargetAspectRatio(screenAspectRatio).build();
            this.mImageCapture = new ImageCapture.Builder().setCaptureMode(1).setTargetAspectRatio(screenAspectRatio).build();
            ImageAnalysis mImageAnalyzer = new ImageAnalysis.Builder().setTargetAspectRatio(screenAspectRatio).build();
            this.mCameraProvider.unbindAll();
            this.mCameraProvider.bindToLifecycle((LifecycleOwner)this.getContext(), cameraSelector, new UseCase[]{preview, this.mImageCapture, mImageAnalyzer});
            preview.setSurfaceProvider(this.mCameraPreviewView.getSurfaceProvider());
            this.setFlashMode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void bindCameraVideoUseCases() {
        try {
            CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(this.lensFacing).build();
            Preview preview = new Preview.Builder().build();
            this.mVideoCapture = new VideoCapture.Builder().build();
            this.mCameraProvider.unbindAll();
            this.mCameraProvider.bindToLifecycle((LifecycleOwner)this.getContext(), cameraSelector, new UseCase[]{preview, this.mVideoCapture});
            preview.setSurfaceProvider(this.mCameraPreviewView.getSurfaceProvider());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int aspectRatio(int width, int height) {
        int previewRatio = Math.max(width, height) / Math.min(width, height);
        double RATIO_4_3_VALUE = 1.3333333333333333;
        double RATIO_16_9_VALUE = 1.7777777777777777;
        if (Math.abs((double)previewRatio - RATIO_4_3_VALUE) <= Math.abs((double)previewRatio - RATIO_16_9_VALUE)) {
            return 0;
        }
        return 1;
    }

    public void setCameraListener(CameraListener cameraListener) {
        this.mCameraListener = cameraListener;
    }

    public void setRecordVideoMaxTime(int maxDurationTime) {
        this.mCaptureLayout.setDuration(maxDurationTime * 1000);
    }

    public void setRecordVideoMinTime(int minDurationTime) {
        this.mCaptureLayout.setMinDuration(minDurationTime * 1000);
    }

    public void setCaptureLoadingColor(int color2) {
        this.mCaptureLayout.setCaptureLoadingColor(color2);
    }

    public void toggleCamera() {
        this.lensFacing = 0 == this.lensFacing ? 1 : 0;
        this.bindCameraUseCases();
    }

    private void setFlashMode() {
        if (this.mImageCapture == null) {
            return;
        }
        switch (this.type_flash) {
            case 33: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_auto);
                this.mImageCapture.setFlashMode(0);
                break;
            }
            case 34: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_on);
                this.mImageCapture.setFlashMode(1);
                break;
            }
            case 35: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_off);
                this.mImageCapture.setFlashMode(2);
            }
        }
    }

    public void setOnClickListener(ClickListener clickListener) {
        this.mOnClickListener = clickListener;
    }

    public void setImageCallbackListener(ImageCallbackListener mImageCallbackListener) {
        this.mImageCallbackListener = mImageCallbackListener;
    }

    public CaptureLayout getCaptureLayout() {
        return this.mCaptureLayout;
    }

    private void resetState() {
        if (this.isImageCaptureEnabled()) {
            this.mImagePreview.setVisibility(4);
        } else {
            this.mVideoCapture.stopRecording();
        }
        this.mSwitchCamera.setVisibility(0);
        this.mFlashLamp.setVisibility(0);
        this.mCameraPreviewView.setVisibility(0);
        this.mCaptureLayout.resetCaptureLayout();
    }

    private void startVideoPlay(String url) {
        try {
            if (this.mMediaPlayer == null) {
                this.mMediaPlayer = new MediaPlayer();
            } else {
                this.mMediaPlayer.reset();
            }
            if (PictureMimeType.isContent(url)) {
                this.mMediaPlayer.setDataSource(this.getContext(), Uri.parse((String)url));
            } else {
                this.mMediaPlayer.setDataSource(url);
            }
            this.mMediaPlayer.setSurface(new Surface(this.mTextureView.getSurfaceTexture()));
            this.mMediaPlayer.setVideoScalingMode(1);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setOnVideoSizeChangedListener(new MediaPlayer.OnVideoSizeChangedListener(){

                public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
                    CustomCameraView.this.updateVideoViewSize(CustomCameraView.this.mMediaPlayer.getVideoWidth(), CustomCameraView.this.mMediaPlayer.getVideoHeight());
                }
            });
            this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    if (CustomCameraView.this.mMediaPlayer != null) {
                        CustomCameraView.this.mMediaPlayer.start();
                    }
                }
            });
            this.mMediaPlayer.setLooping(true);
            this.mMediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateVideoViewSize(float videoWidth, float videoHeight) {
        if (videoWidth > videoHeight) {
            int height = (int)(videoHeight / videoWidth * (float)this.getWidth());
            FrameLayout.LayoutParams videoViewParam = new FrameLayout.LayoutParams(-1, height);
            videoViewParam.gravity = 17;
            this.mTextureView.setLayoutParams((ViewGroup.LayoutParams)videoViewParam);
        }
    }

    public void onCancelMedia() {
        this.stopVideoPlay();
        this.resetState();
    }

    private void stopVideoPlay() {
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        this.mTextureView.setVisibility(8);
    }

    private static class MyImageResultCallback
    implements ImageCapture.OnImageSavedCallback {
        private final WeakReference<ImageView> mImagePreviewReference;
        private final WeakReference<CaptureLayout> mCaptureLayoutReference;
        private final WeakReference<ImageCallbackListener> mImageCallbackListenerReference;
        private final WeakReference<CameraListener> mCameraListenerReference;
        private final WeakReference<PictureSelectionConfig> mConfigReference;

        public MyImageResultCallback(ImageView imagePreview, CaptureLayout captureLayout, ImageCallbackListener imageCallbackListener, CameraListener cameraListener, PictureSelectionConfig config) {
            this.mImagePreviewReference = new WeakReference<ImageView>(imagePreview);
            this.mCaptureLayoutReference = new WeakReference<CaptureLayout>(captureLayout);
            this.mImageCallbackListenerReference = new WeakReference<ImageCallbackListener>(imageCallbackListener);
            this.mCameraListenerReference = new WeakReference<CameraListener>(cameraListener);
            this.mConfigReference = new WeakReference<PictureSelectionConfig>(config);
        }

        public void onImageSaved(@NonNull ImageCapture.OutputFileResults outputFileResults) {
            if (outputFileResults.getSavedUri() == null) {
                return;
            }
            Uri savedUri = outputFileResults.getSavedUri();
            String url = savedUri.toString();
            if (this.mConfigReference.get() != null) {
                String string2 = ((PictureSelectionConfig)this.mConfigReference.get()).cameraPath = PictureMimeType.isContent(url) ? url : savedUri.getPath();
            }
            if (this.mCaptureLayoutReference.get() != null) {
                ((CaptureLayout)((Object)this.mCaptureLayoutReference.get())).setButtonCaptureEnabled(true);
            }
            if (this.mImageCallbackListenerReference.get() != null && this.mImagePreviewReference.get() != null) {
                ((ImageCallbackListener)this.mImageCallbackListenerReference.get()).onLoadImage(url, (ImageView)this.mImagePreviewReference.get());
            }
            if (this.mImagePreviewReference.get() != null) {
                ((ImageView)this.mImagePreviewReference.get()).setVisibility(0);
            }
            if (this.mCaptureLayoutReference.get() != null) {
                ((CaptureLayout)((Object)this.mCaptureLayoutReference.get())).startTypeBtnAnimator();
            }
        }

        public void onError(@NonNull ImageCaptureException exception) {
            if (this.mCaptureLayoutReference.get() != null) {
                ((CaptureLayout)((Object)this.mCaptureLayoutReference.get())).setButtonCaptureEnabled(true);
            }
            if (this.mCameraListenerReference.get() != null) {
                ((CameraListener)this.mCameraListenerReference.get()).onError(exception.getImageCaptureError(), exception.getMessage(), exception.getCause());
            }
        }
    }
}

