/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.model;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.listener.OnQueryDataResultListener;
import com.luck.picture.lib.model.IBridgeMediaLoader;
import com.luck.picture.lib.model.SandboxFileLoader;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.SortUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

@Deprecated
public final class LocalMediaLoader
extends IBridgeMediaLoader {
    private static final String TAG = LocalMediaLoader.class.getSimpleName();
    private static final Uri QUERY_URI = MediaStore.Files.getContentUri((String)"external");
    private static final String ORDER_BY = "_id DESC";
    private static final String NOT_GIF_UNKNOWN = "!='image/*'";
    private static final String NOT_GIF = " AND (mime_type!='image/gif' AND mime_type!='image/*')";
    private static final int MAX_SORT_SIZE = 60;
    private final Context mContext;
    private final boolean isAndroidQ;
    private final PictureSelectionConfig config;
    private static final long FILE_SIZE_UNIT = 0x100000L;
    private static final String[] PROJECTION = new String[]{"_id", "_data", "mime_type", "width", "height", "duration", "_size", "bucket_display_name", "_display_name", "bucket_id", "date_added"};

    private static String getSelectionArgsForVideoOrAudioMediaCondition(String sizeCondition, String queryMimeCondition) {
        return "media_type=?" + queryMimeCondition + " AND " + sizeCondition;
    }

    private static String getSelectionArgsForAllMediaCondition(String timeCondition, String sizeCondition, String queryMimeCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append("media_type").append("=?").append(queryMimeCondition).append(" OR ").append("media_type").append("=? AND ").append(timeCondition).append(") AND ").append(sizeCondition).toString();
        return stringBuilder.toString();
    }

    private static String getSelectionArgsForImageMediaCondition(String sizeCondition, String queryMimeCondition) {
        return "media_type=?" + queryMimeCondition + " AND " + sizeCondition;
    }

    private static String[] getSelectionArgsForAllMediaType() {
        return new String[]{String.valueOf(1), String.valueOf(3)};
    }

    private static String[] getSelectionArgsForSingleMediaType(int mediaType) {
        return new String[]{String.valueOf(mediaType)};
    }

    public LocalMediaLoader(Context context, PictureSelectionConfig config) {
        this.mContext = context.getApplicationContext();
        this.isAndroidQ = SdkVersionUtils.isQ();
        this.config = config;
    }

    @Override
    public void loadOnlyInAppDirectoryAllMedia(final OnQueryDataResultListener<LocalMediaFolder> listener) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<LocalMediaFolder>(){

            @Override
            public LocalMediaFolder doInBackground() {
                return SandboxFileLoader.loadInAppSandboxFolderFile(LocalMediaLoader.this.mContext, ((LocalMediaLoader)LocalMediaLoader.this).config.sandboxFolderPath);
            }

            @Override
            public void onSuccess(LocalMediaFolder result) {
                PictureThreadUtils.cancel(PictureThreadUtils.getIoPool());
                if (listener != null) {
                    listener.onComplete(result);
                }
            }
        });
    }

    @Override
    public void loadAllMedia(final OnQueryDataResultListener<LocalMediaFolder> listener) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<List<LocalMediaFolder>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<LocalMediaFolder> doInBackground() {
                ArrayList<LocalMediaFolder> imageFolders = new ArrayList<LocalMediaFolder>();
                Cursor data = LocalMediaLoader.this.mContext.getContentResolver().query(QUERY_URI, PROJECTION, LocalMediaLoader.this.getSelection(), LocalMediaLoader.this.getSelectionArgs(), LocalMediaLoader.ORDER_BY);
                try {
                    if (data != null) {
                        LocalMediaFolder allImageFolder = new LocalMediaFolder();
                        ArrayList<LocalMedia> latelyImages = new ArrayList<LocalMedia>();
                        int count = data.getCount();
                        if (count > 0) {
                            int idColumn = data.getColumnIndexOrThrow(PROJECTION[0]);
                            int dataColumn = data.getColumnIndexOrThrow(PROJECTION[1]);
                            int mimeTypeColumn = data.getColumnIndexOrThrow(PROJECTION[2]);
                            int widthColumn = data.getColumnIndexOrThrow(PROJECTION[3]);
                            int heightColumn = data.getColumnIndexOrThrow(PROJECTION[4]);
                            int durationColumn = data.getColumnIndexOrThrow(PROJECTION[5]);
                            int sizeColumn = data.getColumnIndexOrThrow(PROJECTION[6]);
                            int folderNameColumn = data.getColumnIndexOrThrow(PROJECTION[7]);
                            int fileNameColumn = data.getColumnIndexOrThrow(PROJECTION[8]);
                            int bucketIdColumn = data.getColumnIndexOrThrow(PROJECTION[9]);
                            int dateAddedColumn = data.getColumnIndexOrThrow(PROJECTION[10]);
                            data.moveToFirst();
                            do {
                                String url;
                                long id2 = data.getLong(idColumn);
                                String mimeType = data.getString(mimeTypeColumn);
                                mimeType = TextUtils.isEmpty((CharSequence)mimeType) ? PictureMimeType.ofJPEG() : mimeType;
                                String absolutePath = data.getString(dataColumn);
                                String string2 = url = LocalMediaLoader.this.isAndroidQ ? PictureMimeType.getRealPathUri(id2, mimeType) : absolutePath;
                                if (mimeType.endsWith("image/*")) {
                                    boolean isGif;
                                    mimeType = PictureMimeType.isContent(url) ? PictureMimeType.getImageMimeType(absolutePath) : PictureMimeType.getImageMimeType(url);
                                    if (!((LocalMediaLoader)LocalMediaLoader.this).config.isGif && (isGif = PictureMimeType.isGif(mimeType))) continue;
                                }
                                if (!((LocalMediaLoader)LocalMediaLoader.this).config.isWebp && mimeType.startsWith(PictureMimeType.ofWEBP()) || !((LocalMediaLoader)LocalMediaLoader.this).config.isBmp && mimeType.startsWith(PictureMimeType.ofBMP())) continue;
                                int width = data.getInt(widthColumn);
                                int height = data.getInt(heightColumn);
                                long duration = data.getLong(durationColumn);
                                long size = data.getLong(sizeColumn);
                                String folderName = data.getString(folderNameColumn);
                                String fileName = data.getString(fileNameColumn);
                                long bucketId = data.getLong(bucketIdColumn);
                                if (((LocalMediaLoader)LocalMediaLoader.this).config.filterFileSize > 0.0f && (float)size > ((LocalMediaLoader)LocalMediaLoader.this).config.filterFileSize * 1048576.0f || PictureMimeType.isHasVideo(mimeType) && (((LocalMediaLoader)LocalMediaLoader.this).config.videoMinSecond > 0 && duration < (long)((LocalMediaLoader)LocalMediaLoader.this).config.videoMinSecond || ((LocalMediaLoader)LocalMediaLoader.this).config.videoMaxSecond > 0 && duration > (long)((LocalMediaLoader)LocalMediaLoader.this).config.videoMaxSecond || duration == 0L || size <= 0L)) continue;
                                LocalMedia image = LocalMedia.parseLocalMedia(id2, url, absolutePath, fileName, folderName, duration, ((LocalMediaLoader)LocalMediaLoader.this).config.chooseMode, mimeType, width, height, size, bucketId, data.getLong(dateAddedColumn));
                                LocalMediaFolder folder = LocalMediaLoader.this.getImageFolder(url, mimeType, folderName, imageFolders);
                                folder.setBucketId(image.getBucketId());
                                List<LocalMedia> images = folder.getData();
                                images.add(image);
                                folder.setImageNum(folder.getImageNum() + 1);
                                folder.setBucketId(image.getBucketId());
                                latelyImages.add(image);
                                int imageNum = allImageFolder.getImageNum();
                                allImageFolder.setImageNum(imageNum + 1);
                            } while (data.moveToNext());
                            LocalMediaFolder selfFolder = SandboxFileLoader.loadInAppSandboxFolderFile(LocalMediaLoader.this.mContext, ((LocalMediaLoader)LocalMediaLoader.this).config.sandboxFolderPath);
                            if (selfFolder != null) {
                                imageFolders.add(selfFolder);
                                allImageFolder.setImageNum(allImageFolder.getImageNum() + selfFolder.getImageNum());
                                allImageFolder.setData(selfFolder.getData());
                                latelyImages.addAll(0, selfFolder.getData());
                                if (60 > selfFolder.getImageNum()) {
                                    if (latelyImages.size() > 60) {
                                        SortUtils.sortLocalMediaAddedTime(latelyImages.subList(0, 60));
                                    } else {
                                        SortUtils.sortLocalMediaAddedTime(latelyImages);
                                    }
                                }
                            }
                            if (latelyImages.size() > 0) {
                                SortUtils.sortFolder(imageFolders);
                                imageFolders.add(0, allImageFolder);
                                allImageFolder.setFirstImagePath(((LocalMedia)latelyImages.get(0)).getPath());
                                allImageFolder.setFirstMimeType(((LocalMedia)latelyImages.get(0)).getMimeType());
                                String title = ((LocalMediaLoader)LocalMediaLoader.this).config.chooseMode == PictureMimeType.ofAudio() ? LocalMediaLoader.this.mContext.getString(R.string.picture_all_audio) : LocalMediaLoader.this.mContext.getString(R.string.picture_camera_roll);
                                allImageFolder.setName(title);
                                allImageFolder.setBucketId(-1L);
                                allImageFolder.setOfAllType(((LocalMediaLoader)LocalMediaLoader.this).config.chooseMode);
                                allImageFolder.setCameraFolder(true);
                                allImageFolder.setData(latelyImages);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (data != null && !data.isClosed()) {
                        data.close();
                    }
                }
                return imageFolders;
            }

            @Override
            public void onSuccess(List<LocalMediaFolder> result) {
                PictureThreadUtils.cancel(PictureThreadUtils.getIoPool());
                if (listener != null) {
                    listener.onComplete(result);
                }
            }
        });
    }

    private String getSelection() {
        String durationCondition = this.getDurationCondition();
        String fileSizeCondition = this.getFileSizeCondition();
        String queryMimeCondition = this.getQueryMimeCondition();
        switch (this.config.chooseMode) {
            case 0: {
                return LocalMediaLoader.getSelectionArgsForAllMediaCondition(durationCondition, fileSizeCondition, queryMimeCondition);
            }
            case 1: {
                return LocalMediaLoader.getSelectionArgsForImageMediaCondition(fileSizeCondition, queryMimeCondition);
            }
            case 2: {
                return LocalMediaLoader.getSelectionArgsForVideoOrAudioMediaCondition(fileSizeCondition, queryMimeCondition);
            }
            case 3: {
                return LocalMediaLoader.getSelectionArgsForVideoOrAudioMediaCondition(durationCondition, queryMimeCondition);
            }
        }
        return null;
    }

    private String[] getSelectionArgs() {
        switch (this.config.chooseMode) {
            case 0: {
                return LocalMediaLoader.getSelectionArgsForAllMediaType();
            }
            case 1: {
                return LocalMediaLoader.getSelectionArgsForSingleMediaType(1);
            }
            case 2: {
                return LocalMediaLoader.getSelectionArgsForSingleMediaType(3);
            }
            case 3: {
                return LocalMediaLoader.getSelectionArgsForSingleMediaType(2);
            }
        }
        return null;
    }

    private LocalMediaFolder getImageFolder(String firstPath, String firstMimeType, String folderName, List<LocalMediaFolder> imageFolders) {
        if (!this.config.isFallbackVersion) {
            for (LocalMediaFolder folder : imageFolders) {
                String name = folder.getName();
                if (TextUtils.isEmpty((CharSequence)name) || !name.equals(folderName)) continue;
                return folder;
            }
            LocalMediaFolder newFolder = new LocalMediaFolder();
            newFolder.setName(folderName);
            newFolder.setFirstImagePath(firstPath);
            newFolder.setFirstMimeType(firstMimeType);
            imageFolders.add(newFolder);
            return newFolder;
        }
        File imageFile = new File(firstPath);
        File folderFile = imageFile.getParentFile();
        for (LocalMediaFolder folder : imageFolders) {
            String name = folder.getName();
            if (TextUtils.isEmpty((CharSequence)name) || folderFile == null || !name.equals(folderFile.getName())) continue;
            return folder;
        }
        LocalMediaFolder newFolder = new LocalMediaFolder();
        newFolder.setName(folderFile != null ? folderFile.getName() : "");
        newFolder.setFirstImagePath(firstPath);
        newFolder.setFirstMimeType(firstMimeType);
        imageFolders.add(newFolder);
        return newFolder;
    }

    private String getDurationCondition() {
        long maxS = this.config.videoMaxSecond == 0 ? Long.MAX_VALUE : (long)this.config.videoMaxSecond;
        return String.format(Locale.CHINA, "%d <%s duration and duration <= %d", Math.max(0L, (long)this.config.videoMinSecond), Math.max(0L, (long)this.config.videoMinSecond) == 0L ? "" : "=", maxS);
    }

    private String getFileSizeCondition() {
        long maxS = this.config.filterMaxFileSize == 0L ? Long.MAX_VALUE : this.config.filterMaxFileSize;
        return String.format(Locale.CHINA, "%d <%s _size and _size <= %d", Math.max(0L, this.config.filterMinFileSize), Math.max(0L, this.config.filterMinFileSize) == 0L ? "" : "=", maxS);
    }

    private String getQueryMimeCondition() {
        HashSet<String> stringHashSet = this.config.queryMimeTypeHashSet;
        if (stringHashSet == null) {
            stringHashSet = new HashSet();
        }
        if (!TextUtils.isEmpty((CharSequence)this.config.specifiedFormat)) {
            stringHashSet.add(this.config.specifiedFormat);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = stringHashSet.iterator();
        int index = -1;
        while (iterator.hasNext()) {
            String value = iterator.next();
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            if (this.config.chooseMode == PictureMimeType.ofVideo()) {
                if (value.startsWith("image") || value.startsWith("audio")) {
                    continue;
                }
            } else if (this.config.chooseMode != PictureMimeType.ofImage() ? this.config.chooseMode == PictureMimeType.ofAudio() && (value.startsWith("video") || value.startsWith("image")) : value.startsWith("audio") || value.startsWith("video")) continue;
            stringBuilder.append(++index == 0 ? " AND " : " OR ").append("mime_type").append("='").append(value).append("'");
        }
        if (this.config.chooseMode != PictureMimeType.ofVideo() && !this.config.isGif && !stringHashSet.contains(PictureMimeType.ofGIF())) {
            stringBuilder.append(NOT_GIF);
        }
        return stringBuilder.toString();
    }
}

