/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.tools.ValueOf;
import java.io.File;

public class CameraFileUtils {
    public static Uri createCameraOutImageUri(Context context, PictureSelectionConfig config) {
        Uri imageUri;
        String cameraFileName;
        config.cameraMimeType = PictureMimeType.ofImage();
        if (TextUtils.isEmpty((CharSequence)config.cameraFileName)) {
            cameraFileName = "";
        } else {
            boolean isSuffixOfImage = PictureMimeType.isSuffixOfImage(config.cameraFileName);
            config.cameraFileName = !isSuffixOfImage ? StringUtils.renameSuffix(config.cameraFileName, ".jpg") : config.cameraFileName;
            String string2 = cameraFileName = config.camera ? config.cameraFileName : StringUtils.rename(config.cameraFileName);
        }
        if (SdkVersionUtils.isQ() && TextUtils.isEmpty((CharSequence)config.outPutCameraPath)) {
            imageUri = CameraFileUtils.createImageUri(context, cameraFileName, config.cameraImageFormatForQ);
            config.cameraPath = imageUri != null ? imageUri.toString() : null;
        } else {
            File cameraFile = PictureFileUtils.createCameraFile(context, 1, cameraFileName, config.cameraImageFormat, config.outPutCameraPath);
            config.cameraPath = cameraFile.getAbsolutePath();
            imageUri = PictureFileUtils.parUri(context, cameraFile);
        }
        return imageUri;
    }

    public static Uri createCameraOutVideoUri(Context context, PictureSelectionConfig config) {
        Uri videoUri;
        String cameraFileName;
        config.cameraMimeType = PictureMimeType.ofVideo();
        if (TextUtils.isEmpty((CharSequence)config.cameraFileName)) {
            cameraFileName = "";
        } else {
            boolean isSuffixOfImage = PictureMimeType.isSuffixOfImage(config.cameraFileName);
            config.cameraFileName = isSuffixOfImage ? StringUtils.renameSuffix(config.cameraFileName, ".mp4") : config.cameraFileName;
            String string2 = cameraFileName = config.camera ? config.cameraFileName : StringUtils.rename(config.cameraFileName);
        }
        if (SdkVersionUtils.isQ() && TextUtils.isEmpty((CharSequence)config.outPutCameraPath)) {
            videoUri = CameraFileUtils.createVideoUri(context, cameraFileName, config.cameraVideoFormatForQ);
            config.cameraPath = videoUri != null ? videoUri.toString() : "";
        } else {
            File cameraFile = PictureFileUtils.createCameraFile(context, 2, cameraFileName, config.cameraVideoFormat, config.outPutCameraPath);
            config.cameraPath = cameraFile.getAbsolutePath();
            videoUri = PictureFileUtils.parUri(context, cameraFile);
        }
        return videoUri;
    }

    public static Uri createCameraOutAudioUri(Context context, PictureSelectionConfig config) {
        Uri audioUri = null;
        config.cameraMimeType = PictureMimeType.ofAudio();
        if (SdkVersionUtils.isQ()) {
            audioUri = CameraFileUtils.createAudioUri(context, config.cameraAudioFormatForQ);
            config.cameraPath = audioUri != null ? audioUri.toString() : null;
        }
        return audioUri;
    }

    public static Uri createImageUri(Context ctx, String cameraFileName, String mimeType) {
        Context context = ctx.getApplicationContext();
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        ContentValues contentValues = CameraFileUtils.buildImageContentValues(cameraFileName, mimeType);
        imageFilePath[0] = status.equals("mounted") ? context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues) : context.getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, contentValues);
        return imageFilePath[0];
    }

    public static ContentValues buildImageContentValues(String cameraFileName, String mimeType) {
        String time = ValueOf.toString(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        if (TextUtils.isEmpty((CharSequence)cameraFileName)) {
            values.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        } else if (cameraFileName.lastIndexOf(".") == -1) {
            values.put("_display_name", DateUtils.getCreateFileName("IMG_"));
        } else {
            String suffix = cameraFileName.substring(cameraFileName.lastIndexOf("."));
            String fileName = cameraFileName.replaceAll(suffix, "");
            values.put("_display_name", fileName);
        }
        values.put("mime_type", TextUtils.isEmpty((CharSequence)mimeType) || mimeType.startsWith("video") ? "image/jpeg" : mimeType);
        if (SdkVersionUtils.isQ()) {
            values.put("datetaken", time);
            values.put("relative_path", "DCIM/Camera");
        }
        return values;
    }

    public static Uri createVideoUri(Context ctx, String cameraFileName, String mimeType) {
        Context context = ctx.getApplicationContext();
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        ContentValues contentValues = CameraFileUtils.buildVideoContentValues(cameraFileName, mimeType);
        imageFilePath[0] = status.equals("mounted") ? context.getContentResolver().insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, contentValues) : context.getContentResolver().insert(MediaStore.Video.Media.INTERNAL_CONTENT_URI, contentValues);
        return imageFilePath[0];
    }

    public static ContentValues buildVideoContentValues(String cameraFileName, String mimeType) {
        String time = ValueOf.toString(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        if (TextUtils.isEmpty((CharSequence)cameraFileName)) {
            values.put("_display_name", DateUtils.getCreateFileName("VID_"));
        } else if (cameraFileName.lastIndexOf(".") == -1) {
            values.put("_display_name", DateUtils.getCreateFileName("VID_"));
        } else {
            String suffix = cameraFileName.substring(cameraFileName.lastIndexOf("."));
            String fileName = cameraFileName.replaceAll(suffix, "");
            values.put("_display_name", fileName);
        }
        values.put("mime_type", TextUtils.isEmpty((CharSequence)mimeType) || mimeType.startsWith("image") ? "video/mp4" : mimeType);
        if (SdkVersionUtils.isQ()) {
            values.put("datetaken", time);
            values.put("relative_path", Environment.DIRECTORY_MOVIES);
        }
        return values;
    }

    public static Uri createAudioUri(Context ctx, String mimeType) {
        Context context = ctx.getApplicationContext();
        Uri[] imageFilePath = new Uri[]{null};
        String status = Environment.getExternalStorageState();
        String time = ValueOf.toString(System.currentTimeMillis());
        ContentValues values = new ContentValues(3);
        values.put("_display_name", DateUtils.getCreateFileName("AUD_"));
        if (Build.VERSION.SDK_INT >= 29) {
            values.put("datetaken", time);
        }
        values.put("mime_type", TextUtils.isEmpty((CharSequence)mimeType) || mimeType.startsWith("image") || mimeType.startsWith("video") ? "audio/amr" : mimeType);
        if (status.equals("mounted")) {
            if (Build.VERSION.SDK_INT >= 29) {
                values.put("relative_path", Environment.DIRECTORY_MUSIC);
            }
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, values);
        } else {
            imageFilePath[0] = context.getContentResolver().insert(MediaStore.Audio.Media.INTERNAL_CONTENT_URI, values);
        }
        return imageFilePath[0];
    }
}

