/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop;

import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.animation.AccelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import androidx.transition.AutoTransition;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.immersive.ImmersiveManage;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import com.yalantis.ucrop.PictureMultiCuttingActivity;
import com.yalantis.ucrop.callback.BitmapCropCallback;
import com.yalantis.ucrop.model.AspectRatio;
import com.yalantis.ucrop.util.SelectedStateListDrawable;
import com.yalantis.ucrop.view.GestureCropImageView;
import com.yalantis.ucrop.view.OverlayView;
import com.yalantis.ucrop.view.TransformImageView;
import com.yalantis.ucrop.view.UCropView;
import com.yalantis.ucrop.view.widget.AspectRatioTextView;
import com.yalantis.ucrop.view.widget.HorizontalProgressWheelView;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class UCropActivity
extends AppCompatActivity {
    public static final int DEFAULT_COMPRESS_QUALITY = 90;
    public static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.JPEG;
    public static final int NONE = 0;
    public static final int SCALE = 1;
    public static final int ROTATE = 2;
    public static final int ALL = 3;
    private static final String TAG = "UCropActivity";
    private static final long CONTROLS_ANIMATION_DURATION = 50L;
    private static final int TABS_COUNT = 3;
    private static final int SCALE_WIDGET_SENSITIVITY_COEFFICIENT = 15000;
    private static final int ROTATE_WIDGET_SENSITIVITY_COEFFICIENT = 42;
    private String mToolbarTitle;
    protected int mScreenWidth;
    private int mToolbarColor;
    private int mStatusBarColor;
    private int mActiveWidgetColor;
    private int mActiveControlsWidgetColor;
    private int mToolbarWidgetColor;
    @ColorInt
    private int mRootViewBackgroundColor;
    @DrawableRes
    private int mToolbarCancelDrawable;
    @DrawableRes
    private int mToolbarCropDrawable;
    private int mLogoColor;
    protected boolean mShowBottomControls;
    private boolean mShowLoader = true;
    protected RelativeLayout uCropPhotoBox;
    private UCropView mUCropView;
    private GestureCropImageView mGestureCropImageView;
    private OverlayView mOverlayView;
    private ViewGroup mWrapperStateAspectRatio;
    private ViewGroup mWrapperStateRotate;
    private ViewGroup mWrapperStateScale;
    private ViewGroup mLayoutAspectRatio;
    private ViewGroup mLayoutRotate;
    private ViewGroup mLayoutScale;
    private List<ViewGroup> mCropAspectRatioViews = new ArrayList<ViewGroup>();
    private List<AspectRatioTextView> mAspectRatioTextViews = new ArrayList<AspectRatioTextView>();
    private TextView mTextViewRotateAngle;
    private TextView mTextViewScalePercent;
    protected View mBlockingView;
    private Transition mControlsTransition;
    private Bitmap.CompressFormat mCompressFormat = DEFAULT_COMPRESS_FORMAT;
    private int mCompressQuality = 90;
    private int[] mAllowedGestures = new int[]{1, 2, 3};
    private boolean isDragFrame;
    private boolean isScaleEnabled;
    private boolean isRotateEnabled;
    private boolean isOpenWhiteStatusBar;
    private TransformImageView.TransformImageListener mImageListener = new TransformImageView.TransformImageListener(){

        @Override
        public void onRotate(float currentAngle) {
            UCropActivity.this.setAngleText(currentAngle);
        }

        @Override
        public void onScale(float currentScale) {
            UCropActivity.this.setScaleText(currentScale);
        }

        @Override
        public void onLoadComplete() {
            UCropActivity.this.mUCropView.animate().alpha(1.0f).setDuration(300L).setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            UCropActivity.this.mBlockingView.setClickable(!UCropActivity.this.isOnTouch());
            UCropActivity.this.mShowLoader = false;
            UCropActivity.this.supportInvalidateOptionsMenu();
        }

        @Override
        public void onLoadFailure(@NonNull Exception e) {
            UCropActivity.this.setResultError(e);
            UCropActivity.this.onBackPressed();
        }
    };
    private final View.OnClickListener mStateClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (!v.isSelected()) {
                UCropActivity.this.setWidgetState(v.getId());
            }
        }
    };

    public boolean isImmersive() {
        return true;
    }

    public void immersive() {
        ImmersiveManage.immersiveAboveAPI23(this, this.mStatusBarColor, this.mToolbarColor, this.isOpenWhiteStatusBar);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.setNewRequestedOrientation(intent);
        this.getCustomOptionsData(intent);
        if (this.isImmersive()) {
            this.immersive();
        }
        this.setContentView(R.layout.ucrop_activity_photobox);
        this.mScreenWidth = ScreenUtils.getScreenWidth((Context)this);
        this.setupViews(intent);
        this.setNavBar();
        this.setImageData(intent);
        this.setInitialState();
        this.addBlockingView();
    }

    protected void setNewRequestedOrientation(Intent intent) {
        int requestedOrientation = intent.getIntExtra("com.yalantis.ucrop.activityOrientation", -1);
        if (this.getRequestedOrientation() != requestedOrientation) {
            this.setRequestedOrientation(requestedOrientation);
        }
    }

    private void getCustomOptionsData(@NonNull Intent intent) {
        this.isOpenWhiteStatusBar = intent.getBooleanExtra("com.yalantis.ucrop.openWhiteStatusBar", false);
        this.mStatusBarColor = intent.getIntExtra("com.yalantis.ucrop.StatusBarColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_statusbar));
        this.mToolbarColor = intent.getIntExtra("com.yalantis.ucrop.ToolbarColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_toolbar));
        if (this.mToolbarColor == 0) {
            this.mToolbarColor = ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_toolbar);
        }
        if (this.mStatusBarColor == 0) {
            this.mStatusBarColor = ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_statusbar);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.ucrop_menu_activity, menu2);
        MenuItem menuItemLoader = menu2.findItem(R.id.menu_loader);
        Drawable menuItemLoaderIcon = menuItemLoader.getIcon();
        if (menuItemLoaderIcon != null) {
            try {
                menuItemLoaderIcon.mutate();
                ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)this.mToolbarWidgetColor, (BlendModeCompat)BlendModeCompat.SRC_ATOP);
                menuItemLoaderIcon.setColorFilter(colorFilter);
                menuItemLoader.setIcon(menuItemLoaderIcon);
            }
            catch (IllegalStateException e) {
                Log.i((String)TAG, (String)String.format("%s - %s", e.getMessage(), "\u5fc5\u9808\u6307\u5b9a\u8f38\u5165\u4ee5\u53ca\u8f38\u51fa\u7684 Uri"));
            }
            ((Animatable)menuItemLoader.getIcon()).start();
        }
        MenuItem menuItemCrop = menu2.findItem(R.id.menu_crop);
        Drawable menuItemCropIcon = ContextCompat.getDrawable((Context)this, (int)this.mToolbarCropDrawable);
        if (menuItemCropIcon != null) {
            menuItemCropIcon.mutate();
            ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)this.mToolbarWidgetColor, (BlendModeCompat)BlendModeCompat.SRC_ATOP);
            menuItemCropIcon.setColorFilter(colorFilter);
            menuItemCrop.setIcon(menuItemCropIcon);
        }
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        menu2.findItem(R.id.menu_crop).setVisible(!this.mShowLoader);
        menu2.findItem(R.id.menu_loader).setVisible(this.mShowLoader);
        return super.onPrepareOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.menu_crop) {
            this.cropAndSaveImage();
            return true;
        }
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onStop() {
        super.onStop();
        if (this.mGestureCropImageView != null) {
            this.mGestureCropImageView.cancelAllAnimations();
        }
    }

    protected void setImageData(@NonNull Intent intent) {
        Uri inputUri = (Uri)intent.getParcelableExtra("com.yalantis.ucrop.InputUri");
        Uri outputUri = (Uri)intent.getParcelableExtra("com.yalantis.ucrop.OutputUri");
        this.processOptions(intent);
        if (inputUri != null && outputUri != null) {
            try {
                boolean isOnTouch = this.isOnTouch(inputUri);
                this.mGestureCropImageView.setRotateEnabled(isOnTouch ? this.isRotateEnabled : isOnTouch);
                this.mGestureCropImageView.setScaleEnabled(isOnTouch ? this.isScaleEnabled : isOnTouch);
                int inputImageWidth = intent.getIntExtra("com.yalantis.ucrop.InputImageWidth", 0);
                int inputImageHeight = intent.getIntExtra("com.yalantis.ucrop.InputImageHeight", 0);
                this.mGestureCropImageView.setImageUri(inputUri, outputUri, inputImageWidth, inputImageHeight);
            }
            catch (Exception e) {
                this.setResultError(e);
                this.onBackPressed();
            }
        } else {
            this.setResultError(new NullPointerException("\u5728\u4f60\u7684 App \u5167\u590d\u5199\u989c\u8272\u8d44\u6e90 (ucrop_color_toolbar_widget) \u4f7f 5.0 \u4ee5\u524d\u88dd\u7f6e\u6b63\u5e38\u8fd0\u4f5c"));
            this.onBackPressed();
        }
    }

    private boolean isOnTouch() {
        Uri inputUri = (Uri)this.getIntent().getParcelableExtra("com.yalantis.ucrop.InputUri");
        if (inputUri == null) {
            return true;
        }
        return this.isOnTouch(inputUri);
    }

    private boolean isOnTouch(Uri inputUri) {
        if (inputUri == null) {
            return true;
        }
        boolean isHttp = PictureMimeType.isHasHttp(inputUri.toString());
        if (isHttp) {
            String lastImgType = PictureMimeType.getLastImgType(inputUri.toString());
            return !PictureMimeType.isGifForSuffix(lastImgType);
        }
        String mimeType = PictureMimeType.getMimeTypeFromMediaContentUri((Context)this, inputUri);
        if (mimeType.endsWith("image/*")) {
            String path = PictureFileUtils.getPath((Context)this, inputUri);
            mimeType = PictureMimeType.getImageMimeType(path);
        }
        return !PictureMimeType.isGif(mimeType);
    }

    private void processOptions(@NonNull Intent intent) {
        String compressionFormatName = intent.getStringExtra("com.yalantis.ucrop.CompressionFormatName");
        Bitmap.CompressFormat compressFormat = null;
        if (!TextUtils.isEmpty((CharSequence)compressionFormatName)) {
            compressFormat = Bitmap.CompressFormat.valueOf((String)compressionFormatName);
        }
        this.mCompressFormat = compressFormat == null ? DEFAULT_COMPRESS_FORMAT : compressFormat;
        this.mCompressQuality = intent.getIntExtra("com.yalantis.ucrop.CompressionQuality", 90);
        this.mOverlayView.setDimmedBorderColor(intent.getIntExtra("com.yalantis.ucrop.DimmedLayerBorderColor", this.getResources().getColor(R.color.ucrop_color_default_crop_frame)));
        this.isDragFrame = intent.getBooleanExtra("com.yalantis.ucrop.DragCropFrame", true);
        this.mOverlayView.setDimmedStrokeWidth(intent.getIntExtra("com.yalantis.ucrop.CircleStrokeWidth", 1));
        this.isScaleEnabled = intent.getBooleanExtra("com.yalantis.ucrop.scale", true);
        this.isRotateEnabled = intent.getBooleanExtra("com.yalantis.ucrop.rotate", true);
        int[] allowedGestures = intent.getIntArrayExtra("com.yalantis.ucrop.AllowedGestures");
        if (allowedGestures != null && allowedGestures.length == 3) {
            this.mAllowedGestures = allowedGestures;
        }
        this.mGestureCropImageView.setMaxBitmapSize(intent.getIntExtra("com.yalantis.ucrop.MaxBitmapSize", 0));
        this.mGestureCropImageView.setMaxScaleMultiplier(intent.getFloatExtra("com.yalantis.ucrop.MaxScaleMultiplier", 10.0f));
        this.mGestureCropImageView.setImageToWrapCropBoundsAnimDuration(intent.getIntExtra("com.yalantis.ucrop.ImageToCropBoundsAnimDuration", 500));
        int freeStyleCropMode = intent.getIntExtra("com.yalantis.ucrop.FreeStyleCropMode", -1);
        if (freeStyleCropMode == -1 || freeStyleCropMode > 2) {
            this.mOverlayView.setFreestyleCropEnabled(intent.getBooleanExtra("com.yalantis.ucrop.FreeStyleCrop", false));
        } else {
            this.mOverlayView.setFreestyleCropMode(freeStyleCropMode);
        }
        this.mOverlayView.setDragSmoothToCenter(intent.getBooleanExtra("com.yalantis.ucrop.DragSmoothToCenter", false));
        this.mOverlayView.setDragFrame(this.isDragFrame);
        this.mOverlayView.setDimmedColor(intent.getIntExtra("com.yalantis.ucrop.DimmedLayerColor", this.getResources().getColor(R.color.ucrop_color_default_dimmed)));
        this.mOverlayView.setCircleDimmedLayer(intent.getBooleanExtra("com.yalantis.ucrop.CircleDimmedLayer", false));
        this.mOverlayView.setShowCropFrame(intent.getBooleanExtra("com.yalantis.ucrop.ShowCropFrame", true));
        this.mOverlayView.setCropFrameColor(intent.getIntExtra("com.yalantis.ucrop.CropFrameColor", this.getResources().getColor(R.color.ucrop_color_default_crop_frame)));
        this.mOverlayView.setCropFrameStrokeWidth(intent.getIntExtra("com.yalantis.ucrop.CropFrameStrokeWidth", this.getResources().getDimensionPixelSize(R.dimen.ucrop_default_crop_frame_stoke_width)));
        this.mOverlayView.setShowCropGrid(intent.getBooleanExtra("com.yalantis.ucrop.ShowCropGrid", true));
        this.mOverlayView.setCropGridRowCount(intent.getIntExtra("com.yalantis.ucrop.CropGridRowCount", 2));
        this.mOverlayView.setCropGridColumnCount(intent.getIntExtra("com.yalantis.ucrop.CropGridColumnCount", 2));
        this.mOverlayView.setCropGridColor(intent.getIntExtra("com.yalantis.ucrop.CropGridColor", this.getResources().getColor(R.color.ucrop_color_default_crop_grid)));
        this.mOverlayView.setCropGridStrokeWidth(intent.getIntExtra("com.yalantis.ucrop.CropGridStrokeWidth", this.getResources().getDimensionPixelSize(R.dimen.ucrop_default_crop_grid_stoke_width)));
        float aspectRatioX = intent.getFloatExtra("com.yalantis.ucrop.AspectRatioX", 0.0f);
        float aspectRatioY = intent.getFloatExtra("com.yalantis.ucrop.AspectRatioY", 0.0f);
        int aspectRationSelectedByDefault = intent.getIntExtra("com.yalantis.ucrop.AspectRatioSelectedByDefault", 0);
        ArrayList aspectRatioList = intent.getParcelableArrayListExtra("com.yalantis.ucrop.AspectRatioOptions");
        if (aspectRatioX > 0.0f && aspectRatioY > 0.0f) {
            if (this.mWrapperStateAspectRatio != null) {
                this.mWrapperStateAspectRatio.setVisibility(8);
            }
            this.mGestureCropImageView.setTargetAspectRatio(aspectRatioX / aspectRatioY);
        } else if (aspectRatioList != null && aspectRationSelectedByDefault < aspectRatioList.size()) {
            this.mGestureCropImageView.setTargetAspectRatio(((AspectRatio)aspectRatioList.get(aspectRationSelectedByDefault)).getAspectRatioX() / ((AspectRatio)aspectRatioList.get(aspectRationSelectedByDefault)).getAspectRatioY());
        } else {
            this.mGestureCropImageView.setTargetAspectRatio(0.0f);
        }
        int maxSizeX = intent.getIntExtra("com.yalantis.ucrop.MaxSizeX", 0);
        int maxSizeY = intent.getIntExtra("com.yalantis.ucrop.MaxSizeY", 0);
        if (maxSizeX > 0 && maxSizeY > 0) {
            this.mGestureCropImageView.setMaxResultImageSizeX(maxSizeX);
            this.mGestureCropImageView.setMaxResultImageSizeY(maxSizeY);
        }
    }

    protected void setupViews(@NonNull Intent intent) {
        this.mStatusBarColor = intent.getIntExtra("com.yalantis.ucrop.StatusBarColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_statusbar));
        this.mToolbarColor = intent.getIntExtra("com.yalantis.ucrop.ToolbarColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_toolbar));
        this.mActiveWidgetColor = intent.getIntExtra("com.yalantis.ucrop.UcropColorWidgetActive", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_widget_background));
        this.mActiveControlsWidgetColor = intent.getIntExtra("com.yalantis.ucrop.UcropColorControlsWidgetActive", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_active_controls_color));
        this.mToolbarWidgetColor = intent.getIntExtra("com.yalantis.ucrop.UcropToolbarWidgetColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_toolbar_widget));
        this.mToolbarCancelDrawable = intent.getIntExtra("com.yalantis.ucrop.UcropToolbarCancelDrawable", R.drawable.ucrop_ic_cross);
        this.mToolbarCropDrawable = intent.getIntExtra("com.yalantis.ucrop.UcropToolbarCropDrawable", R.drawable.ucrop_ic_done);
        this.mToolbarTitle = intent.getStringExtra("com.yalantis.ucrop.UcropToolbarTitleText");
        this.mToolbarTitle = this.mToolbarTitle != null ? this.mToolbarTitle : this.getResources().getString(R.string.ucrop_label_edit_photo);
        this.mLogoColor = intent.getIntExtra("com.yalantis.ucrop.UcropLogoColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_default_logo));
        this.mShowBottomControls = !intent.getBooleanExtra("com.yalantis.ucrop.HideBottomControls", false);
        this.mRootViewBackgroundColor = intent.getIntExtra("com.yalantis.ucrop.UcropRootViewBackgroundColor", ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_crop_background));
        this.setupAppBar();
        this.initiateRootViews();
        if (this.mShowBottomControls) {
            ViewGroup viewGroup = (ViewGroup)this.findViewById(R.id.ucrop_photobox);
            ViewGroup wrapper = (ViewGroup)viewGroup.findViewById(R.id.controls_wrapper);
            wrapper.setVisibility(0);
            wrapper.setBackgroundColor(this.mRootViewBackgroundColor);
            LayoutInflater.from((Context)this).inflate(R.layout.ucrop_controls, wrapper, true);
            this.mControlsTransition = new AutoTransition();
            this.mControlsTransition.setDuration(50L);
            this.mWrapperStateAspectRatio = (ViewGroup)this.findViewById(R.id.state_aspect_ratio);
            this.mWrapperStateAspectRatio.setOnClickListener(this.mStateClickListener);
            this.mWrapperStateRotate = (ViewGroup)this.findViewById(R.id.state_rotate);
            this.mWrapperStateRotate.setOnClickListener(this.mStateClickListener);
            this.mWrapperStateScale = (ViewGroup)this.findViewById(R.id.state_scale);
            this.mWrapperStateScale.setOnClickListener(this.mStateClickListener);
            this.mLayoutAspectRatio = (ViewGroup)this.findViewById(R.id.layout_aspect_ratio);
            this.mLayoutRotate = (ViewGroup)this.findViewById(R.id.layout_rotate_wheel);
            this.mLayoutScale = (ViewGroup)this.findViewById(R.id.layout_scale_wheel);
            this.setupAspectRatioWidget(intent);
            this.setupRotateWidget();
            this.setupScaleWidget();
            this.setupStatesWrapper();
        }
    }

    private void setupAppBar() {
        this.setStatusBarColor(this.mStatusBarColor);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        toolbar.setBackgroundColor(this.mToolbarColor);
        toolbar.setTitleTextColor(this.mToolbarWidgetColor);
        TextView toolbarTitle = (TextView)toolbar.findViewById(R.id.toolbar_title);
        toolbarTitle.setTextColor(this.mToolbarWidgetColor);
        toolbarTitle.setText((CharSequence)this.mToolbarTitle);
        Drawable stateButtonDrawable = AppCompatResources.getDrawable((Context)this, (int)this.mToolbarCancelDrawable).mutate();
        ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)this.mToolbarWidgetColor, (BlendModeCompat)BlendModeCompat.SRC_ATOP);
        stateButtonDrawable.setColorFilter(colorFilter);
        toolbar.setNavigationIcon(stateButtonDrawable);
        this.setSupportActionBar(toolbar);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayShowTitleEnabled(false);
        }
    }

    private void initiateRootViews() {
        this.uCropPhotoBox = (RelativeLayout)this.findViewById(R.id.ucrop_photobox);
        this.mUCropView = (UCropView)this.findViewById(R.id.ucrop);
        this.mGestureCropImageView = this.mUCropView.getCropImageView();
        this.mOverlayView = this.mUCropView.getOverlayView();
        this.mGestureCropImageView.setTransformImageListener(this.mImageListener);
        ((ImageView)this.findViewById(R.id.image_view_logo)).setColorFilter(this.mLogoColor, PorterDuff.Mode.SRC_ATOP);
        this.findViewById(R.id.ucrop_frame).setBackgroundColor(this.mRootViewBackgroundColor);
    }

    private void setupStatesWrapper() {
        ImageView stateScaleImageView = (ImageView)this.findViewById(R.id.image_view_state_scale);
        ImageView stateRotateImageView = (ImageView)this.findViewById(R.id.image_view_state_rotate);
        ImageView stateAspectRatioImageView = (ImageView)this.findViewById(R.id.image_view_state_aspect_ratio);
        stateScaleImageView.setImageDrawable((Drawable)new SelectedStateListDrawable(stateScaleImageView.getDrawable(), this.mActiveControlsWidgetColor));
        stateRotateImageView.setImageDrawable((Drawable)new SelectedStateListDrawable(stateRotateImageView.getDrawable(), this.mActiveControlsWidgetColor));
        stateAspectRatioImageView.setImageDrawable((Drawable)new SelectedStateListDrawable(stateAspectRatioImageView.getDrawable(), this.mActiveControlsWidgetColor));
    }

    private void setNavBar() {
        int navBarColor;
        if (Build.VERSION.SDK_INT >= 21 && (navBarColor = this.getIntent().getIntExtra("com.yalantis.ucrop.navBarColor", 0)) != 0) {
            this.getWindow().setNavigationBarColor(navBarColor);
        }
    }

    @TargetApi(value=21)
    private void setStatusBarColor(@ColorInt int color2) {
        Window window;
        if (Build.VERSION.SDK_INT >= 21 && (window = this.getWindow()) != null) {
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(color2);
        }
    }

    private void setupAspectRatioWidget(@NonNull Intent intent) {
        int aspectRationSelectedByDefault = intent.getIntExtra("com.yalantis.ucrop.AspectRatioSelectedByDefault", 0);
        ArrayList<AspectRatio> aspectRatioList = intent.getParcelableArrayListExtra("com.yalantis.ucrop.AspectRatioOptions");
        if (aspectRatioList == null || aspectRatioList.isEmpty()) {
            aspectRationSelectedByDefault = 2;
            aspectRatioList = new ArrayList<AspectRatio>();
            aspectRatioList.add(new AspectRatio(null, 1.0f, 1.0f));
            aspectRatioList.add(new AspectRatio(null, 3.0f, 4.0f));
            aspectRatioList.add(new AspectRatio(this.getString(R.string.ucrop_label_original).toUpperCase(), 0.0f, 0.0f));
            aspectRatioList.add(new AspectRatio(null, 3.0f, 2.0f));
            aspectRatioList.add(new AspectRatio(null, 16.0f, 9.0f));
        }
        LinearLayout wrapperAspectRatioList = (LinearLayout)this.findViewById(R.id.layout_aspect_ratio);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -1);
        lp.weight = 1.0f;
        if (this.getCurrentActivity() instanceof PictureMultiCuttingActivity) {
            this.mAspectRatioTextViews = new ArrayList<AspectRatioTextView>();
            this.mCropAspectRatioViews = new ArrayList<ViewGroup>();
        }
        for (AspectRatio aspectRatio : aspectRatioList) {
            FrameLayout wrapperAspectRatio = (FrameLayout)this.getLayoutInflater().inflate(R.layout.ucrop_aspect_ratio, null);
            wrapperAspectRatio.setLayoutParams((ViewGroup.LayoutParams)lp);
            AspectRatioTextView aspectRatioTextView = (AspectRatioTextView)wrapperAspectRatio.getChildAt(0);
            aspectRatioTextView.setActiveColor(this.mActiveControlsWidgetColor);
            aspectRatioTextView.setAspectRatio(aspectRatio);
            this.mAspectRatioTextViews.add(aspectRatioTextView);
            wrapperAspectRatioList.addView((View)wrapperAspectRatio);
            this.mCropAspectRatioViews.add((ViewGroup)wrapperAspectRatio);
        }
        this.mCropAspectRatioViews.get(aspectRationSelectedByDefault).setSelected(true);
        int index = -1;
        for (ViewGroup cropAspectRatioView : this.mCropAspectRatioViews) {
            cropAspectRatioView.setTag((Object)(++index));
            cropAspectRatioView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    UCropActivity.this.mGestureCropImageView.setTargetAspectRatio(((AspectRatioTextView)((ViewGroup)v).getChildAt(0)).getAspectRatio(v.isSelected()));
                    UCropActivity.this.mGestureCropImageView.setImageToWrapCropBounds();
                    if (!v.isSelected()) {
                        Iterator iterator = UCropActivity.this.mCropAspectRatioViews.iterator();
                        while (iterator.hasNext()) {
                            ViewGroup cropAspectRatioView;
                            cropAspectRatioView.setSelected((cropAspectRatioView = (ViewGroup)iterator.next()) == v);
                        }
                    }
                }
            });
        }
    }

    private void setupRotateWidget() {
        this.mTextViewRotateAngle = (TextView)this.findViewById(R.id.text_view_rotate);
        ((HorizontalProgressWheelView)this.findViewById(R.id.rotate_scroll_wheel)).setScrollingListener(new HorizontalProgressWheelView.ScrollingListener(){

            @Override
            public void onScroll(float delta, float totalDistance) {
                UCropActivity.this.mGestureCropImageView.postRotate(delta / 42.0f);
            }

            @Override
            public void onScrollEnd() {
                UCropActivity.this.mGestureCropImageView.setImageToWrapCropBounds();
            }

            @Override
            public void onScrollStart() {
                UCropActivity.this.mGestureCropImageView.cancelAllAnimations();
            }
        });
        ((HorizontalProgressWheelView)this.findViewById(R.id.rotate_scroll_wheel)).setMiddleLineColor(this.mActiveWidgetColor);
        this.findViewById(R.id.wrapper_reset_rotate).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UCropActivity.this.resetRotation();
            }
        });
        this.findViewById(R.id.wrapper_rotate_by_angle).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UCropActivity.this.rotateByAngle(90);
            }
        });
    }

    private void setupScaleWidget() {
        this.mTextViewScalePercent = (TextView)this.findViewById(R.id.text_view_scale);
        ((HorizontalProgressWheelView)this.findViewById(R.id.scale_scroll_wheel)).setScrollingListener(new HorizontalProgressWheelView.ScrollingListener(){

            @Override
            public void onScroll(float delta, float totalDistance) {
                if (delta > 0.0f) {
                    UCropActivity.this.mGestureCropImageView.zoomInImage(UCropActivity.this.mGestureCropImageView.getCurrentScale() + delta * ((UCropActivity.this.mGestureCropImageView.getMaxScale() - UCropActivity.this.mGestureCropImageView.getMinScale()) / 15000.0f));
                } else {
                    UCropActivity.this.mGestureCropImageView.zoomOutImage(UCropActivity.this.mGestureCropImageView.getCurrentScale() + delta * ((UCropActivity.this.mGestureCropImageView.getMaxScale() - UCropActivity.this.mGestureCropImageView.getMinScale()) / 15000.0f));
                }
            }

            @Override
            public void onScrollEnd() {
                UCropActivity.this.mGestureCropImageView.setImageToWrapCropBounds();
            }

            @Override
            public void onScrollStart() {
                UCropActivity.this.mGestureCropImageView.cancelAllAnimations();
            }
        });
        ((HorizontalProgressWheelView)this.findViewById(R.id.scale_scroll_wheel)).setMiddleLineColor(this.mActiveWidgetColor);
    }

    private void setAngleText(float angle) {
        if (this.mTextViewRotateAngle != null) {
            this.mTextViewRotateAngle.setText((CharSequence)String.format(Locale.getDefault(), "%.1f\u00b0", Float.valueOf(angle)));
        }
    }

    private void setScaleText(float scale) {
        if (this.mTextViewScalePercent != null) {
            this.mTextViewScalePercent.setText((CharSequence)String.format(Locale.getDefault(), "%d%%", (int)(scale * 100.0f)));
        }
    }

    private void resetRotation() {
        this.mGestureCropImageView.postRotate(-this.mGestureCropImageView.getCurrentAngle());
        this.mGestureCropImageView.setImageToWrapCropBounds();
    }

    private void rotateByAngle(int angle) {
        this.mGestureCropImageView.postRotate(angle);
        this.mGestureCropImageView.setImageToWrapCropBounds();
    }

    protected void setInitialState() {
        if (this.mShowBottomControls) {
            if (this.mWrapperStateAspectRatio.getVisibility() == 0) {
                this.setWidgetState(R.id.state_aspect_ratio);
            } else {
                this.setWidgetState(R.id.state_scale);
            }
        } else {
            this.setAllowedGestures(0);
        }
    }

    private void setWidgetState(@IdRes int stateViewId) {
        if (!this.mShowBottomControls) {
            return;
        }
        this.mWrapperStateAspectRatio.setSelected(stateViewId == R.id.state_aspect_ratio);
        this.mWrapperStateRotate.setSelected(stateViewId == R.id.state_rotate);
        this.mWrapperStateScale.setSelected(stateViewId == R.id.state_scale);
        this.mLayoutAspectRatio.setVisibility(stateViewId == R.id.state_aspect_ratio ? 0 : 8);
        this.mLayoutRotate.setVisibility(stateViewId == R.id.state_rotate ? 0 : 8);
        this.mLayoutScale.setVisibility(stateViewId == R.id.state_scale ? 0 : 8);
        this.changeSelectedTab(stateViewId);
        if (stateViewId == R.id.state_scale) {
            this.setAllowedGestures(0);
        } else if (stateViewId == R.id.state_rotate) {
            this.setAllowedGestures(1);
        } else {
            this.setAllowedGestures(2);
        }
    }

    private void changeSelectedTab(int stateViewId) {
        TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)this.findViewById(R.id.ucrop_photobox)), (Transition)this.mControlsTransition);
        this.mWrapperStateScale.findViewById(R.id.text_view_scale).setVisibility(stateViewId == R.id.state_scale ? 0 : 8);
        this.mWrapperStateAspectRatio.findViewById(R.id.text_view_crop).setVisibility(stateViewId == R.id.state_aspect_ratio ? 0 : 8);
        this.mWrapperStateRotate.findViewById(R.id.text_view_rotate).setVisibility(stateViewId == R.id.state_rotate ? 0 : 8);
    }

    private void setAllowedGestures(int tab) {
        if (this.isOnTouch()) {
            this.mGestureCropImageView.setScaleEnabled(this.isScaleEnabled && this.mShowBottomControls ? this.mAllowedGestures[tab] == 3 || this.mAllowedGestures[tab] == 1 : this.isScaleEnabled);
            this.mGestureCropImageView.setRotateEnabled(this.isRotateEnabled && this.mShowBottomControls ? this.mAllowedGestures[tab] == 3 || this.mAllowedGestures[tab] == 2 : this.isRotateEnabled);
        }
    }

    protected void addBlockingView() {
        if (this.mBlockingView == null) {
            this.mBlockingView = new View((Context)this);
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
            lp.addRule(3, R.id.toolbar);
            this.mBlockingView.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.mBlockingView.setClickable(true);
        }
        ((RelativeLayout)this.findViewById(R.id.ucrop_photobox)).addView(this.mBlockingView);
    }

    protected void cropAndSaveImage() {
        this.mBlockingView.setClickable(true);
        this.mShowLoader = true;
        this.supportInvalidateOptionsMenu();
        this.mGestureCropImageView.cropAndSaveImage(this.mCompressFormat, this.mCompressQuality, new BitmapCropCallback(){

            @Override
            public void onBitmapCropped(@NonNull Uri resultUri, int offsetX, int offsetY, int imageWidth, int imageHeight) {
                UCropActivity.this.setResultUri(resultUri, UCropActivity.this.mGestureCropImageView.getTargetAspectRatio(), offsetX, offsetY, imageWidth, imageHeight);
                Activity currentActivity = UCropActivity.this.getCurrentActivity();
                if (!(currentActivity instanceof PictureMultiCuttingActivity)) {
                    UCropActivity.this.onBackPressed();
                }
            }

            @Override
            public void onCropFailure(@NonNull Throwable t) {
                UCropActivity.this.setResultError(t);
                UCropActivity.this.onBackPressed();
            }
        });
    }

    protected void setResultUri(Uri uri, float resultAspectRatio, int offsetX, int offsetY, int imageWidth, int imageHeight) {
        this.setResult(-1, new Intent().putExtra("com.yalantis.ucrop.OutputUri", (Parcelable)uri).putExtra("com.yalantis.ucrop.CropAspectRatio", resultAspectRatio).putExtra("com.yalantis.ucrop.ImageWidth", imageWidth).putExtra("com.yalantis.ucrop.ImageHeight", imageHeight).putExtra("com.yalantis.ucrop.OffsetX", offsetX).putExtra("com.yalantis.ucrop.OffsetY", offsetY).putExtra("com.yalantis.ucrop.EditorImage", this.getIntent().getBooleanExtra("com.yalantis.ucrop.EditorImage", false)));
    }

    protected void setResultError(Throwable throwable) {
        this.setResult(96, new Intent().putExtra("com.yalantis.ucrop.Error", (Serializable)throwable));
    }

    protected Activity getCurrentActivity() {
        return this;
    }

    public void onBackPressed() {
        this.closeActivity();
    }

    protected void closeActivity() {
        this.finish();
        this.exitAnimation();
    }

    protected void exitAnimation() {
        int exitAnimation = this.getIntent().getIntExtra("com.yalantis.ucrop.WindowAnimation", 0);
        this.overridePendingTransition(R.anim.ucrop_anim_fade_in, exitAnimation != 0 ? exitAnimation : R.anim.ucrop_close);
    }

    static {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GestureTypes {
    }
}

