/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.luck.picture.lib.R;
import com.luck.picture.lib.basic.PictureCommonFragment;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.utils.ActivityCompatHelper;

public class PictureOnlyCameraFragment
extends PictureCommonFragment {
    public static final String TAG = PictureOnlyCameraFragment.class.getSimpleName();

    public static PictureOnlyCameraFragment newInstance() {
        return new PictureOnlyCameraFragment();
    }

    @Override
    public int getResourceId() {
        return R.layout.ps_empty;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.openSelectedCamera();
    }

    @Override
    public void dispatchCameraMediaResult(LocalMedia media) {
        SelectedManager.getSelectedResult().add(media);
        this.dispatchTransformResult();
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == 0 && requestCode == 909 && !ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            this.getActivity().getSupportFragmentManager().popBackStack();
        }
    }

    @Override
    public void handlePermissionSettingResult() {
        if (PermissionChecker.isCheckCamera(this.getContext())) {
            this.openSelectedCamera();
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getString(R.string.ps_camera), (int)1).show();
            if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
                this.getActivity().getSupportFragmentManager().popBackStack();
            }
        }
    }
}

