/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.luck.picture.lib.PictureSelectorPreviewFragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureImageGridAdapter;
import com.luck.picture.lib.animators.AlphaInAnimationAdapter;
import com.luck.picture.lib.animators.SlideInBottomAnimationAdapter;
import com.luck.picture.lib.basic.FragmentInjectManager;
import com.luck.picture.lib.basic.IPictureSelectorEvent;
import com.luck.picture.lib.basic.PictureCommonFragment;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.dialog.AlbumListPopWindow;
import com.luck.picture.lib.dialog.AudioPlayDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.interfaces.OnAlbumItemClickListener;
import com.luck.picture.lib.interfaces.OnCallbackListener;
import com.luck.picture.lib.interfaces.OnQueryAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryAllAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryDataResultListener;
import com.luck.picture.lib.interfaces.OnRecyclerViewPreloadMoreListener;
import com.luck.picture.lib.loader.LocalMediaLoader;
import com.luck.picture.lib.loader.LocalMediaPageLoader;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.permissions.PermissionConfig;
import com.luck.picture.lib.permissions.PermissionResultCallback;
import com.luck.picture.lib.style.PictureSelectorStyle;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.utils.ActivityCompatHelper;
import com.luck.picture.lib.utils.AnimUtils;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.DoubleUtils;
import com.luck.picture.lib.utils.ValueOf;
import com.luck.picture.lib.widget.BottomNavBar;
import com.luck.picture.lib.widget.CompleteSelectView;
import com.luck.picture.lib.widget.RecyclerPreloadView;
import com.luck.picture.lib.widget.TitleBar;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PictureSelectorFragment
extends PictureCommonFragment
implements OnRecyclerViewPreloadMoreListener,
IPictureSelectorEvent {
    public static final String TAG = PictureSelectorFragment.class.getSimpleName();
    private RecyclerPreloadView mRecycler;
    private TextView tvDataEmpty;
    private TitleBar titleBar;
    private BottomNavBar bottomNarBar;
    private CompleteSelectView completeSelectView;
    private int openCameraNumber;
    private int allFolderSize;
    private int currentPosition = -1;
    private boolean isDisplayCamera;
    private PictureImageGridAdapter mAdapter;
    private AlbumListPopWindow albumListPopWindow;

    public static PictureSelectorFragment newInstance() {
        PictureSelectorFragment fragment = new PictureSelectorFragment();
        fragment.setArguments(new Bundle());
        return fragment;
    }

    @Override
    public int getResourceId() {
        return R.layout.ps_fragment_selector;
    }

    @Override
    @SuppressLint(value={"NotifyDataSetChanged"})
    public void onSelectedChange(boolean isAddRemove, LocalMedia currentMedia) {
        this.bottomNarBar.setSelectedChange();
        this.completeSelectView.setSelectedChange(false);
        if (this.checkNotifyStrategy(isAddRemove)) {
            this.mAdapter.notifyDataSetChanged();
        } else {
            this.mAdapter.notifyItemPositionChanged(currentMedia.position);
        }
        if (!isAddRemove) {
            this.subSelectPosition(true);
        }
    }

    @Override
    public void onLastSingleSelectedChange(LocalMedia oldLocalMedia) {
        this.mAdapter.notifyItemPositionChanged(oldLocalMedia.position);
    }

    @Override
    public void subSelectPosition(boolean isRefreshAdapter) {
        if (PictureSelectionConfig.selectorStyle.getSelectMainStyle().isSelectNumberStyle()) {
            for (int index = 0; index < SelectedManager.getCount(); ++index) {
                LocalMedia media = SelectedManager.getSelectedResult().get(index);
                media.setNum(index + 1);
                if (!isRefreshAdapter) continue;
                this.mAdapter.notifyItemPositionChanged(media.position);
            }
        }
    }

    @Override
    public void onCheckOriginalChange() {
        this.bottomNarBar.setOriginalCheck();
    }

    private boolean checkNotifyStrategy(boolean isAddRemove) {
        boolean isNotifyAll = false;
        if (this.config.isMaxSelectEnabledMask && this.config.selectionMode == 2) {
            isNotifyAll = this.config.isWithVideoImage ? SelectedManager.getCount() == this.config.maxSelectNum || !isAddRemove && SelectedManager.getCount() == this.config.maxSelectNum - 1 : (SelectedManager.getCount() == 0 || isAddRemove && SelectedManager.getCount() == 1 ? true : (PictureMimeType.isHasVideo(SelectedManager.getTopResultMimeType()) ? SelectedManager.getCount() == this.config.maxVideoSelectNum || !isAddRemove && SelectedManager.getCount() == this.config.maxVideoSelectNum - 1 : SelectedManager.getCount() == this.config.maxSelectNum || !isAddRemove && SelectedManager.getCount() == this.config.maxSelectNum - 1));
        }
        return isNotifyAll;
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("com.luck.picture.lib.all_folder_size", this.allFolderSize);
        outState.putInt("com.luck.picture.lib.current_page", this.mPage);
        outState.putInt("com.luck.picture.lib.current_preview_position", this.mRecycler.getLastVisiblePosition());
        outState.putBoolean("com.luck.picture.lib.display_camera", this.mAdapter.isDisplayCamera());
        outState.putString("com.luck.picture.lib.current_first_path", this.getFirstImagePath());
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState != null) {
            this.allFolderSize = savedInstanceState.getInt("com.luck.picture.lib.all_folder_size");
            this.mPage = savedInstanceState.getInt("com.luck.picture.lib.current_page", this.mPage);
            this.currentPosition = savedInstanceState.getInt("com.luck.picture.lib.current_preview_position", this.currentPosition);
            this.isDisplayCamera = savedInstanceState.getBoolean("com.luck.picture.lib.display_camera", this.config.isDisplayCamera);
        } else {
            this.isDisplayCamera = this.config.isDisplayCamera;
        }
        this.tvDataEmpty = (TextView)view.findViewById(R.id.tv_data_empty);
        this.completeSelectView = (CompleteSelectView)view.findViewById(R.id.ps_complete_select);
        this.titleBar = (TitleBar)view.findViewById(R.id.title_bar);
        this.bottomNarBar = (BottomNavBar)view.findViewById(R.id.bottom_nar_bar);
        this.initLoader();
        this.initAlbumListPopWindow();
        this.initTitleBar();
        this.initComplete();
        this.initRecycler(view);
        this.initBottomNavBar();
        this.requestLoadData();
    }

    private void initComplete() {
        if (this.config.selectionMode == 1 && this.config.isDirectReturnSingle) {
            PictureSelectionConfig.selectorStyle.getTitleBarStyle().setHideCancelButton(false);
            this.titleBar.getTitleCancelView().setVisibility(0);
        } else {
            this.completeSelectView.setCompleteSelectViewStyle();
            this.completeSelectView.setSelectedChange(false);
            SelectMainStyle selectMainStyle = PictureSelectionConfig.selectorStyle.getSelectMainStyle();
            if (selectMainStyle.isCompleteSelectRelativeTop()) {
                ((ConstraintLayout.LayoutParams)this.completeSelectView.getLayoutParams()).topToTop = R.id.title_bar;
                ((ConstraintLayout.LayoutParams)this.completeSelectView.getLayoutParams()).bottomToBottom = R.id.title_bar;
            }
            this.completeSelectView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PictureSelectorFragment.this.dispatchTransformResult();
                }
            });
        }
    }

    protected void initLoader() {
        this.mLoader = this.config.isPageStrategy ? new LocalMediaPageLoader(this.getContext(), this.config) : new LocalMediaLoader(this.getContext(), this.config);
    }

    private void initTitleBar() {
        if (PictureSelectionConfig.selectorStyle.getTitleBarStyle().isHideTitleBar()) {
            this.titleBar.setVisibility(8);
        }
        this.titleBar.setTitleBarStyle();
        this.titleBar.setOnTitleBarListener(new TitleBar.OnTitleBarListener(){

            @Override
            public void onBackPressed() {
                if (PictureSelectorFragment.this.albumListPopWindow.isShowing()) {
                    PictureSelectorFragment.this.albumListPopWindow.dismiss();
                } else {
                    if (ActivityCompatHelper.checkRootFragment(PictureSelectorFragment.this.getActivity()) && PictureSelectionConfig.resultCallListener != null) {
                        PictureSelectionConfig.resultCallListener.onCancel();
                    }
                    PictureCommonFragment.SelectorResult result = PictureSelectorFragment.this.getResult(0, new ArrayList());
                    if (!ActivityCompatHelper.isDestroy((Activity)PictureSelectorFragment.this.getActivity())) {
                        PictureSelectorFragment.this.getActivity().setResult(result.mResultCode, result.mResultData);
                    }
                    PictureSelectorFragment.this.iBridgePictureBehavior.onSelectFinish(false, result);
                }
            }

            @Override
            public void onShowAlbumPopWindow(View anchor) {
                PictureSelectorFragment.this.albumListPopWindow.showAsDropDown(anchor);
            }
        });
    }

    private void initAlbumListPopWindow() {
        this.albumListPopWindow = AlbumListPopWindow.buildPopWindow(this.getContext());
        this.albumListPopWindow.setOnPopupWindowStatusListener(new AlbumListPopWindow.OnPopupWindowStatusListener(){

            @Override
            public void onShowPopupWindow() {
                AnimUtils.rotateArrow(PictureSelectorFragment.this.titleBar.getImageArrow(), true);
            }

            @Override
            public void onDismissPopupWindow() {
                AnimUtils.rotateArrow(PictureSelectorFragment.this.titleBar.getImageArrow(), false);
            }
        });
        this.addAlbumPopWindowAction();
    }

    private void requestLoadData() {
        this.mAdapter.setDisplayCamera(this.isDisplayCamera);
        if (PermissionChecker.isCheckReadStorage(this.getContext())) {
            this.beginLoadData();
        } else if (PictureSelectionConfig.permissionsEventListener != null) {
            PictureSelectionConfig.permissionsEventListener.onPermission(this, PermissionConfig.READ_WRITE_EXTERNAL_STORAGE, new OnCallbackListener<Boolean>(){

                @Override
                public void onCall(Boolean isResult) {
                    if (isResult.booleanValue()) {
                        PictureSelectorFragment.this.beginLoadData();
                    } else {
                        PictureSelectorFragment.this.handlePermissionDenied(PermissionConfig.READ_WRITE_EXTERNAL_STORAGE);
                    }
                }
            });
        } else {
            PermissionChecker.getInstance().requestPermissions((Fragment)this, PermissionConfig.READ_WRITE_EXTERNAL_STORAGE, new PermissionResultCallback(){

                @Override
                public void onGranted() {
                    PictureSelectorFragment.this.beginLoadData();
                }

                @Override
                public void onDenied() {
                    PictureSelectorFragment.this.handlePermissionDenied(PermissionConfig.READ_WRITE_EXTERNAL_STORAGE);
                }
            });
        }
    }

    private void beginLoadData() {
        this.showLoading();
        if (this.config.isOnlySandboxDir) {
            this.loadOnlyInAppDirectoryAllMediaData();
        } else {
            this.loadAllAlbumData();
        }
    }

    @Override
    public void handlePermissionSettingResult() {
        if (PermissionChecker.isCheckReadStorage(this.getContext())) {
            this.beginLoadData();
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getString(R.string.ps_jurisdiction), (int)1).show();
            this.iBridgePictureBehavior.onSelectFinish(false, null);
        }
    }

    private void addAlbumPopWindowAction() {
        this.albumListPopWindow.setOnIBridgeAlbumWidget(new OnAlbumItemClickListener(){

            @Override
            public void onItemClick(int position, LocalMediaFolder curFolder) {
                PictureSelectorFragment.this.isDisplayCamera = ((PictureSelectorFragment)PictureSelectorFragment.this).config.isDisplayCamera && curFolder.getBucketId() == -1L;
                PictureSelectorFragment.this.mAdapter.setDisplayCamera(PictureSelectorFragment.this.isDisplayCamera);
                PictureSelectorFragment.this.titleBar.setTitle(curFolder.getFolderName());
                LocalMediaFolder lastFolder = SelectedManager.getCurrentLocalMediaFolder();
                long lastBucketId = lastFolder.getBucketId();
                if (((PictureSelectorFragment)PictureSelectorFragment.this).config.isPageStrategy) {
                    if (curFolder.getBucketId() != lastBucketId) {
                        lastFolder.setData(PictureSelectorFragment.this.mAdapter.getData());
                        lastFolder.setCurrentDataPage(PictureSelectorFragment.this.mPage);
                        lastFolder.setHasMore(PictureSelectorFragment.this.mRecycler.isEnabledLoadMore());
                        if (curFolder.getData().size() > 0) {
                            PictureSelectorFragment.this.setAdapterData(curFolder.getData());
                            PictureSelectorFragment.this.mPage = curFolder.getCurrentDataPage();
                            PictureSelectorFragment.this.mRecycler.setEnabledLoadMore(curFolder.isHasMore());
                            PictureSelectorFragment.this.mRecycler.smoothScrollToPosition(0);
                        } else {
                            PictureSelectorFragment.this.mPage = 1;
                            PictureSelectorFragment.this.showLoading();
                            if (PictureSelectionConfig.loaderDataEngine != null) {
                                PictureSelectionConfig.loaderDataEngine.loadFirstPageMediaData(PictureSelectorFragment.this.getContext(), curFolder.getBucketId(), PictureSelectorFragment.this.mPage, ((PictureSelectorFragment)PictureSelectorFragment.this).config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                                    @Override
                                    public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                                        PictureSelectorFragment.this.handleSwitchAlbum(result, isHasMore);
                                    }
                                });
                            } else {
                                PictureSelectorFragment.this.mLoader.loadPageMediaData(curFolder.getBucketId(), PictureSelectorFragment.this.mPage, ((PictureSelectorFragment)PictureSelectorFragment.this).config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                                    @Override
                                    public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                                        PictureSelectorFragment.this.handleSwitchAlbum(result, isHasMore);
                                    }
                                });
                            }
                        }
                    }
                } else if (curFolder.getBucketId() != lastBucketId) {
                    PictureSelectorFragment.this.setAdapterData(curFolder.getData());
                    PictureSelectorFragment.this.mRecycler.smoothScrollToPosition(0);
                }
                SelectedManager.setCurrentLocalMediaFolder(curFolder);
                PictureSelectorFragment.this.albumListPopWindow.dismiss();
            }
        });
    }

    private void handleSwitchAlbum(ArrayList<LocalMedia> result, boolean isHasMore) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        this.dismissLoading();
        this.mRecycler.setEnabledLoadMore(isHasMore);
        if (result.size() == 0) {
            this.mAdapter.getData().clear();
        }
        this.setAdapterData(result);
        this.mRecycler.onScrolled(0, 0);
        this.mRecycler.smoothScrollToPosition(0);
    }

    private void initBottomNavBar() {
        this.bottomNarBar.setSelectedChange();
        this.bottomNarBar.setBottomNavBarStyle();
        this.bottomNarBar.setOnBottomNavBarListener(new BottomNavBar.OnBottomNavBarListener(){

            @Override
            public void onPreview() {
                PictureSelectorFragment.this.onStartPreview(0, true);
            }

            @Override
            public void onCheckOriginalChange() {
                PictureSelectorFragment.this.sendSelectedOriginalChangeEvent();
            }
        });
    }

    @Override
    public void loadAllAlbumData() {
        if (PictureSelectionConfig.loaderDataEngine != null) {
            PictureSelectionConfig.loaderDataEngine.loadAllAlbumData(this.getContext(), new OnQueryAllAlbumListener<LocalMediaFolder>(){

                @Override
                public void onComplete(List<LocalMediaFolder> result) {
                    PictureSelectorFragment.this.handleAllAlbumData(result);
                }
            });
        } else {
            this.mLoader.loadAllMedia(new OnQueryAllAlbumListener<LocalMediaFolder>(){

                @Override
                public void onComplete(List<LocalMediaFolder> result) {
                    PictureSelectorFragment.this.handleAllAlbumData(result);
                }
            });
        }
    }

    private void handleAllAlbumData(List<LocalMediaFolder> result) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        if (result.size() > 0) {
            LocalMediaFolder firstFolder;
            if (SelectedManager.getCurrentLocalMediaFolder() != null) {
                firstFolder = SelectedManager.getCurrentLocalMediaFolder();
            } else {
                firstFolder = result.get(0);
                SelectedManager.setCurrentLocalMediaFolder(firstFolder);
            }
            this.titleBar.setTitle(firstFolder.getFolderName());
            this.albumListPopWindow.bindAlbumData(result);
            this.saveFirstImagePath(firstFolder.getFirstImagePath());
            if (this.config.isPageStrategy) {
                this.loadFirstPageMediaData(firstFolder.getBucketId());
            } else {
                this.dismissLoading();
                this.setAdapterData(firstFolder.getData());
            }
        } else {
            this.showDataNull();
        }
    }

    @Override
    public void loadFirstPageMediaData(long firstBucketId) {
        this.mRecycler.setEnabledLoadMore(true);
        if (PictureSelectionConfig.loaderDataEngine != null) {
            PictureSelectionConfig.loaderDataEngine.loadFirstPageMediaData(this.getContext(), firstBucketId, this.mPage, this.mPage * this.config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                @Override
                public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                    PictureSelectorFragment.this.handleFirstPageMedia(result, isHasMore);
                }
            });
        } else {
            this.mLoader.loadFirstPageMedia(firstBucketId, this.mPage * this.config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                @Override
                public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                    PictureSelectorFragment.this.handleFirstPageMedia(result, isHasMore);
                }
            });
        }
    }

    private void handleFirstPageMedia(ArrayList<LocalMedia> result, boolean isHasMore) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        this.dismissLoading();
        this.mRecycler.setEnabledLoadMore(isHasMore);
        if (this.mRecycler.isEnabledLoadMore() && result.size() == 0) {
            this.onRecyclerViewPreloadMore();
        } else {
            this.setAdapterData(result);
        }
        this.recoveryRecyclerPosition();
    }

    @Override
    public void loadOnlyInAppDirectoryAllMediaData() {
        if (PictureSelectionConfig.loaderDataEngine != null) {
            PictureSelectionConfig.loaderDataEngine.loadOnlyInAppDirAllMediaData(this.getContext(), new OnQueryAlbumListener<LocalMediaFolder>(){

                @Override
                public void onComplete(LocalMediaFolder folder) {
                    PictureSelectorFragment.this.dismissLoading();
                    PictureSelectorFragment.this.handleInAppDirAllMedia(folder);
                }
            });
        } else {
            this.mLoader.loadOnlyInAppDirAllMedia(new OnQueryAlbumListener<LocalMediaFolder>(){

                @Override
                public void onComplete(LocalMediaFolder folder) {
                    PictureSelectorFragment.this.dismissLoading();
                    PictureSelectorFragment.this.handleInAppDirAllMedia(folder);
                }
            });
        }
    }

    private void handleInAppDirAllMedia(LocalMediaFolder folder) {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            String sandboxDir = this.config.sandboxDir;
            boolean isNonNull = folder != null;
            String folderName = isNonNull ? folder.getFolderName() : new File(sandboxDir).getName();
            this.titleBar.setTitle(folderName);
            if (isNonNull) {
                SelectedManager.setCurrentLocalMediaFolder(folder);
                this.setAdapterData(folder.getData());
                this.recoveryRecyclerPosition();
            } else {
                this.showDataNull();
            }
        }
    }

    private void recoveryRecyclerPosition() {
        if (this.currentPosition > 0) {
            this.mRecycler.post(new Runnable(){

                @Override
                public void run() {
                    PictureSelectorFragment.this.mRecycler.scrollToPosition(PictureSelectorFragment.this.currentPosition);
                    PictureSelectorFragment.this.mRecycler.setLastVisiblePosition(PictureSelectorFragment.this.currentPosition);
                }
            });
        }
    }

    private void saveFirstImagePath(String firstImagePath) {
        if (this.getArguments() != null) {
            this.getArguments().putString("com.luck.picture.lib.current_first_path", firstImagePath);
        }
    }

    private String getFirstImagePath() {
        if (this.getArguments() != null) {
            return this.getArguments().getString("com.luck.picture.lib.current_first_path", "");
        }
        return "";
    }

    private void initRecycler(View view) {
        this.mRecycler = (RecyclerPreloadView)view.findViewById(R.id.recycler);
        PictureSelectorStyle selectorStyle = PictureSelectionConfig.selectorStyle;
        int listBackgroundColor = selectorStyle.getSelectMainStyle().getMainListBackgroundColor();
        if (listBackgroundColor != 0) {
            this.mRecycler.setBackgroundColor(listBackgroundColor);
        }
        int imageSpanCount = this.config.imageSpanCount <= 0 ? 4 : this.config.imageSpanCount;
        this.mRecycler.addItemDecoration(new GridSpacingItemDecoration(imageSpanCount, DensityUtil.dip2px(view.getContext(), 2.0f), true));
        this.mRecycler.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), imageSpanCount));
        RecyclerView.ItemAnimator itemAnimator = this.mRecycler.getItemAnimator();
        if (itemAnimator != null) {
            ((SimpleItemAnimator)itemAnimator).setSupportsChangeAnimations(false);
            this.mRecycler.setItemAnimator(null);
        }
        if (this.config.isPageStrategy) {
            this.mRecycler.setReachBottomRow(2);
            this.mRecycler.setOnRecyclerViewPreloadListener(this);
        } else {
            this.mRecycler.setHasFixedSize(true);
        }
        this.mAdapter = new PictureImageGridAdapter(this.config);
        this.mAdapter.setDisplayCamera(this.isDisplayCamera);
        switch (this.config.animationMode) {
            case 1: {
                this.mRecycler.setAdapter(new AlphaInAnimationAdapter(this.mAdapter));
                break;
            }
            case 2: {
                this.mRecycler.setAdapter(new SlideInBottomAnimationAdapter(this.mAdapter));
                break;
            }
            default: {
                this.mRecycler.setAdapter(this.mAdapter);
            }
        }
        this.addRecyclerAction();
    }

    private void addRecyclerAction() {
        this.mAdapter.setOnItemClickListener(new PictureImageGridAdapter.OnItemClickListener(){

            @Override
            public void openCameraClick() {
                PictureSelectorFragment.this.openSelectedCamera();
            }

            @Override
            public int onSelected(View selectedView, int position, LocalMedia media) {
                int selectResultCode = PictureSelectorFragment.this.confirmSelect(media, selectedView.isSelected());
                if (selectResultCode == 0) {
                    selectedView.startAnimation(AnimationUtils.loadAnimation((Context)PictureSelectorFragment.this.getContext(), (int)R.anim.ps_anim_modal_in));
                }
                return selectResultCode;
            }

            @Override
            public void onItemClick(View selectedView, int position, LocalMedia media) {
                if (((PictureSelectorFragment)PictureSelectorFragment.this).config.selectionMode == 1 && ((PictureSelectorFragment)PictureSelectorFragment.this).config.isDirectReturnSingle) {
                    SelectedManager.getSelectedResult().clear();
                    SelectedManager.getSelectedResult().add(media);
                    PictureSelectorFragment.this.dispatchTransformResult();
                } else {
                    boolean isPreview;
                    boolean bl = isPreview = PictureMimeType.isHasImage(media.getMimeType()) && ((PictureSelectorFragment)PictureSelectorFragment.this).config.isEnablePreview || ((PictureSelectorFragment)PictureSelectorFragment.this).config.isDirectReturnSingle || PictureMimeType.isHasVideo(media.getMimeType()) && (((PictureSelectorFragment)PictureSelectorFragment.this).config.isEnPreviewVideo || ((PictureSelectorFragment)PictureSelectorFragment.this).config.selectionMode == 1) || PictureMimeType.isHasAudio(media.getMimeType()) && (((PictureSelectorFragment)PictureSelectorFragment.this).config.isEnablePreviewAudio || ((PictureSelectorFragment)PictureSelectorFragment.this).config.selectionMode == 1);
                    if (isPreview) {
                        if (DoubleUtils.isFastDoubleClick()) {
                            return;
                        }
                        if (PictureMimeType.isHasAudio(media.getMimeType())) {
                            AudioPlayDialog.showPlayAudioDialog((Context)PictureSelectorFragment.this.getActivity(), media.getPath());
                        } else {
                            PictureSelectorFragment.this.onStartPreview(position, false);
                        }
                    } else {
                        PictureSelectorFragment.this.confirmSelect(media, selectedView.isSelected());
                    }
                }
            }
        });
    }

    private void onStartPreview(int position, boolean isBottomPreview) {
        if (ActivityCompatHelper.checkFragmentNonExits(this.getActivity(), PictureSelectorPreviewFragment.TAG)) {
            int totalNum;
            ArrayList<LocalMedia> data;
            long currentBucketId = 0L;
            if (isBottomPreview) {
                data = new ArrayList<LocalMedia>(SelectedManager.getSelectedResult());
                totalNum = data.size();
            } else {
                data = this.mAdapter.getData();
                totalNum = SelectedManager.getCurrentLocalMediaFolder().getFolderTotalNum();
                currentBucketId = SelectedManager.getCurrentLocalMediaFolder().getBucketId();
            }
            if (ActivityCompatHelper.checkFragmentNonExits(this.getActivity(), PictureSelectorPreviewFragment.TAG)) {
                PictureSelectorPreviewFragment previewFragment = PictureSelectorPreviewFragment.newInstance();
                previewFragment.setInternalPreviewData(isBottomPreview, this.titleBar.getTitleText(), this.mAdapter.isDisplayCamera(), position, totalNum, this.mPage, currentBucketId, data);
                FragmentInjectManager.injectFragment(this.getActivity(), PictureSelectorPreviewFragment.TAG, previewFragment);
            }
        }
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    private void setAdapterData(ArrayList<LocalMedia> result) {
        this.subSelectPosition(false);
        this.mAdapter.setDataAndDataSetChanged(result);
        if (this.mAdapter.isDataEmpty()) {
            this.showDataNull();
        } else {
            this.hideDataNull();
        }
    }

    @Override
    public void onRecyclerViewPreloadMore() {
        this.loadMoreMediaData();
    }

    @Override
    public void loadMoreMediaData() {
        if (this.mRecycler.isEnabledLoadMore()) {
            long bucketId;
            ++this.mPage;
            LocalMediaFolder localMediaFolder = SelectedManager.getCurrentLocalMediaFolder();
            long l = bucketId = localMediaFolder != null ? localMediaFolder.getBucketId() : 0L;
            if (PictureSelectionConfig.loaderDataEngine != null) {
                PictureSelectionConfig.loaderDataEngine.loadMoreMediaData(this.getContext(), bucketId, this.mPage, this.getPageLimit(bucketId), this.config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                    @Override
                    public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                        PictureSelectorFragment.this.handleMoreMediaData(result, isHasMore);
                    }
                });
            } else {
                this.mLoader.loadPageMediaData(bucketId, this.mPage, this.getPageLimit(bucketId), this.config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                    @Override
                    public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                        PictureSelectorFragment.this.handleMoreMediaData(result, isHasMore);
                    }
                });
            }
        }
    }

    private void handleMoreMediaData(List<LocalMedia> result, boolean isHasMore) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        this.mRecycler.setEnabledLoadMore(isHasMore);
        if (this.mRecycler.isEnabledLoadMore()) {
            if (result.size() > 0) {
                int positionStart = this.mAdapter.getData().size();
                this.mAdapter.getData().addAll(result);
                this.mAdapter.notifyItemRangeChanged(positionStart, this.mAdapter.getItemCount());
            } else {
                this.onRecyclerViewPreloadMore();
            }
            if (result.size() < 10) {
                this.mRecycler.onScrolled(this.mRecycler.getScrollX(), this.mRecycler.getScrollY());
            }
        }
    }

    @Override
    public void dispatchCameraMediaResult(LocalMedia media) {
        if (TextUtils.equals((CharSequence)media.getPath(), (CharSequence)this.getFirstImagePath())) {
            SelectedManager.getSelectedResult().add(media);
            this.saveFirstImagePath(media.getPath());
            this.mAdapter.notifyItemPositionChanged(this.config.isDisplayCamera ? 1 : 0);
            if (this.config.isDirectReturnSingle) {
                this.dispatchTransformResult();
            }
            return;
        }
        int exitsTotalNum = this.albumListPopWindow.getFirstAlbumImageCount();
        if (!this.isAddSameImp(exitsTotalNum)) {
            this.mAdapter.getData().add(0, media);
            ++this.openCameraNumber;
        }
        if (this.config.selectionMode == 1) {
            if (this.config.isDirectReturnSingle) {
                SelectedManager.getSelectedResult().clear();
                SelectedManager.getSelectedResult().add(media);
                this.dispatchTransformResult();
            } else {
                ArrayList<LocalMedia> selectedResult = SelectedManager.getSelectedResult();
                boolean mimeTypeSame = PictureMimeType.isMimeTypeSame(SelectedManager.getTopResultMimeType(), media.getMimeType());
                if ((mimeTypeSame || selectedResult.size() == 0) && selectedResult.size() > 0) {
                    LocalMedia exitsMedia = (LocalMedia)selectedResult.get(0);
                    int position = exitsMedia.getPosition();
                    selectedResult.clear();
                    this.mAdapter.notifyItemPositionChanged(position);
                }
                SelectedManager.getSelectedResult().add(media);
                this.onSelectedChange(true, media);
            }
        } else {
            this.confirmSelect(media, false);
        }
        this.mAdapter.notifyItemInserted(this.config.isDisplayCamera ? 1 : 0);
        this.mAdapter.notifyItemRangeChanged(this.config.isDisplayCamera ? 1 : 0, this.mAdapter.getData().size());
        if (this.config.isOnlySandboxDir) {
            LocalMediaFolder currentLocalMediaFolder = SelectedManager.getCurrentLocalMediaFolder();
            if (currentLocalMediaFolder == null) {
                currentLocalMediaFolder = new LocalMediaFolder();
                long bucketId = ValueOf.toLong(media.getParentFolderName().hashCode());
                currentLocalMediaFolder.setBucketId(bucketId);
                currentLocalMediaFolder.setFolderName(media.getParentFolderName());
                currentLocalMediaFolder.setFirstMimeType(media.getMimeType());
                currentLocalMediaFolder.setFirstImagePath(media.getPath());
                currentLocalMediaFolder.setFolderTotalNum(this.mAdapter.getData().size());
                currentLocalMediaFolder.setCurrentDataPage(this.mPage);
                currentLocalMediaFolder.setHasMore(false);
                this.mRecycler.setEnabledLoadMore(false);
                SelectedManager.setCurrentLocalMediaFolder(currentLocalMediaFolder);
            }
        } else {
            this.mergeFolder(media);
        }
        this.allFolderSize = 0;
        if (this.mAdapter.getData().size() > 0 || this.config.isDirectReturnSingle) {
            this.hideDataNull();
        } else {
            this.showDataNull();
        }
    }

    private void mergeFolder(LocalMedia media) {
        LocalMediaFolder allFolder;
        if (this.albumListPopWindow.getFolderCount() == 0) {
            allFolder = new LocalMediaFolder();
            String folderName = this.config.chooseMode == SelectMimeType.ofAudio() ? this.getString(R.string.ps_all_audio) : this.getString(R.string.ps_camera_roll);
            allFolder.setFolderName(folderName);
            allFolder.setFirstImagePath("");
            allFolder.setBucketId(-1L);
            this.albumListPopWindow.getAlbumList().add(0, allFolder);
        } else {
            allFolder = this.albumListPopWindow.getFolder(0);
        }
        allFolder.setFirstImagePath(media.getPath());
        allFolder.setFirstMimeType(media.getMimeType());
        allFolder.setData(this.mAdapter.getData());
        allFolder.setBucketId(-1L);
        allFolder.setFolderTotalNum(this.isAddSameImp(allFolder.getFolderTotalNum()) ? allFolder.getFolderTotalNum() : allFolder.getFolderTotalNum() + 1);
        LocalMediaFolder cameraFolder = null;
        List<LocalMediaFolder> albumList = this.albumListPopWindow.getAlbumList();
        for (int i = 0; i < albumList.size(); ++i) {
            LocalMediaFolder exitsFolder = albumList.get(i);
            if (!TextUtils.equals((CharSequence)exitsFolder.getFolderName(), (CharSequence)media.getParentFolderName())) continue;
            cameraFolder = exitsFolder;
            break;
        }
        if (cameraFolder == null) {
            cameraFolder = new LocalMediaFolder();
        }
        cameraFolder.setFolderTotalNum(this.isAddSameImp(allFolder.getFolderTotalNum()) ? cameraFolder.getFolderTotalNum() : cameraFolder.getFolderTotalNum() + 1);
        if (!this.config.isPageStrategy && !this.isAddSameImp(allFolder.getFolderTotalNum())) {
            cameraFolder.getData().add(0, media);
        }
        cameraFolder.setBucketId(media.getBucketId());
        cameraFolder.setFirstImagePath(this.config.cameraPath);
        cameraFolder.setFirstMimeType(media.getMimeType());
        this.albumListPopWindow.bindAlbumData(this.albumListPopWindow.getAlbumList());
    }

    private boolean isAddSameImp(int totalNum) {
        if (totalNum == 0) {
            return false;
        }
        return this.allFolderSize > 0 && this.allFolderSize < totalNum;
    }

    private int getPageLimit(long bucketId) {
        if (bucketId == -1L) {
            int limit = this.openCameraNumber > 0 ? this.config.pageSize - this.openCameraNumber : this.config.pageSize;
            this.openCameraNumber = 0;
            return limit;
        }
        return this.config.pageSize;
    }

    private void showDataNull() {
        if (this.tvDataEmpty.getVisibility() == 8) {
            this.tvDataEmpty.setVisibility(0);
        }
        this.tvDataEmpty.setCompoundDrawablesRelativeWithIntrinsicBounds(0, R.drawable.ps_ic_no_data, 0, 0);
        int chooseMode = this.config.chooseMode;
        String tips = chooseMode == SelectMimeType.ofAudio() ? this.getString(R.string.ps_audio_empty) : this.getString(R.string.ps_empty);
        this.tvDataEmpty.setText((CharSequence)tips);
    }

    private void hideDataNull() {
        if (this.tvDataEmpty.getVisibility() == 0) {
            this.tvDataEmpty.setVisibility(8);
        }
    }
}

