/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.BaseRecyclerMediaHolder;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.utils.DateUtils;
import com.luck.picture.lib.utils.StyleUtils;

public class VideoViewHolder
extends BaseRecyclerMediaHolder {
    private final TextView tvDuration;

    public VideoViewHolder(@NonNull View itemView, PictureSelectionConfig config) {
        super(itemView, config);
        int[] durationGravity;
        int[] durationShadowGravity;
        int shadowBackground;
        int textColor;
        int textSize;
        this.tvDuration = (TextView)itemView.findViewById(R.id.tv_duration);
        ImageView ivMask = (ImageView)itemView.findViewById(R.id.iv_mask);
        SelectMainStyle adapterStyle = PictureSelectionConfig.selectorStyle.getSelectMainStyle();
        int drawableLeft = adapterStyle.getAdapterDurationDrawableLeft();
        if (StyleUtils.checkStyleValidity(drawableLeft)) {
            this.tvDuration.setCompoundDrawablesRelativeWithIntrinsicBounds(drawableLeft, 0, 0, 0);
        }
        if (StyleUtils.checkSizeValidity(textSize = adapterStyle.getAdapterDurationTextSize())) {
            this.tvDuration.setTextSize((float)textSize);
        }
        if (StyleUtils.checkStyleValidity(textColor = adapterStyle.getAdapterDurationTextColor())) {
            this.tvDuration.setTextColor(textColor);
        }
        if (StyleUtils.checkStyleValidity(shadowBackground = adapterStyle.getAdapterDurationBackgroundResources())) {
            this.tvDuration.setBackgroundResource(shadowBackground);
        }
        if (StyleUtils.checkArrayValidity(durationShadowGravity = adapterStyle.getAdapterDurationShadowGravity()) && ivMask.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
            ((RelativeLayout.LayoutParams)ivMask.getLayoutParams()).removeRule(12);
            for (int i : durationShadowGravity) {
                ((RelativeLayout.LayoutParams)ivMask.getLayoutParams()).addRule(i);
            }
        }
        if (StyleUtils.checkArrayValidity(durationGravity = adapterStyle.getAdapterDurationGravity()) && ivMask.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
            ((RelativeLayout.LayoutParams)this.tvDuration.getLayoutParams()).removeRule(12);
            for (int i : durationGravity) {
                ((RelativeLayout.LayoutParams)this.tvDuration.getLayoutParams()).addRule(i);
            }
        }
    }

    @Override
    public void bindData(LocalMedia media, int position) {
        super.bindData(media, position);
        this.tvDuration.setText((CharSequence)DateUtils.formatDurationTime(media.getDuration()));
    }
}

