/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.basic;

import android.content.Context;
import android.os.Bundle;
import android.view.KeyEvent;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import com.luck.picture.lib.PictureSelectorFragment;
import com.luck.picture.lib.PictureSelectorPreviewFragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.basic.FragmentInjectManager;
import com.luck.picture.lib.basic.IBridgePictureBehavior;
import com.luck.picture.lib.basic.PictureCommonFragment;
import com.luck.picture.lib.basic.PictureContextWrapper;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.immersive.ImmersiveManage;
import com.luck.picture.lib.language.PictureLanguageUtils;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.style.PictureWindowAnimationStyle;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.utils.ActivityCompatHelper;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.StyleUtils;
import java.util.ArrayList;

public class PictureSelectorSupporterActivity
extends AppCompatActivity
implements IBridgePictureBehavior {
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initAppLanguage();
        this.immersive();
        this.setContentView(R.layout.ps_activity_container);
        this.setupFragment();
    }

    private void immersive() {
        SelectMainStyle mainStyle = PictureSelectionConfig.selectorStyle.getSelectMainStyle();
        int statusBarColor = mainStyle.getStatusBarColor();
        int navigationBarColor = mainStyle.getNavigationBarColor();
        boolean isDarkStatusBarBlack = mainStyle.isDarkStatusBarBlack();
        if (!StyleUtils.checkStyleValidity(statusBarColor)) {
            statusBarColor = ContextCompat.getColor((Context)this, (int)R.color.ps_color_grey);
        }
        if (!StyleUtils.checkStyleValidity(navigationBarColor)) {
            navigationBarColor = ContextCompat.getColor((Context)this, (int)R.color.ps_color_grey);
        }
        ImmersiveManage.immersiveAboveAPI23(this, statusBarColor, navigationBarColor, isDarkStatusBarBlack);
    }

    private void setupFragment() {
        if (this.getIntent().hasExtra("com.luck.picture.lib.external_preview") && this.getIntent().getBooleanExtra("com.luck.picture.lib.external_preview", false)) {
            int position = this.getIntent().getIntExtra("com.luck.picture.lib.current_preview_position", 0);
            PictureSelectorPreviewFragment fragment = PictureSelectorPreviewFragment.newInstance();
            ArrayList<LocalMedia> previewResult = SelectedManager.getSelectedPreviewResult();
            ArrayList<LocalMedia> previewData = new ArrayList<LocalMedia>(previewResult);
            PictureSelectionConfig.selectorStyle.getSelectMainStyle().setPreviewDisplaySelectGallery(false);
            boolean isDisplayDelete = this.getIntent().getBooleanExtra("com.luck.picture.lib.external_preview_display_delete", false);
            fragment.setExternalPreviewData(position, previewData.size(), previewData, isDisplayDelete);
            FragmentInjectManager.injectFragment((FragmentActivity)this, PictureSelectorPreviewFragment.TAG, fragment);
        } else {
            FragmentInjectManager.injectFragment((FragmentActivity)this, PictureSelectorFragment.TAG, PictureSelectorFragment.newInstance());
        }
    }

    public void initAppLanguage() {
        PictureSelectionConfig config = PictureSelectionConfig.getInstance();
        if (config.language != -2 && !config.isOnlyCamera) {
            PictureLanguageUtils.setAppLanguage((Context)this, config.language);
        }
    }

    @Override
    public void onSelectFinish(boolean isForcedExit, PictureCommonFragment.SelectorResult result) {
        if (isForcedExit) {
            this.exit();
        } else {
            this.onBackPressed();
        }
    }

    public void onBackPressed() {
        if (ActivityCompatHelper.checkRootFragment((FragmentActivity)this)) {
            this.exit();
        } else {
            this.getSupportFragmentManager().popBackStack();
        }
    }

    private void exit() {
        if (SdkVersionUtils.isQ()) {
            this.finishAfterTransition();
        } else {
            super.onBackPressed();
        }
        this.finish();
        PictureWindowAnimationStyle windowAnimationStyle = PictureSelectionConfig.selectorStyle.getWindowAnimationStyle();
        this.overridePendingTransition(0, windowAnimationStyle.activityExitAnimation);
        PictureSelectionConfig.destroy();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && ActivityCompatHelper.checkRootFragment((FragmentActivity)this) && PictureSelectionConfig.resultCallListener != null) {
            PictureSelectionConfig.resultCallListener.onCancel();
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)PictureContextWrapper.wrap(newBase, PictureSelectionConfig.getInstance().language));
    }
}

