/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.io;

import android.content.ContentResolver;
import android.net.Uri;
import com.luck.picture.lib.io.BufferedInputStreamWrap;
import com.luck.picture.lib.io.LruArrayPool;
import com.luck.picture.lib.utils.PictureFileUtils;
import java.io.InputStream;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;

public class ArrayPoolProvide {
    private final HashSet<String> keyCache = new HashSet();
    private final ConcurrentHashMap<String, BufferedInputStreamWrap> bufferedLruCache = new ConcurrentHashMap();
    private final LruArrayPool arrayPool = new LruArrayPool(0x400000);
    private static ArrayPoolProvide mInstance;

    public byte[] get(int bufferSize) {
        return this.arrayPool.get(bufferSize, byte[].class);
    }

    public void put(byte[] buffer) {
        this.arrayPool.put(buffer);
    }

    public InputStream openInputStream(ContentResolver resolver, Uri uri) {
        BufferedInputStreamWrap bufferedInputStreamWrap;
        try {
            bufferedInputStreamWrap = this.bufferedLruCache.get(uri.toString());
            if (bufferedInputStreamWrap != null) {
                bufferedInputStreamWrap.reset();
            } else {
                bufferedInputStreamWrap = this.wrapInputStream(resolver, uri);
            }
        }
        catch (Exception e) {
            try {
                return resolver.openInputStream(uri);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bufferedInputStreamWrap = this.wrapInputStream(resolver, uri);
            }
        }
        return bufferedInputStreamWrap;
    }

    private BufferedInputStreamWrap wrapInputStream(ContentResolver resolver, Uri uri) {
        BufferedInputStreamWrap bufferedInputStreamWrap = null;
        try {
            bufferedInputStreamWrap = new BufferedInputStreamWrap(resolver.openInputStream(uri));
            int available = bufferedInputStreamWrap.available();
            bufferedInputStreamWrap.mark(available > 0 ? available : 0x800000);
            this.bufferedLruCache.put(uri.toString(), bufferedInputStreamWrap);
            this.keyCache.add(uri.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bufferedInputStreamWrap;
    }

    public void clearMemory() {
        for (String key : this.keyCache) {
            BufferedInputStreamWrap inputStreamWrap = this.bufferedLruCache.get(key);
            PictureFileUtils.close(inputStreamWrap);
            this.bufferedLruCache.remove(key);
        }
        this.keyCache.clear();
        this.arrayPool.clearMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayPoolProvide getInstance() {
        if (mInstance != null) return mInstance;
        Class<ArrayPoolProvide> clazz = ArrayPoolProvide.class;
        synchronized (ArrayPoolProvide.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ArrayPoolProvide();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }
}

