/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.basic;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.media.SoundPool;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.luck.picture.lib.PictureOnlyCameraFragment;
import com.luck.picture.lib.PictureSelectorPreviewFragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.app.PictureAppMaster;
import com.luck.picture.lib.basic.IBridgePictureBehavior;
import com.luck.picture.lib.basic.IPictureSelectorCommonEvent;
import com.luck.picture.lib.basic.PictureContentResolver;
import com.luck.picture.lib.basic.PictureMediaScannerConnection;
import com.luck.picture.lib.basic.PictureSelector;
import com.luck.picture.lib.config.Crop;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.dialog.PhotoItemSelectedDialog;
import com.luck.picture.lib.dialog.PictureLoadingDialog;
import com.luck.picture.lib.dialog.RemindDialog;
import com.luck.picture.lib.engine.PictureSelectorEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.MediaExtraInfo;
import com.luck.picture.lib.immersive.ImmersiveManager;
import com.luck.picture.lib.interfaces.OnCallbackIndexListener;
import com.luck.picture.lib.interfaces.OnCallbackListener;
import com.luck.picture.lib.interfaces.OnItemClickListener;
import com.luck.picture.lib.language.PictureLanguageUtils;
import com.luck.picture.lib.loader.IBridgeMediaLoader;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.permissions.PermissionConfig;
import com.luck.picture.lib.permissions.PermissionResultCallback;
import com.luck.picture.lib.permissions.PermissionUtil;
import com.luck.picture.lib.service.ForegroundService;
import com.luck.picture.lib.style.PictureWindowAnimationStyle;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.utils.ActivityCompatHelper;
import com.luck.picture.lib.utils.BitmapUtils;
import com.luck.picture.lib.utils.MediaStoreUtils;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.PictureFileUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.ValueOf;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class PictureCommonFragment
extends Fragment
implements IPictureSelectorCommonEvent {
    private PermissionResultCallback mPermissionResultCallback;
    protected int mPage = 1;
    protected IBridgeMediaLoader mLoader;
    protected IBridgePictureBehavior iBridgePictureBehavior;
    protected PictureSelectionConfig config;
    private PictureLoadingDialog mLoadingDialog;
    private SoundPool soundPool;
    private int soundID;

    @Override
    public int getResourceId() {
        return 0;
    }

    @Override
    public void reStartSavedInstance(Bundle savedInstanceState) {
    }

    @Override
    public void onCheckOriginalChange() {
    }

    @Override
    public void dispatchCameraMediaResult(LocalMedia media) {
    }

    @Override
    public void onSelectedChange(boolean isAddRemove, LocalMedia currentMedia) {
    }

    @Override
    public void onFixedSelectedChange(LocalMedia oldLocalMedia) {
    }

    @Override
    public void sendChangeSubSelectPositionEvent(boolean adapterChange) {
    }

    @Override
    public void handlePermissionSettingResult() {
    }

    @Override
    public void onEditMedia(Intent intent) {
    }

    @Override
    public void onExitFragment() {
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (this.mPermissionResultCallback != null) {
            PermissionChecker.getInstance().onRequestPermissionsResult(grantResults, this.mPermissionResultCallback);
            this.mPermissionResultCallback = null;
        }
    }

    public void setPermissionsResultAction(PermissionResultCallback callback) {
        this.mPermissionResultCallback = callback;
    }

    @Override
    public void handlePermissionDenied(String[] permissionArray) {
        boolean isReadWrite = permissionArray == PermissionConfig.READ_WRITE_EXTERNAL_STORAGE || permissionArray == PermissionConfig.WRITE_EXTERNAL_STORAGE;
        PermissionUtil.goIntentSetting(this, isReadWrite, 1102);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (this.getResourceId() != 0) {
            return inflater.inflate(this.getResourceId(), container, false);
        }
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mLoadingDialog = new PictureLoadingDialog(this.getContext());
        if (savedInstanceState != null) {
            this.config = (PictureSelectionConfig)savedInstanceState.getParcelable("com.luck.picture.lib.PictureSelectorConfig");
        }
        if (this.config == null) {
            this.config = PictureSelectionConfig.getInstance();
        }
        if (this.config.isPreviewFullScreenMode) {
            SelectMainStyle selectMainStyle = PictureSelectionConfig.selectorStyle.getSelectMainStyle();
            ImmersiveManager.translucentStatusBar((Activity)this.getActivity(), selectMainStyle.isDarkStatusBarBlack());
        }
        if (this.config.isOpenClickSound && !this.config.isOnlyCamera) {
            this.soundPool = new SoundPool(1, 3, 0);
            this.soundID = this.soundPool.load(this.getContext(), R.raw.ps_click_music, 1);
        }
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.initAppLanguage();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.config != null) {
            outState.putParcelable("com.luck.picture.lib.PictureSelectorConfig", (Parcelable)this.config);
        }
    }

    @Nullable
    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        PictureWindowAnimationStyle windowAnimationStyle = PictureSelectionConfig.selectorStyle.getWindowAnimationStyle();
        if (enter) {
            return AnimationUtils.loadAnimation((Context)this.getActivity(), (int)windowAnimationStyle.activityEnterAnimation);
        }
        this.onExitFragment();
        return AnimationUtils.loadAnimation((Context)this.getActivity(), (int)windowAnimationStyle.activityExitAnimation);
    }

    @Override
    public int confirmSelect(LocalMedia currentMedia, boolean isSelected) {
        int resultCode;
        String curMimeType = currentMedia.getMimeType();
        long curDuration = currentMedia.getDuration();
        ArrayList<LocalMedia> selectedResult = SelectedManager.getSelectedResult();
        if (this.config.selectionMode == 2) {
            if (this.config.isWithVideoImage) {
                int selectVideoSize = 0;
                for (int i = 0; i < selectedResult.size(); ++i) {
                    String mimeType = ((LocalMedia)selectedResult.get(i)).getMimeType();
                    if (!PictureMimeType.isHasVideo(mimeType)) continue;
                    ++selectVideoSize;
                }
                if (this.checkWithMimeTypeValidity(isSelected, curMimeType, selectVideoSize, curDuration)) {
                    return -1;
                }
            } else if (this.checkOnlyMimeTypeValidity(isSelected, curMimeType, SelectedManager.getTopResultMimeType(), curDuration)) {
                return -1;
            }
        }
        if (isSelected) {
            selectedResult.remove(currentMedia);
            resultCode = 1;
        } else {
            if (this.config.selectionMode == 1 && selectedResult.size() > 0) {
                this.sendFixedSelectedChangeEvent((LocalMedia)selectedResult.get(0));
                selectedResult.clear();
            }
            selectedResult.add(currentMedia);
            currentMedia.setNum(selectedResult.size());
            resultCode = 0;
            this.playClickEffect();
        }
        this.sendSelectedChangeEvent(resultCode == 0, currentMedia);
        return resultCode;
    }

    @Override
    @SuppressLint(value={"StringFormatInvalid", "StringFormatMatches"})
    public boolean checkWithMimeTypeValidity(boolean isSelected, String curMimeType, int selectVideoSize, long duration) {
        if (PictureMimeType.isHasVideo(curMimeType)) {
            if (this.config.maxVideoSelectNum <= 0) {
                RemindDialog.showTipsDialog(this.getContext(), this.getString(R.string.ps_rule));
                return true;
            }
            if (!isSelected && SelectedManager.getSelectedResult().size() >= this.config.maxSelectNum) {
                RemindDialog.showTipsDialog(this.getContext(), this.getString(R.string.ps_message_max_num, new Object[]{this.config.maxSelectNum}));
                return true;
            }
            if (!isSelected && selectVideoSize >= this.config.maxVideoSelectNum) {
                RemindDialog.showTipsDialog(this.getContext(), PictureCommonFragment.getTipsMsg(this.getContext(), curMimeType, this.config.maxVideoSelectNum));
                return true;
            }
            if (!isSelected && this.config.videoMinSecond > 0 && duration < (long)this.config.videoMinSecond) {
                RemindDialog.showTipsDialog(this.getContext(), this.getString(R.string.ps_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                return true;
            }
            if (!isSelected && this.config.videoMaxSecond > 0 && duration > (long)this.config.videoMaxSecond) {
                RemindDialog.showTipsDialog(this.getContext(), this.getString(R.string.ps_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
                return true;
            }
        } else if (!isSelected && SelectedManager.getSelectedResult().size() >= this.config.maxSelectNum) {
            RemindDialog.showTipsDialog(this.getContext(), this.getString(R.string.ps_message_max_num, new Object[]{this.config.maxSelectNum}));
            return true;
        }
        return false;
    }

    @Override
    @SuppressLint(value={"StringFormatInvalid"})
    public boolean checkOnlyMimeTypeValidity(boolean isSelected, String curMimeType, String existMimeType, long duration) {
        boolean isSameMimeType = PictureMimeType.isMimeTypeSame(existMimeType, curMimeType);
        if (!isSameMimeType) {
            RemindDialog.showTipsDialog(this.getContext(), this.getString(R.string.ps_rule));
            return true;
        }
        if (PictureMimeType.isHasVideo(existMimeType) && this.config.maxVideoSelectNum > 0) {
            if (!isSelected && SelectedManager.getSelectedResult().size() >= this.config.maxVideoSelectNum) {
                RemindDialog.showTipsDialog(this.getContext(), PictureCommonFragment.getTipsMsg(this.getContext(), existMimeType, this.config.maxVideoSelectNum));
                return true;
            }
            if (!isSelected && this.config.videoMinSecond > 0 && duration < (long)this.config.videoMinSecond) {
                RemindDialog.showTipsDialog(this.getContext(), this.getString(R.string.ps_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                return true;
            }
            if (!isSelected && this.config.videoMaxSecond > 0 && duration > (long)this.config.videoMaxSecond) {
                RemindDialog.showTipsDialog(this.getContext(), this.getString(R.string.ps_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
                return true;
            }
        } else {
            if (!isSelected && SelectedManager.getSelectedResult().size() >= this.config.maxSelectNum) {
                RemindDialog.showTipsDialog(this.getContext(), PictureCommonFragment.getTipsMsg(this.getContext(), existMimeType, this.config.maxSelectNum));
                return true;
            }
            if (PictureMimeType.isHasVideo(curMimeType)) {
                if (!isSelected && this.config.videoMinSecond > 0 && duration < (long)this.config.videoMinSecond) {
                    RemindDialog.showTipsDialog(this.getContext(), this.getString(R.string.ps_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                    return true;
                }
                if (!isSelected && this.config.videoMaxSecond > 0 && duration > (long)this.config.videoMaxSecond) {
                    RemindDialog.showTipsDialog(this.getContext(), this.getString(R.string.ps_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
                    return true;
                }
            }
        }
        return false;
    }

    @SuppressLint(value={"StringFormatInvalid"})
    private static String getTipsMsg(Context context, String mimeType, int maxSelectNum) {
        if (PictureMimeType.isHasVideo(mimeType)) {
            return context.getString(R.string.ps_message_video_max_num, new Object[]{String.valueOf(maxSelectNum)});
        }
        if (PictureMimeType.isHasAudio(mimeType)) {
            return context.getString(R.string.ps_message_audio_max_num, new Object[]{String.valueOf(maxSelectNum)});
        }
        return context.getString(R.string.ps_message_max_num, new Object[]{String.valueOf(maxSelectNum)});
    }

    @Override
    public void sendSelectedChangeEvent(boolean isAddRemove, LocalMedia currentMedia) {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            List fragments = this.getActivity().getSupportFragmentManager().getFragments();
            for (int i = 0; i < fragments.size(); ++i) {
                Fragment fragment = (Fragment)fragments.get(i);
                if (!(fragment instanceof PictureCommonFragment)) continue;
                ((PictureCommonFragment)fragment).onSelectedChange(isAddRemove, currentMedia);
            }
        }
    }

    @Override
    public void sendFixedSelectedChangeEvent(LocalMedia currentMedia) {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            List fragments = this.getActivity().getSupportFragmentManager().getFragments();
            for (int i = 0; i < fragments.size(); ++i) {
                Fragment fragment = (Fragment)fragments.get(i);
                if (!(fragment instanceof PictureCommonFragment)) continue;
                ((PictureCommonFragment)fragment).onFixedSelectedChange(currentMedia);
            }
        }
    }

    @Override
    public void sendSelectedOriginalChangeEvent() {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            List fragments = this.getActivity().getSupportFragmentManager().getFragments();
            for (int i = 0; i < fragments.size(); ++i) {
                Fragment fragment = (Fragment)fragments.get(i);
                if (!(fragment instanceof PictureCommonFragment)) continue;
                ((PictureCommonFragment)fragment).onCheckOriginalChange();
            }
        }
    }

    @Override
    public void openSelectedCamera() {
        switch (this.config.chooseMode) {
            case 0: {
                if (this.config.ofAllCameraType == SelectMimeType.ofImage()) {
                    this.openImageCamera();
                    break;
                }
                if (this.config.ofAllCameraType == SelectMimeType.ofVideo()) {
                    this.openVideoCamera();
                    break;
                }
                this.onSelectedOnlyCamera();
                break;
            }
            case 1: {
                this.openImageCamera();
                break;
            }
            case 2: {
                this.openVideoCamera();
                break;
            }
            case 3: {
                this.openSoundRecording();
                break;
            }
        }
    }

    @Override
    public void onSelectedOnlyCamera() {
        PhotoItemSelectedDialog selectedDialog = PhotoItemSelectedDialog.newInstance();
        selectedDialog.setOnItemClickListener(new OnItemClickListener(){

            @Override
            public void onItemClick(View v, int position) {
                switch (position) {
                    case 0: {
                        if (PictureSelectionConfig.cameraInterceptListener != null) {
                            PictureCommonFragment.this.interceptCameraEvent(1);
                            break;
                        }
                        PictureCommonFragment.this.openImageCamera();
                        break;
                    }
                    case 1: {
                        if (PictureSelectionConfig.cameraInterceptListener != null) {
                            PictureCommonFragment.this.interceptCameraEvent(2);
                            break;
                        }
                        PictureCommonFragment.this.openVideoCamera();
                        break;
                    }
                }
            }
        });
        selectedDialog.show(this.getChildFragmentManager(), "PhotoItemSelectedDialog");
    }

    @Override
    public void openImageCamera() {
        if (PictureSelectionConfig.permissionsEventListener != null) {
            PictureSelectionConfig.permissionsEventListener.requestPermission(this, PermissionConfig.CAMERA, new OnCallbackListener<Boolean>(){

                @Override
                public void onCall(Boolean isResult) {
                    if (isResult.booleanValue()) {
                        PictureCommonFragment.this.startCameraImageCapture();
                    } else {
                        PictureCommonFragment.this.handlePermissionDenied(PermissionConfig.CAMERA);
                    }
                }
            });
        } else {
            PermissionChecker.getInstance().requestPermissions((Fragment)this, PermissionConfig.CAMERA, new PermissionResultCallback(){

                @Override
                public void onGranted() {
                    PictureCommonFragment.this.startCameraImageCapture();
                }

                @Override
                public void onDenied() {
                    PictureCommonFragment.this.handlePermissionDenied(PermissionConfig.CAMERA);
                }
            });
        }
    }

    private void startCameraImageCapture() {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            if (PictureSelectionConfig.cameraInterceptListener != null) {
                ForegroundService.startForegroundService(this.getContext());
                this.interceptCameraEvent(1);
            } else {
                Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
                if (cameraIntent.resolveActivity(this.getActivity().getPackageManager()) != null) {
                    ForegroundService.startForegroundService(this.getContext());
                    Uri imageUri = MediaStoreUtils.createCameraOutImageUri(this.getContext(), this.config);
                    if (imageUri != null) {
                        if (this.config.isCameraAroundState) {
                            cameraIntent.putExtra("android.intent.extras.CAMERA_FACING", 1);
                        }
                        cameraIntent.putExtra("output", (Parcelable)imageUri);
                        this.startActivityForResult(cameraIntent, 909);
                    }
                }
            }
        }
    }

    @Override
    public void openVideoCamera() {
        if (PictureSelectionConfig.permissionsEventListener != null) {
            PictureSelectionConfig.permissionsEventListener.requestPermission(this, PermissionConfig.CAMERA, new OnCallbackListener<Boolean>(){

                @Override
                public void onCall(Boolean isResult) {
                    if (isResult.booleanValue()) {
                        PictureCommonFragment.this.startCameraVideoCapture();
                    } else {
                        PictureCommonFragment.this.handlePermissionDenied(PermissionConfig.CAMERA);
                    }
                }
            });
        } else {
            PermissionChecker.getInstance().requestPermissions((Fragment)this, PermissionConfig.CAMERA, new PermissionResultCallback(){

                @Override
                public void onGranted() {
                    PictureCommonFragment.this.startCameraVideoCapture();
                }

                @Override
                public void onDenied() {
                    PictureCommonFragment.this.handlePermissionDenied(PermissionConfig.CAMERA);
                }
            });
        }
    }

    private void startCameraVideoCapture() {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            if (PictureSelectionConfig.cameraInterceptListener != null) {
                ForegroundService.startForegroundService(this.getContext());
                this.interceptCameraEvent(2);
            } else {
                Intent cameraIntent = new Intent("android.media.action.VIDEO_CAPTURE");
                if (cameraIntent.resolveActivity(this.getActivity().getPackageManager()) != null) {
                    ForegroundService.startForegroundService(this.getContext());
                    Uri videoUri = MediaStoreUtils.createCameraOutVideoUri(this.getContext(), this.config);
                    if (videoUri != null) {
                        cameraIntent.putExtra("output", (Parcelable)videoUri);
                        if (this.config.isCameraAroundState) {
                            cameraIntent.putExtra("android.intent.extras.CAMERA_FACING", 1);
                        }
                        cameraIntent.putExtra("android.intent.extra.quickCapture", this.config.isQuickCapture);
                        cameraIntent.putExtra("android.intent.extra.durationLimit", this.config.recordVideoMaxSecond);
                        cameraIntent.putExtra("android.intent.extra.videoQuality", this.config.videoQuality);
                        this.startActivityForResult(cameraIntent, 909);
                    }
                }
            }
        }
    }

    @Override
    public void openSoundRecording() {
        if (PictureSelectionConfig.permissionsEventListener != null) {
            PictureSelectionConfig.permissionsEventListener.requestPermission(this, PermissionConfig.RECORD_AUDIO, new OnCallbackListener<Boolean>(){

                @Override
                public void onCall(Boolean isResult) {
                    if (isResult.booleanValue()) {
                        PictureCommonFragment.this.startCameraRecordSound();
                    } else {
                        PictureCommonFragment.this.handlePermissionDenied(PermissionConfig.RECORD_AUDIO);
                    }
                }
            });
        } else {
            PermissionChecker.getInstance().requestPermissions((Fragment)this, new String[]{"android.permission.RECORD_AUDIO"}, new PermissionResultCallback(){

                @Override
                public void onGranted() {
                    PictureCommonFragment.this.startCameraRecordSound();
                }

                @Override
                public void onDenied() {
                    PictureCommonFragment.this.handlePermissionDenied(PermissionConfig.RECORD_AUDIO);
                }
            });
        }
    }

    private void startCameraRecordSound() {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            if (PictureSelectionConfig.cameraInterceptListener != null) {
                ForegroundService.startForegroundService(this.getContext());
                this.interceptCameraEvent(3);
            } else {
                Intent cameraIntent = new Intent("android.provider.MediaStore.RECORD_SOUND");
                if (cameraIntent.resolveActivity(this.getActivity().getPackageManager()) != null) {
                    ForegroundService.startForegroundService(this.getContext());
                    this.startActivityForResult(cameraIntent, 909);
                } else {
                    Toast.makeText((Context)this.getContext(), (CharSequence)"The system is missing a recording component", (int)1).show();
                }
            }
        }
    }

    private void interceptCameraEvent(int cameraMode) {
        ForegroundService.startForegroundService(this.getContext());
        PictureSelectionConfig.cameraInterceptListener.openCamera(this, this.config, cameraMode, 909);
    }

    private void playClickEffect() {
        if (this.soundPool != null && this.config.isOpenClickSound) {
            this.soundPool.play(this.soundID, 0.1f, 0.5f, 0, 1, 1.0f);
        }
    }

    private void releaseSoundPool() {
        try {
            if (this.soundPool != null) {
                this.soundPool.release();
                this.soundPool = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ForegroundService.stopService(this.getContext());
        if (resultCode == -1) {
            if (requestCode == 909) {
                this.dispatchHandleCamera(data);
            } else if (requestCode == 696) {
                this.onEditMedia(data);
            } else if (requestCode == 69) {
                ArrayList<LocalMedia> selectedResult = SelectedManager.getSelectedResult();
                try {
                    if (selectedResult.size() == 1) {
                        LocalMedia media = (LocalMedia)selectedResult.get(0);
                        Uri output = Crop.getOutput(data);
                        media.setCutPath(output != null ? output.getPath() : "");
                        media.setCut(!TextUtils.isEmpty((CharSequence)media.getCutPath()));
                        media.setCropImageWidth(Crop.getOutputImageWidth(data));
                        media.setCropImageHeight(Crop.getOutputImageHeight(data));
                        media.setCropOffsetX(Crop.getOutputImageOffsetX(data));
                        media.setCropOffsetY(Crop.getOutputImageOffsetY(data));
                        media.setCropResultAspectRatio(Crop.getOutputCropAspectRatio(data));
                        media.setCustomData(Crop.getOutputCustomExtraData(data));
                        media.setSandboxPath(media.getCutPath());
                    } else {
                        String extra = data.getStringExtra("output");
                        JSONArray array = new JSONArray(extra);
                        if (array.length() == selectedResult.size()) {
                            for (int i = 0; i < selectedResult.size(); ++i) {
                                LocalMedia media = (LocalMedia)selectedResult.get(i);
                                JSONObject item = array.optJSONObject(i);
                                media.setCutPath(item.optString("outPutPath"));
                                media.setCut(!TextUtils.isEmpty((CharSequence)media.getCutPath()));
                                media.setCropImageWidth(item.optInt("imageWidth"));
                                media.setCropImageHeight(item.optInt("imageHeight"));
                                media.setCropOffsetX(item.optInt("offsetX"));
                                media.setCropOffsetY(item.optInt("offsetY"));
                                media.setCropResultAspectRatio((float)item.optDouble("aspectRatio"));
                                media.setCustomData(item.optString("customExtraData"));
                                media.setSandboxPath(media.getCutPath());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Toast.makeText((Context)this.getContext(), (CharSequence)e.getMessage(), (int)1).show();
                }
                ArrayList<LocalMedia> result = new ArrayList<LocalMedia>(selectedResult);
                if (this.checkCompressValidity()) {
                    this.showLoading();
                    PictureSelectionConfig.compressEngine.onStartCompress(this.getContext(), result, new OnCallbackListener<ArrayList<LocalMedia>>(){

                        @Override
                        public void onCall(ArrayList<LocalMedia> result) {
                            PictureCommonFragment.this.onResultEvent(result);
                        }
                    });
                } else {
                    this.onResultEvent(result);
                }
            }
        } else if (resultCode == 96) {
            Throwable throwable;
            Throwable throwable2 = throwable = data != null ? Crop.getError(data) : new Throwable("image crop error");
            if (throwable != null) {
                Toast.makeText((Context)this.getContext(), (CharSequence)throwable.getMessage(), (int)1).show();
            }
        } else if (resultCode == 0) {
            if (requestCode == 909) {
                MediaUtils.deleteUri(this.getContext(), this.config.cameraPath);
            } else if (requestCode == 1102) {
                this.handlePermissionSettingResult();
            }
        }
    }

    private void dispatchHandleCamera(final Intent intent) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<LocalMedia>(){

            @Override
            public LocalMedia doInBackground() {
                String outputPath = PictureCommonFragment.this.getOutputPath(intent);
                if (!TextUtils.isEmpty((CharSequence)outputPath)) {
                    PictureCommonFragment.this.config.cameraPath = outputPath;
                }
                if (TextUtils.isEmpty((CharSequence)PictureCommonFragment.this.config.cameraPath)) {
                    return null;
                }
                if (PictureCommonFragment.this.config.chooseMode == SelectMimeType.ofAudio()) {
                    PictureCommonFragment.this.copyOutputAudioToDir();
                }
                return PictureCommonFragment.this.buildLocalMedia();
            }

            @Override
            public void onSuccess(LocalMedia result) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                if (result != null) {
                    PictureCommonFragment.this.dispatchCameraMediaResult(result);
                    PictureCommonFragment.this.onScannerScanFile(result);
                }
            }
        });
    }

    private void copyOutputAudioToDir() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.config.outPutAudioDir) && PictureMimeType.isContent(this.config.cameraPath)) {
                InputStream inputStream = PictureContentResolver.getContentResolverOpenInputStream(this.getContext(), Uri.parse((String)this.config.cameraPath));
                String audioFileName = TextUtils.isEmpty((CharSequence)this.config.outPutAudioFileName) ? "" : (this.config.isOnlyCamera ? this.config.outPutAudioFileName : System.currentTimeMillis() + "_" + this.config.outPutAudioFileName);
                File outputFile = PictureFileUtils.createCameraFile(this.getContext(), this.config.chooseMode, audioFileName, "", this.config.outPutAudioDir);
                FileOutputStream outputStream = new FileOutputStream(outputFile.getAbsolutePath());
                boolean isCopyStatus = PictureFileUtils.writeFileFromIS(inputStream, outputStream);
                if (isCopyStatus) {
                    MediaUtils.deleteUri(this.getContext(), this.config.cameraPath);
                    this.config.cameraPath = outputFile.getAbsolutePath();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected String getOutputPath(Intent data) {
        Uri outPutUri;
        String outputPath = null;
        if (data != null && (outPutUri = this.config.chooseMode == SelectMimeType.ofAudio() ? (data.getData() != null ? data.getData() : (Uri)data.getParcelableExtra("output")) : (Uri)data.getParcelableExtra("output")) != null) {
            outputPath = PictureMimeType.isContent(outPutUri.toString()) ? outPutUri.toString() : outPutUri.getPath();
        }
        return outputPath;
    }

    private void onScannerScanFile(LocalMedia media) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        if (SdkVersionUtils.isQ()) {
            if (PictureMimeType.isHasVideo(media.getMimeType()) && PictureMimeType.isContent(this.config.cameraPath)) {
                new PictureMediaScannerConnection((Context)this.getActivity(), media.getRealPath());
            }
        } else {
            int lastImageId;
            new PictureMediaScannerConnection((Context)this.getActivity(), PictureMimeType.isContent(this.config.cameraPath) ? media.getRealPath() : this.config.cameraPath);
            if (PictureMimeType.isHasImage(media.getMimeType()) && (lastImageId = MediaUtils.getDCIMLastImageId(this.getContext())) != -1) {
                MediaUtils.removeMedia(this.getContext(), lastImageId);
            }
        }
    }

    private LocalMedia buildLocalMedia() {
        long bucketId;
        long id2;
        File cameraFile;
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return null;
        }
        if (PictureMimeType.isContent(this.config.cameraPath)) {
            Uri cameraUri = Uri.parse((String)this.config.cameraPath);
            String path = PictureFileUtils.getPath((Context)this.getActivity(), cameraUri);
            cameraFile = new File(path);
            int lastIndexOf = this.config.cameraPath.lastIndexOf("/") + 1;
            id2 = lastIndexOf > 0 ? ValueOf.toLong(this.config.cameraPath.substring(lastIndexOf)) : System.currentTimeMillis();
            bucketId = MediaUtils.generateCameraBucketId(this.getContext(), cameraFile, "");
        } else {
            cameraFile = new File(this.config.cameraPath);
            id2 = System.currentTimeMillis();
            bucketId = MediaUtils.generateCameraBucketId(this.getContext(), cameraFile, this.config.outPutCameraDir);
        }
        String mimeType = MediaUtils.getMimeTypeFromMediaUrl(cameraFile.getAbsolutePath());
        if (this.config.isCameraRotateImage && PictureMimeType.isHasImage(mimeType) && !PictureMimeType.isContent(this.config.cameraPath)) {
            BitmapUtils.rotateImage(this.getContext(), this.config.cameraPath);
        }
        MediaExtraInfo mediaExtraInfo = PictureMimeType.isHasVideo(mimeType) ? MediaUtils.getVideoSize(this.getContext(), this.config.cameraPath) : (PictureMimeType.isHasAudio(mimeType) ? MediaUtils.getAudioSize(this.getContext(), this.config.cameraPath) : MediaUtils.getImageSize(this.getContext(), this.config.cameraPath));
        String folderName = MediaUtils.generateCameraFolderName(cameraFile.getAbsolutePath());
        LocalMedia media = LocalMedia.parseLocalMedia(id2, this.config.cameraPath, cameraFile.getAbsolutePath(), cameraFile.getName(), folderName, mediaExtraInfo.getDuration(), this.config.chooseMode, mimeType, mediaExtraInfo.getWidth(), mediaExtraInfo.getHeight(), cameraFile.length(), bucketId, cameraFile.lastModified() / 1000L);
        if (SdkVersionUtils.isQ()) {
            media.setSandboxPath(PictureMimeType.isContent(this.config.cameraPath) ? null : this.config.cameraPath);
        }
        return media;
    }

    protected void dispatchTransformResult() {
        ArrayList<LocalMedia> selectedResult = SelectedManager.getSelectedResult();
        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>(selectedResult);
        if (this.checkCropValidity()) {
            LocalMedia currentLocalMedia = null;
            for (int i = 0; i < result.size(); ++i) {
                LocalMedia item = result.get(i);
                if (!PictureMimeType.isHasImage(result.get(i).getMimeType())) continue;
                currentLocalMedia = item;
                break;
            }
            PictureSelectionConfig.cropEngine.onStartCrop(this, currentLocalMedia, result, 69);
        } else if (this.checkCompressValidity()) {
            this.showLoading();
            PictureSelectionConfig.compressEngine.onStartCompress(this.getContext(), result, new OnCallbackListener<ArrayList<LocalMedia>>(){

                @Override
                public void onCall(ArrayList<LocalMedia> result) {
                    PictureCommonFragment.this.onResultEvent(result);
                }
            });
        } else {
            this.onResultEvent(result);
        }
    }

    private boolean checkCropValidity() {
        if (PictureSelectionConfig.cropEngine != null) {
            if (SelectedManager.getCount() == 1) {
                return PictureMimeType.isHasImage(SelectedManager.getTopResultMimeType());
            }
            for (int i = 0; i < SelectedManager.getCount(); ++i) {
                LocalMedia media = SelectedManager.getSelectedResult().get(i);
                if (!PictureMimeType.isHasImage(media.getMimeType())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkCompressValidity() {
        if (PictureSelectionConfig.compressEngine != null) {
            for (int i = 0; i < SelectedManager.getCount(); ++i) {
                LocalMedia media = SelectedManager.getSelectedResult().get(i);
                if (!PictureMimeType.isHasImage(media.getMimeType())) continue;
                return true;
            }
        }
        return false;
    }

    private void copyExternalPathToAppInDirFor29(final ArrayList<LocalMedia> result) {
        this.showLoading();
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<ArrayList<LocalMedia>>(){

            @Override
            public ArrayList<LocalMedia> doInBackground() {
                for (int i = 0; i < result.size(); ++i) {
                    LocalMedia media = (LocalMedia)result.get(i);
                    PictureSelectionConfig.sandboxFileEngine.onStartSandboxFileTransform(PictureCommonFragment.this.getContext(), PictureCommonFragment.this.config.isCheckOriginalImage, i, media, new OnCallbackIndexListener<LocalMedia>(){

                        @Override
                        public void onCall(LocalMedia data, int index) {
                            LocalMedia media = (LocalMedia)result.get(index);
                            media.setSandboxPath(data.getSandboxPath());
                            if (PictureCommonFragment.this.config.isCheckOriginalImage) {
                                media.setOriginalPath(data.getOriginalPath());
                                media.setOriginal(!TextUtils.isEmpty((CharSequence)data.getOriginalPath()));
                            }
                        }
                    });
                }
                return result;
            }

            @Override
            public void onSuccess(ArrayList<LocalMedia> result2) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                PictureCommonFragment.this.callBackResult(result2);
            }
        });
    }

    private void mergeOriginalImage(ArrayList<LocalMedia> result) {
        if (this.config.isCheckOriginalImage) {
            for (int i = 0; i < result.size(); ++i) {
                LocalMedia media = result.get(i);
                media.setOriginal(true);
                media.setOriginalPath(media.getPath());
            }
        }
    }

    @Override
    public void onResultEvent(ArrayList<LocalMedia> result) {
        if (PictureSelectionConfig.sandboxFileEngine != null) {
            this.copyExternalPathToAppInDirFor29(result);
        } else {
            this.mergeOriginalImage(result);
            this.callBackResult(result);
        }
    }

    private void callBackResult(ArrayList<LocalMedia> result) {
        this.dismissLoading();
        if (PictureSelectionConfig.resultCallListener != null) {
            PictureSelectionConfig.resultCallListener.onResult(result);
        }
        SelectorResult selectorResult = this.getResult(-1, result);
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            this.getActivity().setResult(selectorResult.mResultCode, selectorResult.mResultData);
        }
        if (this.config.isOnlyCamera) {
            if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
                this.getActivity().getSupportFragmentManager().popBackStack();
                if (this.config.isActivityResultBack && this.iBridgePictureBehavior == null) {
                    throw new IllegalArgumentException(this.getActivity().toString() + " please must implement IBridgePictureBehavior onSelectFinish");
                }
                if (this.config.isActivityResultBack) {
                    this.iBridgePictureBehavior.onSelectFinish(true, selectorResult);
                }
            }
        } else {
            boolean isForcedExit = this instanceof PictureSelectorPreviewFragment;
            this.iBridgePictureBehavior.onSelectFinish(isForcedExit, selectorResult);
        }
        PictureSelectionConfig.destroy();
    }

    @Override
    public void initAppLanguage() {
        PictureSelectionConfig config = PictureSelectionConfig.getInstance();
        if (config.language != -2 && !config.isOnlyCamera) {
            PictureLanguageUtils.setAppLanguage((Context)this.getActivity(), config.language);
        }
    }

    @Override
    public void onRecreateEngine() {
        this.createImageLoaderEngine();
        this.createCompressEngine();
        this.createSandboxFileEngine();
        this.createLoaderDataEngine();
        this.createResultCallbackListener();
        this.createLayoutResourceListener();
    }

    public void onDestroy() {
        this.releaseSoundPool();
        super.onDestroy();
    }

    @Override
    public void showLoading() {
        try {
            if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
                return;
            }
            if (this.mLoadingDialog.isShowing()) {
                this.mLoadingDialog.dismiss();
            }
            this.mLoadingDialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dismissLoading() {
        try {
            if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
                return;
            }
            if (this.mLoadingDialog.isShowing()) {
                this.mLoadingDialog.dismiss();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onAttach(@NonNull Context context) {
        this.initAppLanguage();
        this.onRecreateEngine();
        super.onAttach(context);
        if (this.getParentFragment() instanceof IBridgePictureBehavior) {
            this.iBridgePictureBehavior = (IBridgePictureBehavior)this.getParentFragment();
        } else if (context instanceof IBridgePictureBehavior) {
            this.iBridgePictureBehavior = (IBridgePictureBehavior)context;
        } else if (!(this instanceof PictureOnlyCameraFragment) && !(this instanceof PictureSelectorPreviewFragment)) {
            throw new IllegalArgumentException(context.toString() + " please must implement IBridgePictureBehavior");
        }
    }

    private void createImageLoaderEngine() {
        PictureSelectorEngine baseEngine;
        if (PictureSelectionConfig.imageEngine == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
            PictureSelectionConfig.imageEngine = baseEngine.createImageLoaderEngine();
        }
    }

    private void createLoaderDataEngine() {
        PictureSelectorEngine baseEngine;
        if (PictureSelectionConfig.getInstance().isLoaderDataEngine && PictureSelectionConfig.loaderDataEngine == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
            PictureSelectionConfig.loaderDataEngine = baseEngine.createLoaderDataEngine();
        }
    }

    private void createCompressEngine() {
        PictureSelectorEngine baseEngine;
        if (PictureSelectionConfig.getInstance().isCompressEngine && PictureSelectionConfig.compressEngine == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
            PictureSelectionConfig.compressEngine = baseEngine.createCompressEngine();
        }
    }

    private void createSandboxFileEngine() {
        PictureSelectorEngine baseEngine;
        if (PictureSelectionConfig.getInstance().isSandboxFileEngine && PictureSelectionConfig.sandboxFileEngine == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
            PictureSelectionConfig.sandboxFileEngine = baseEngine.createSandboxFileEngine();
        }
    }

    private void createResultCallbackListener() {
        PictureSelectorEngine baseEngine;
        if (PictureSelectionConfig.getInstance().isResultListenerBack && PictureSelectionConfig.resultCallListener == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
            PictureSelectionConfig.resultCallListener = baseEngine.getResultCallbackListener();
        }
    }

    private void createLayoutResourceListener() {
        PictureSelectorEngine baseEngine;
        if (PictureSelectionConfig.getInstance().isInjectLayoutResource && PictureSelectionConfig.layoutResourceListener == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
            PictureSelectionConfig.layoutResourceListener = baseEngine.createLayoutResourceListener();
        }
    }

    protected SelectorResult getResult(int resultCode, ArrayList<LocalMedia> data) {
        return new SelectorResult(resultCode, PictureSelector.putIntentResult(data));
    }

    public static class SelectorResult {
        public int mResultCode;
        public Intent mResultData;

        public SelectorResult(int resultCode, Intent data) {
            this.mResultCode = resultCode;
            this.mResultData = data;
        }
    }
}

