/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.app.Activity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;

public class ActivityCompatHelper {
    private static final int MIN_FRAGMENT_COUNT = 1;

    public static boolean isDestroy(Activity activity) {
        if (activity == null) {
            return true;
        }
        return activity.isFinishing() || activity.isDestroyed();
    }

    public static boolean checkFragmentNonExits(FragmentActivity activity, String fragmentTag) {
        if (ActivityCompatHelper.isDestroy((Activity)activity)) {
            return false;
        }
        Fragment fragment = activity.getSupportFragmentManager().findFragmentByTag(fragmentTag);
        return fragment == null;
    }

    public static boolean checkRootFragment(FragmentActivity activity) {
        if (ActivityCompatHelper.isDestroy((Activity)activity)) {
            return false;
        }
        return activity.getSupportFragmentManager().getBackStackEntryCount() == 1;
    }
}

