/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.util.LruCache;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.BasePreviewHolder;
import com.luck.picture.lib.adapter.holder.PreviewVideoHolder;
import com.luck.picture.lib.config.InjectResourceSource;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import java.util.List;

public class PicturePreviewAdapter
extends RecyclerView.Adapter<BasePreviewHolder> {
    private final List<LocalMedia> mData;
    private final BasePreviewHolder.OnPreviewEventListener onPreviewEventListener;
    private final LruCache<Integer, BasePreviewHolder> mHolderLruCache = new LruCache(6);

    public BasePreviewHolder getCurrentHolder(int position) {
        return (BasePreviewHolder)((Object)this.mHolderLruCache.get((Object)position));
    }

    public PicturePreviewAdapter(List<LocalMedia> list, BasePreviewHolder.OnPreviewEventListener listener) {
        this.mData = list;
        this.onPreviewEventListener = listener;
    }

    @NonNull
    public BasePreviewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        int layoutResourceId = 0;
        if (viewType == 2) {
            layoutResourceId = InjectResourceSource.getLayoutResource(parent.getContext(), 8);
            return BasePreviewHolder.generate(parent, viewType, layoutResourceId != 0 ? layoutResourceId : R.layout.ps_preview_video);
        }
        layoutResourceId = InjectResourceSource.getLayoutResource(parent.getContext(), 7);
        return BasePreviewHolder.generate(parent, viewType, layoutResourceId != 0 ? layoutResourceId : R.layout.ps_preview_image);
    }

    public void onBindViewHolder(@NonNull BasePreviewHolder holder, int position) {
        holder.setOnPreviewEventListener(this.onPreviewEventListener);
        LocalMedia media = this.mData.get(position);
        this.mHolderLruCache.put((Object)position, (Object)holder);
        holder.bindData(media, position);
    }

    public int getItemViewType(int position) {
        if (PictureMimeType.isHasVideo(this.mData.get(position).getMimeType())) {
            return 2;
        }
        return 1;
    }

    public int getItemCount() {
        return this.mData != null ? this.mData.size() : 0;
    }

    public void onViewDetachedFromWindow(@NonNull BasePreviewHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        if (holder instanceof PreviewVideoHolder) {
            PreviewVideoHolder videoHolder = (PreviewVideoHolder)holder;
            videoHolder.releaseVideo();
        }
    }

    public void destroyVideo(int position) {
        BasePreviewHolder holder = (BasePreviewHolder)((Object)this.mHolderLruCache.get((Object)position));
        if (holder instanceof PreviewVideoHolder) {
            PreviewVideoHolder videoHolder = (PreviewVideoHolder)holder;
            videoHolder.releaseVideo();
        }
    }
}

