/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.basic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.luck.picture.lib.basic.PictureSelectionModel;
import com.luck.picture.lib.entity.LocalMedia;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public final class PictureSelector {
    private final WeakReference<Activity> mActivity;
    private final WeakReference<Fragment> mFragment;

    private PictureSelector(Activity activity) {
        this(activity, null);
    }

    private PictureSelector(Fragment fragment) {
        this((Activity)fragment.getActivity(), fragment);
    }

    private PictureSelector(Activity activity, Fragment fragment) {
        this.mActivity = new WeakReference<Activity>(activity);
        this.mFragment = new WeakReference<Fragment>(fragment);
    }

    public static PictureSelector create(Context context) {
        return new PictureSelector((Activity)context);
    }

    public static PictureSelector create(Activity activity) {
        return new PictureSelector(activity);
    }

    public static PictureSelector create(Fragment fragment) {
        return new PictureSelector(fragment);
    }

    public PictureSelectionModel openGallery(int chooseMode) {
        return new PictureSelectionModel(this, chooseMode);
    }

    public PictureSelectionModel openCamera(int chooseMode) {
        return new PictureSelectionModel(this, chooseMode, true);
    }

    public PictureSelectionModel openPreview() {
        return new PictureSelectionModel(this);
    }

    public static Intent putIntentResult(ArrayList<LocalMedia> data) {
        return new Intent().putParcelableArrayListExtra("extra_result_media", data);
    }

    public static ArrayList<LocalMedia> obtainSelectorList(Intent intent) {
        if (intent == null) {
            return new ArrayList<LocalMedia>();
        }
        ArrayList result = intent.getParcelableArrayListExtra("extra_result_media");
        return result != null ? result : new ArrayList();
    }

    @Nullable
    Activity getActivity() {
        return (Activity)this.mActivity.get();
    }

    @Nullable
    Fragment getFragment() {
        return this.mFragment != null ? (Fragment)this.mFragment.get() : null;
    }
}

