/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.luck.picture.lib.immersive.OSUtils;

public class DensityUtil {
    public static int getScreenWidth(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(dm);
        return dm.widthPixels;
    }

    public static int getScreenHeightPixels(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(dm);
        return dm.heightPixels;
    }

    public static int getScreenHeight(Context context) {
        return DensityUtil.getScreenHeightPixels(context) - DensityUtil.getStatusBarHeight(context);
    }

    public static int getAppInScreenHeight(Context context) {
        return DensityUtil.getScreenHeightPixels(context) + DensityUtil.getStatusBarHeight(context);
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result == 0 ? DensityUtil.dip2px(context, 26.0f) : result;
    }

    public static boolean hasNavigationBar(Activity activity) {
        return DensityUtil.getNavigationBarHeight((Context)activity) > 0;
    }

    @TargetApi(value=14)
    public static int getNavigationBarWidth(Context context) {
        int result = 0;
        if (Build.VERSION.SDK_INT >= 14 && DensityUtil.hasNavBar((Activity)context)) {
            return DensityUtil.getInternalDimensionSize(context, "navigation_bar_width");
        }
        return result;
    }

    @TargetApi(value=14)
    public static int getNavigationBarHeight(Context context) {
        boolean mInPortrait;
        int result = 0;
        Resources res = context.getResources();
        boolean bl = mInPortrait = res.getConfiguration().orientation == 1;
        if (Build.VERSION.SDK_INT >= 14 && DensityUtil.hasNavBar((Activity)context)) {
            String key = mInPortrait ? "navigation_bar_height" : "navigation_bar_height_landscape";
            return DensityUtil.getInternalDimensionSize(context, key);
        }
        return result;
    }

    private static int getInternalDimensionSize(Context context, String key) {
        int result = 0;
        try {
            int resourceId = Resources.getSystem().getIdentifier(key, "dimen", "android");
            if (resourceId > 0) {
                int sizeOne = context.getResources().getDimensionPixelSize(resourceId);
                int sizeTwo = Resources.getSystem().getDimensionPixelSize(resourceId);
                if (sizeTwo >= sizeOne) {
                    return sizeTwo;
                }
                float densityTwo = Resources.getSystem().getDisplayMetrics().density;
                float densityOne = context.getResources().getDisplayMetrics().density;
                float f = (float)sizeOne * densityTwo / densityOne;
                return (int)(f >= 0.0f ? f + 0.5f : f - 0.5f);
            }
        }
        catch (Resources.NotFoundException ignored) {
            return 0;
        }
        return result;
    }

    @SuppressLint(value={"NewApi"})
    private static float getSmallestWidthDp(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 16) {
            activity.getWindowManager().getDefaultDisplay().getRealMetrics(metrics);
        } else {
            activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        }
        float widthDp = (float)metrics.widthPixels / metrics.density;
        float heightDp = (float)metrics.heightPixels / metrics.density;
        return Math.min(widthDp, heightDp);
    }

    public static boolean isNavigationAtBottom(Activity activity) {
        Resources res = activity.getResources();
        boolean mInPortrait = res.getConfiguration().orientation == 1;
        return DensityUtil.getSmallestWidthDp(activity) >= 600.0f || mInPortrait;
    }

    @TargetApi(value=14)
    private static boolean hasNavBar(Activity activity) {
        if (Build.VERSION.SDK_INT >= 17) {
            if (Settings.Global.getInt((ContentResolver)activity.getContentResolver(), (String)"force_fsg_nav_bar", (int)0) != 0) {
                return false;
            }
            if (OSUtils.isEMUI() && (OSUtils.isEMUI3_x() || Build.VERSION.SDK_INT < 21 ? Settings.System.getInt((ContentResolver)activity.getContentResolver(), (String)"navigationbar_is_min", (int)0) != 0 : Settings.Global.getInt((ContentResolver)activity.getContentResolver(), (String)"navigationbar_is_min", (int)0) != 0)) {
                return false;
            }
        }
        WindowManager windowManager = activity.getWindowManager();
        Display d = windowManager.getDefaultDisplay();
        DisplayMetrics realDisplayMetrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            d.getRealMetrics(realDisplayMetrics);
        }
        int realHeight = realDisplayMetrics.heightPixels;
        int realWidth = realDisplayMetrics.widthPixels;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        d.getMetrics(displayMetrics);
        int displayHeight = displayMetrics.heightPixels;
        int displayWidth = displayMetrics.widthPixels;
        return realWidth - displayWidth > 0 || realHeight - displayHeight > 0;
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getApplicationContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

