/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.PSEglUtils;
import com.luck.picture.lib.utils.PictureFileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class BitmapUtils {
    public static void rotateImage(Context context, String path) {
        try {
            int degree = BitmapUtils.readPictureDegree(context, path);
            if (degree > 0) {
                BitmapFactory.Options opts = new BitmapFactory.Options();
                opts.inSampleSize = 2;
                File file = new File(path);
                Bitmap bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)opts);
                if (bitmap != null) {
                    bitmap = BitmapUtils.rotatingImage(bitmap, degree);
                }
                if (bitmap != null) {
                    BitmapUtils.saveBitmapFile(bitmap, file);
                    bitmap.recycle();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Bitmap rotatingImage(Bitmap bitmap, int angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveBitmapFile(Bitmap bitmap, File file) {
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)bos);
            bos.flush();
            PictureFileUtils.close(bos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            PictureFileUtils.close(bos);
        }
    }

    /*
     * Exception decompiling
     */
    public static int readPictureDegree(Context context, String filePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int[] getMaxImageSize(Context context, int imageWidth, int imageHeight, int screenWidth, int screenHeight) {
        if (imageWidth == 0 && imageHeight == 0) {
            imageWidth = screenWidth;
            imageHeight = screenHeight;
        }
        if (MediaUtils.isLongImage(imageWidth, imageHeight)) {
            return new int[]{-1, -1};
        }
        int maxBitmapSize = BitmapUtils.calculateMaxBitmapSize(context);
        int inSampleSize = BitmapUtils.calculateInSampleSize(imageWidth, imageHeight, maxBitmapSize, maxBitmapSize);
        int newWidth = imageWidth / inSampleSize;
        int newHeight = imageHeight / inSampleSize;
        return new int[]{newWidth, newHeight};
    }

    private static int calculateInSampleSize(int width, int height, int reqWidth, int reqHeight) {
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            while (height / inSampleSize > reqHeight || width / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    private static int calculateMaxBitmapSize(@NonNull Context context) {
        int maxTextureSize;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Point size = new Point();
        if (wm != null) {
            Display display = wm.getDefaultDisplay();
            display.getSize(size);
        }
        int width = size.x;
        int height = size.y;
        int maxBitmapSize = (int)Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0));
        Canvas canvas = new Canvas();
        int maxCanvasSize = Math.min(canvas.getMaximumBitmapWidth(), canvas.getMaximumBitmapHeight());
        if (maxCanvasSize > 0) {
            maxBitmapSize = Math.min(maxBitmapSize, maxCanvasSize);
        }
        if ((maxTextureSize = PSEglUtils.getMaxTextureSize()) > 0) {
            maxBitmapSize = Math.min(maxBitmapSize, maxTextureSize);
        }
        return maxBitmapSize;
    }
}

