/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.basic.PictureCommonFragment;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnRequestPermissionListener;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.permissions.PermissionConfig;
import com.luck.picture.lib.permissions.PermissionResultCallback;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.ToastUtils;
import java.util.List;

public class PictureSelectorSystemFragment
extends PictureCommonFragment {
    public static final String TAG = PictureSelectorSystemFragment.class.getSimpleName();
    private ActivityResultLauncher<String[]> mDocMultipleLauncher;
    private ActivityResultLauncher<String[]> mDocSingleLauncher;
    private ActivityResultLauncher<String> mContentsLauncher;
    private ActivityResultLauncher<String> mContentLauncher;

    public static PictureSelectorSystemFragment newInstance() {
        return new PictureSelectorSystemFragment();
    }

    @Override
    public String getFragmentTag() {
        return TAG;
    }

    @Override
    public int getResourceId() {
        return R.layout.ps_empty;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.createSystemContracts();
        if (PermissionChecker.isCheckReadStorage(this.getContext())) {
            this.openSystemAlbum();
        } else if (PictureSelectionConfig.onPermissionsEventListener != null) {
            PictureSelectionConfig.onPermissionsEventListener.requestPermission(this, PermissionConfig.READ_WRITE_EXTERNAL_STORAGE, new OnRequestPermissionListener(){

                @Override
                public void onCall(String[] permissionArray, boolean isResult) {
                    if (isResult) {
                        PictureSelectorSystemFragment.this.openSystemAlbum();
                    } else {
                        PictureSelectorSystemFragment.this.handlePermissionDenied(permissionArray);
                    }
                }
            });
        } else {
            PermissionChecker.getInstance().requestPermissions((Fragment)this, PermissionConfig.READ_WRITE_EXTERNAL_STORAGE, new PermissionResultCallback(){

                @Override
                public void onGranted() {
                    PictureSelectorSystemFragment.this.openSystemAlbum();
                }

                @Override
                public void onDenied() {
                    PictureSelectorSystemFragment.this.handlePermissionDenied(PermissionConfig.READ_WRITE_EXTERNAL_STORAGE);
                }
            });
        }
    }

    private void openSystemAlbum() {
        if (this.config.selectionMode == 1) {
            if (this.config.chooseMode == SelectMimeType.ofAll()) {
                this.mDocSingleLauncher.launch((Object)SelectMimeType.SYSTEM_ALL);
            } else {
                this.mContentLauncher.launch((Object)this.getInput());
            }
        } else if (this.config.chooseMode == SelectMimeType.ofAll()) {
            this.mDocMultipleLauncher.launch((Object)SelectMimeType.SYSTEM_ALL);
        } else {
            this.mContentsLauncher.launch((Object)this.getInput());
        }
    }

    private void createSystemContracts() {
        if (this.config.selectionMode == 1) {
            if (this.config.chooseMode == SelectMimeType.ofAll()) {
                this.createSingleDocuments();
            } else {
                this.createContent();
            }
        } else if (this.config.chooseMode == SelectMimeType.ofAll()) {
            this.createMultipleDocuments();
        } else {
            this.createMultipleContents();
        }
    }

    private void createMultipleDocuments() {
        this.mDocMultipleLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.OpenMultipleDocuments(), (ActivityResultCallback)new ActivityResultCallback<List<Uri>>(){

            public void onActivityResult(List<Uri> result) {
                if (result == null || result.size() == 0) {
                    PictureSelectorSystemFragment.this.onKeyBackFragmentFinish();
                } else {
                    for (int i = 0; i < result.size(); ++i) {
                        LocalMedia media = PictureSelectorSystemFragment.this.buildLocalMedia(result.get(i).toString());
                        media.setPath(SdkVersionUtils.isQ() ? media.getPath() : media.getRealPath());
                        SelectedManager.addSelectResult(media);
                    }
                    PictureSelectorSystemFragment.this.dispatchTransformResult();
                }
            }
        });
    }

    private void createSingleDocuments() {
        this.mDocSingleLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.OpenDocument(), (ActivityResultCallback)new ActivityResultCallback<Uri>(){

            public void onActivityResult(Uri result) {
                if (result == null) {
                    PictureSelectorSystemFragment.this.onKeyBackFragmentFinish();
                } else {
                    LocalMedia media = PictureSelectorSystemFragment.this.buildLocalMedia(result.toString());
                    media.setPath(SdkVersionUtils.isQ() ? media.getPath() : media.getRealPath());
                    int selectResultCode = PictureSelectorSystemFragment.this.confirmSelect(media, false);
                    if (selectResultCode == 0) {
                        PictureSelectorSystemFragment.this.dispatchTransformResult();
                    } else {
                        PictureSelectorSystemFragment.this.onKeyBackFragmentFinish();
                    }
                }
            }
        });
    }

    private void createMultipleContents() {
        this.mContentsLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.GetMultipleContents(), (ActivityResultCallback)new ActivityResultCallback<List<Uri>>(){

            public void onActivityResult(List<Uri> result) {
                if (result == null || result.size() == 0) {
                    PictureSelectorSystemFragment.this.onKeyBackFragmentFinish();
                } else {
                    for (int i = 0; i < result.size(); ++i) {
                        LocalMedia media = PictureSelectorSystemFragment.this.buildLocalMedia(result.get(i).toString());
                        media.setPath(SdkVersionUtils.isQ() ? media.getPath() : media.getRealPath());
                        SelectedManager.addSelectResult(media);
                    }
                    PictureSelectorSystemFragment.this.dispatchTransformResult();
                }
            }
        });
    }

    private void createContent() {
        this.mContentLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.GetContent(), (ActivityResultCallback)new ActivityResultCallback<Uri>(){

            public void onActivityResult(Uri result) {
                if (result == null) {
                    PictureSelectorSystemFragment.this.onKeyBackFragmentFinish();
                } else {
                    LocalMedia media = PictureSelectorSystemFragment.this.buildLocalMedia(result.toString());
                    media.setPath(SdkVersionUtils.isQ() ? media.getPath() : media.getRealPath());
                    int selectResultCode = PictureSelectorSystemFragment.this.confirmSelect(media, false);
                    if (selectResultCode == 0) {
                        PictureSelectorSystemFragment.this.dispatchTransformResult();
                    } else {
                        PictureSelectorSystemFragment.this.onKeyBackFragmentFinish();
                    }
                }
            }
        });
    }

    private String getInput() {
        if (this.config.chooseMode == SelectMimeType.ofVideo()) {
            return "video/*";
        }
        if (this.config.chooseMode == SelectMimeType.ofAudio()) {
            return "audio/*";
        }
        return "image/*";
    }

    @Override
    public void handlePermissionSettingResult(String[] permissions) {
        boolean isHasPermissions = PictureSelectionConfig.onPermissionsEventListener != null ? PictureSelectionConfig.onPermissionsEventListener.hasPermissions(this, permissions) : PermissionChecker.isCheckReadStorage(this.getContext());
        if (isHasPermissions) {
            this.openSystemAlbum();
        } else {
            ToastUtils.showToast(this.getContext(), this.getString(R.string.ps_jurisdiction));
            this.onKeyBackFragmentFinish();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.mDocMultipleLauncher != null) {
            this.mDocMultipleLauncher.unregister();
        }
        if (this.mDocSingleLauncher != null) {
            this.mDocSingleLauncher.unregister();
        }
        if (this.mContentsLauncher != null) {
            this.mContentsLauncher.unregister();
        }
        if (this.mContentLauncher != null) {
            this.mContentLauncher.unregister();
        }
    }
}

