/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import com.luck.picture.lib.immersive.RomUtils;

public class DensityUtil {
    public static int getRealScreenWidth(Context context) {
        WindowManager wm = (WindowManager)context.getApplicationContext().getSystemService("window");
        Point point = new Point();
        wm.getDefaultDisplay().getRealSize(point);
        return point.x;
    }

    public static int getRealScreenHeight(Context context) {
        WindowManager wm = (WindowManager)context.getApplicationContext().getSystemService("window");
        Point point = new Point();
        wm.getDefaultDisplay().getRealSize(point);
        return point.y;
    }

    public static int getScreenHeight(Context context) {
        return DensityUtil.getRealScreenHeight(context) - DensityUtil.getStatusNavigationBarHeight(context);
    }

    private static int getStatusNavigationBarHeight(Context context) {
        if (DensityUtil.isNavBarVisible(context)) {
            return DensityUtil.getStatusBarHeight(context) + DensityUtil.getNavigationBarHeight(context);
        }
        return DensityUtil.getStatusBarHeight(context);
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result == 0 ? DensityUtil.dip2px(context, 26.0f) : result;
    }

    public static boolean isNavBarVisible(Context context) {
        boolean isVisible = false;
        if (!(context instanceof Activity)) {
            return false;
        }
        Activity activity = (Activity)context;
        Window window = activity.getWindow();
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        int count = decorView.getChildCount();
        for (int i = 0; i < count; ++i) {
            String resourceEntryName;
            View child = decorView.getChildAt(i);
            int id2 = child.getId();
            if (id2 == -1 || !"navigationBarBackground".equals(resourceEntryName = DensityUtil.getResNameById((Context)activity, id2)) || child.getVisibility() != 0) continue;
            isVisible = true;
            break;
        }
        if (isVisible) {
            int visibility;
            if (RomUtils.isSamsung() && Build.VERSION.SDK_INT >= 17 && Build.VERSION.SDK_INT < 29) {
                try {
                    return Settings.Global.getInt((ContentResolver)activity.getContentResolver(), (String)"navigationbar_hide_bar_enabled") == 0;
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            isVisible = ((visibility = decorView.getSystemUiVisibility()) & 2) == 0;
        }
        return isVisible;
    }

    private static String getResNameById(Context context, int id2) {
        try {
            return context.getResources().getResourceEntryName(id2);
        }
        catch (Exception ignore) {
            return "";
        }
    }

    @TargetApi(value=14)
    public static int getNavigationBarWidth(Context context) {
        int result = 0;
        if (Build.VERSION.SDK_INT >= 14 && DensityUtil.isNavBarVisible(context)) {
            return DensityUtil.getInternalDimensionSize(context, "navigation_bar_width");
        }
        return result;
    }

    @TargetApi(value=14)
    public static int getNavigationBarHeight(Context context) {
        boolean mInPortrait;
        int result = 0;
        Resources res = context.getResources();
        boolean bl = mInPortrait = res.getConfiguration().orientation == 1;
        if (DensityUtil.isNavBarVisible(context)) {
            String key = mInPortrait ? "navigation_bar_height" : "navigation_bar_height_landscape";
            return DensityUtil.getInternalDimensionSize(context, key);
        }
        return result;
    }

    private static int getInternalDimensionSize(Context context, String key) {
        int result = 0;
        try {
            int resourceId = Resources.getSystem().getIdentifier(key, "dimen", "android");
            if (resourceId > 0) {
                int sizeOne = context.getResources().getDimensionPixelSize(resourceId);
                int sizeTwo = Resources.getSystem().getDimensionPixelSize(resourceId);
                if (sizeTwo >= sizeOne) {
                    return sizeTwo;
                }
                float densityTwo = Resources.getSystem().getDisplayMetrics().density;
                float densityOne = context.getResources().getDisplayMetrics().density;
                float f = (float)sizeOne * densityTwo / densityOne;
                return (int)(f >= 0.0f ? f + 0.5f : f - 0.5f);
            }
        }
        catch (Resources.NotFoundException ignored) {
            return 0;
        }
        return result;
    }

    @SuppressLint(value={"NewApi"})
    private static float getSmallestWidthDp(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 16) {
            activity.getWindowManager().getDefaultDisplay().getRealMetrics(metrics);
        } else {
            activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        }
        float widthDp = (float)metrics.widthPixels / metrics.density;
        float heightDp = (float)metrics.heightPixels / metrics.density;
        return Math.min(widthDp, heightDp);
    }

    public static boolean isNavigationAtBottom(Activity activity) {
        Resources res = activity.getResources();
        boolean mInPortrait = res.getConfiguration().orientation == 1;
        return DensityUtil.getSmallestWidthDp(activity) >= 600.0f || mInPortrait;
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getApplicationContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

