/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.basic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.activity.result.ActivityResultLauncher;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.luck.picture.lib.PictureSelectorSystemFragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.basic.FragmentInjectManager;
import com.luck.picture.lib.basic.IBridgePictureBehavior;
import com.luck.picture.lib.basic.PictureSelector;
import com.luck.picture.lib.basic.PictureSelectorTransparentActivity;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.engine.CompressEngine;
import com.luck.picture.lib.engine.CropEngine;
import com.luck.picture.lib.engine.SandboxFileEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnPermissionsInterceptListener;
import com.luck.picture.lib.interfaces.OnResultCallbackListener;
import com.luck.picture.lib.interfaces.OnSelectLimitTipsListener;
import com.luck.picture.lib.utils.DoubleUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import java.util.Arrays;

public final class PictureSelectionSystemModel {
    private final PictureSelectionConfig selectionConfig;
    private final PictureSelector selector;

    public PictureSelectionSystemModel(PictureSelector selector, int chooseMode) {
        this.selector = selector;
        this.selectionConfig = PictureSelectionConfig.getCleanInstance();
        this.selectionConfig.chooseMode = chooseMode;
        this.selectionConfig.isPreviewFullScreenMode = false;
        this.selectionConfig.isPreviewZoomEffect = false;
    }

    public PictureSelectionSystemModel setSelectionMode(int selectionMode) {
        this.selectionConfig.selectionMode = selectionMode;
        return this;
    }

    public PictureSelectionSystemModel isOriginalControl(boolean isOriginalControl) {
        this.selectionConfig.isCheckOriginalImage = isOriginalControl;
        return this;
    }

    public PictureSelectionSystemModel setSkipCropMimeType(String ... mimeTypes) {
        if (mimeTypes != null && mimeTypes.length > 0) {
            this.selectionConfig.skipCropList.addAll(Arrays.asList(mimeTypes));
        }
        return this;
    }

    public PictureSelectionSystemModel setCompressEngine(CompressEngine engine) {
        if (PictureSelectionConfig.compressEngine != engine) {
            PictureSelectionConfig.compressEngine = engine;
            this.selectionConfig.isCompressEngine = true;
        } else {
            this.selectionConfig.isCompressEngine = false;
        }
        return this;
    }

    public PictureSelectionSystemModel setCropEngine(CropEngine engine) {
        if (PictureSelectionConfig.cropEngine != engine) {
            PictureSelectionConfig.cropEngine = engine;
        }
        return this;
    }

    public PictureSelectionSystemModel setSandboxFileEngine(SandboxFileEngine engine) {
        if (SdkVersionUtils.isQ() && PictureSelectionConfig.sandboxFileEngine != engine) {
            PictureSelectionConfig.sandboxFileEngine = engine;
            this.selectionConfig.isSandboxFileEngine = true;
        } else {
            this.selectionConfig.isSandboxFileEngine = false;
        }
        return this;
    }

    public PictureSelectionSystemModel setSelectMaxFileSize(long fileKbSize) {
        this.selectionConfig.selectMaxFileSize = fileKbSize >= 0x100000L ? fileKbSize : fileKbSize * 1024L;
        return this;
    }

    public PictureSelectionSystemModel setSelectMinFileSize(long fileKbSize) {
        this.selectionConfig.selectMinFileSize = fileKbSize >= 0x100000L ? fileKbSize : fileKbSize * 1024L;
        return this;
    }

    public PictureSelectionSystemModel setSelectMaxDurationSecond(int maxDurationSecond) {
        this.selectionConfig.selectMaxDurationSecond = maxDurationSecond * 1000;
        return this;
    }

    public PictureSelectionSystemModel setSelectMinDurationSecond(int minDurationSecond) {
        this.selectionConfig.selectMinDurationSecond = minDurationSecond * 1000;
        return this;
    }

    public PictureSelectionSystemModel setPermissionsInterceptListener(OnPermissionsInterceptListener listener) {
        PictureSelectionConfig.onPermissionsEventListener = listener;
        return this;
    }

    public PictureSelectionSystemModel setSelectLimitTipsListener(OnSelectLimitTipsListener listener) {
        PictureSelectionConfig.onSelectLimitTipsListener = listener;
        return this;
    }

    public void forSystemResult(OnResultCallbackListener<LocalMedia> call) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            if (call == null) {
                throw new NullPointerException("OnResultCallbackListener cannot be null");
            }
            PictureSelectionConfig.onResultCallListener = call;
            this.selectionConfig.isResultListenerBack = true;
            this.selectionConfig.isActivityResultBack = false;
            FragmentManager fragmentManager = null;
            if (activity instanceof AppCompatActivity) {
                fragmentManager = ((AppCompatActivity)activity).getSupportFragmentManager();
            } else if (activity instanceof FragmentActivity) {
                fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            }
            if (fragmentManager == null) {
                throw new NullPointerException("FragmentManager cannot be null");
            }
            Fragment fragment = fragmentManager.findFragmentByTag(PictureSelectorSystemFragment.TAG);
            if (fragment != null) {
                fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
            }
            FragmentInjectManager.injectSystemRoomFragment(fragmentManager, PictureSelectorSystemFragment.TAG, PictureSelectorSystemFragment.newInstance());
        }
    }

    public void forSystemResult() {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            if (!(activity instanceof IBridgePictureBehavior)) {
                throw new NullPointerException("Use only forSystemResult();,Activity or Fragment interface needs to be implemented " + IBridgePictureBehavior.class);
            }
            this.selectionConfig.isActivityResultBack = true;
            PictureSelectionConfig.onResultCallListener = null;
            this.selectionConfig.isResultListenerBack = false;
            FragmentManager fragmentManager = null;
            if (activity instanceof AppCompatActivity) {
                fragmentManager = ((AppCompatActivity)activity).getSupportFragmentManager();
            } else if (activity instanceof FragmentActivity) {
                fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            }
            if (fragmentManager == null) {
                throw new NullPointerException("FragmentManager cannot be null");
            }
            Fragment fragment = fragmentManager.findFragmentByTag(PictureSelectorSystemFragment.TAG);
            if (fragment != null) {
                fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
            }
            FragmentInjectManager.injectSystemRoomFragment(fragmentManager, PictureSelectorSystemFragment.TAG, PictureSelectorSystemFragment.newInstance());
        }
    }

    public void forSystemResultActivity(int requestCode) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            this.selectionConfig.isResultListenerBack = false;
            this.selectionConfig.isActivityResultBack = true;
            Intent intent = new Intent((Context)activity, PictureSelectorTransparentActivity.class);
            intent.putExtra("com.luck.picture.lib.mode_type_source", 1);
            Fragment fragment = this.selector.getFragment();
            if (fragment != null) {
                fragment.startActivityForResult(intent, requestCode);
            } else {
                activity.startActivityForResult(intent, requestCode);
            }
            activity.overridePendingTransition(R.anim.ps_anim_fade_in, 0);
        }
    }

    public void forSystemResultActivity(ActivityResultLauncher<Intent> launcher) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            if (launcher == null) {
                throw new NullPointerException("ActivityResultLauncher cannot be null");
            }
            this.selectionConfig.isResultListenerBack = false;
            this.selectionConfig.isActivityResultBack = true;
            Intent intent = new Intent((Context)activity, PictureSelectorTransparentActivity.class);
            intent.putExtra("com.luck.picture.lib.mode_type_source", 1);
            launcher.launch((Object)intent);
            activity.overridePendingTransition(R.anim.ps_anim_fade_in, 0);
        }
    }

    public void forSystemResultActivity(OnResultCallbackListener<LocalMedia> call) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            if (call == null) {
                throw new NullPointerException("OnResultCallbackListener cannot be null");
            }
            this.selectionConfig.isResultListenerBack = true;
            this.selectionConfig.isActivityResultBack = false;
            PictureSelectionConfig.onResultCallListener = call;
            Intent intent = new Intent((Context)activity, PictureSelectorTransparentActivity.class);
            intent.putExtra("com.luck.picture.lib.mode_type_source", 1);
            activity.startActivity(intent);
            activity.overridePendingTransition(R.anim.ps_anim_fade_in, 0);
        }
    }
}

