/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.basic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.activity.result.ActivityResultLauncher;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.luck.picture.lib.PictureOnlyCameraFragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.basic.FragmentInjectManager;
import com.luck.picture.lib.basic.IBridgePictureBehavior;
import com.luck.picture.lib.basic.PictureSelector;
import com.luck.picture.lib.basic.PictureSelectorTransparentActivity;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.engine.CompressEngine;
import com.luck.picture.lib.engine.CropEngine;
import com.luck.picture.lib.engine.SandboxFileEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnCameraInterceptListener;
import com.luck.picture.lib.interfaces.OnPermissionsInterceptListener;
import com.luck.picture.lib.interfaces.OnResultCallbackListener;
import com.luck.picture.lib.interfaces.OnSelectLimitTipsListener;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.utils.DoubleUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import java.util.ArrayList;
import java.util.List;

public final class PictureSelectionCameraModel {
    private final PictureSelectionConfig selectionConfig;
    private final PictureSelector selector;

    public PictureSelectionCameraModel(PictureSelector selector, int chooseMode) {
        this.selector = selector;
        this.selectionConfig = PictureSelectionConfig.getCleanInstance();
        this.selectionConfig.chooseMode = chooseMode;
        this.selectionConfig.isOnlyCamera = true;
        this.selectionConfig.isDisplayTimeAxis = false;
        this.selectionConfig.isPreviewFullScreenMode = false;
        this.selectionConfig.isPreviewZoomEffect = false;
        this.selectionConfig.isOpenClickSound = false;
    }

    public PictureSelectionCameraModel setCompressEngine(CompressEngine engine) {
        if (PictureSelectionConfig.compressEngine != engine) {
            PictureSelectionConfig.compressEngine = engine;
            this.selectionConfig.isCompressEngine = true;
        } else {
            this.selectionConfig.isCompressEngine = false;
        }
        return this;
    }

    public PictureSelectionCameraModel setCropEngine(CropEngine engine) {
        if (PictureSelectionConfig.cropEngine != engine) {
            PictureSelectionConfig.cropEngine = engine;
        }
        return this;
    }

    public PictureSelectionCameraModel setSandboxFileEngine(SandboxFileEngine engine) {
        if (SdkVersionUtils.isQ() && PictureSelectionConfig.sandboxFileEngine != engine) {
            PictureSelectionConfig.sandboxFileEngine = engine;
            this.selectionConfig.isSandboxFileEngine = true;
        } else {
            this.selectionConfig.isSandboxFileEngine = false;
        }
        return this;
    }

    public PictureSelectionCameraModel setCameraInterceptListener(OnCameraInterceptListener listener) {
        PictureSelectionConfig.onCameraInterceptListener = listener;
        return this;
    }

    public PictureSelectionCameraModel setPermissionsInterceptListener(OnPermissionsInterceptListener listener) {
        PictureSelectionConfig.onPermissionsEventListener = listener;
        return this;
    }

    public PictureSelectionCameraModel setSelectLimitTipsListener(OnSelectLimitTipsListener listener) {
        PictureSelectionConfig.onSelectLimitTipsListener = listener;
        return this;
    }

    public PictureSelectionCameraModel isCameraForegroundService(boolean isForeground) {
        this.selectionConfig.isCameraForegroundService = isForeground;
        return this;
    }

    public PictureSelectionCameraModel setOfAllCameraType(int ofAllCameraType) {
        this.selectionConfig.ofAllCameraType = ofAllCameraType;
        return this;
    }

    public PictureSelectionCameraModel isOriginalControl(boolean isOriginalControl) {
        this.selectionConfig.isOriginalControl = isOriginalControl;
        this.selectionConfig.isCheckOriginalImage = isOriginalControl;
        return this;
    }

    @Deprecated
    public PictureSelectionCameraModel setVideoQuality(int videoQuality) {
        this.selectionConfig.videoQuality = videoQuality;
        return this;
    }

    public PictureSelectionCameraModel setSelectMaxFileSize(long fileKbSize) {
        this.selectionConfig.selectMaxFileSize = fileKbSize >= 0x100000L ? fileKbSize : fileKbSize * 1024L;
        return this;
    }

    public PictureSelectionCameraModel setSelectMinFileSize(long fileKbSize) {
        this.selectionConfig.selectMinFileSize = fileKbSize >= 0x100000L ? fileKbSize : fileKbSize * 1024L;
        return this;
    }

    public PictureSelectionCameraModel setCameraImageFormat(String imageFormat) {
        this.selectionConfig.cameraImageFormat = imageFormat;
        return this;
    }

    public PictureSelectionCameraModel setCameraImageFormatForQ(String imageFormat) {
        this.selectionConfig.cameraImageFormatForQ = imageFormat;
        return this;
    }

    public PictureSelectionCameraModel setCameraVideoFormat(String videoFormat) {
        this.selectionConfig.cameraVideoFormat = videoFormat;
        return this;
    }

    public PictureSelectionCameraModel setCameraVideoFormatForQ(String videoFormat) {
        this.selectionConfig.cameraVideoFormatForQ = videoFormat;
        return this;
    }

    public PictureSelectionCameraModel setRecordVideoMaxSecond(int maxSecond) {
        this.selectionConfig.recordVideoMaxSecond = maxSecond;
        return this;
    }

    public PictureSelectionCameraModel setRecordVideoMinSecond(int minSecond) {
        this.selectionConfig.recordVideoMinSecond = minSecond;
        return this;
    }

    public PictureSelectionCameraModel setSelectMaxDurationSecond(int maxDurationSecond) {
        this.selectionConfig.selectMaxDurationSecond = maxDurationSecond * 1000;
        return this;
    }

    public PictureSelectionCameraModel setSelectMinDurationSecond(int minDurationSecond) {
        this.selectionConfig.selectMinDurationSecond = minDurationSecond * 1000;
        return this;
    }

    public PictureSelectionCameraModel setOutputCameraDir(String outPutCameraDir) {
        this.selectionConfig.outPutCameraDir = outPutCameraDir;
        return this;
    }

    public PictureSelectionCameraModel setOutputAudioDir(String outPutAudioDir) {
        this.selectionConfig.outPutAudioDir = outPutAudioDir;
        return this;
    }

    public PictureSelectionCameraModel setOutputCameraImageFileName(String fileName) {
        this.selectionConfig.outPutCameraImageFileName = fileName;
        return this;
    }

    public PictureSelectionCameraModel setOutputCameraVideoFileName(String fileName) {
        this.selectionConfig.outPutCameraVideoFileName = fileName;
        return this;
    }

    public PictureSelectionCameraModel setOutputAudioFileName(String fileName) {
        this.selectionConfig.outPutAudioFileName = fileName;
        return this;
    }

    public PictureSelectionCameraModel setSelectedData(List<LocalMedia> selectedList) {
        if (selectedList == null) {
            return this;
        }
        if (this.selectionConfig.selectionMode == 1 && this.selectionConfig.isDirectReturnSingle) {
            SelectedManager.clearSelectResult();
        } else {
            SelectedManager.addAllSelectResult(new ArrayList<LocalMedia>(selectedList));
        }
        return this;
    }

    public PictureSelectionCameraModel isQuickCapture(boolean isQuickCapture) {
        this.selectionConfig.isQuickCapture = isQuickCapture;
        return this;
    }

    public PictureSelectionCameraModel isCameraAroundState(boolean isCameraAroundState) {
        this.selectionConfig.isCameraAroundState = isCameraAroundState;
        return this;
    }

    public PictureSelectionCameraModel isCameraRotateImage(boolean isCameraRotateImage) {
        this.selectionConfig.isCameraRotateImage = isCameraRotateImage;
        return this;
    }

    public void forResult() {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            this.selectionConfig.isResultListenerBack = false;
            this.selectionConfig.isActivityResultBack = true;
            FragmentManager fragmentManager = null;
            if (activity instanceof AppCompatActivity) {
                fragmentManager = ((AppCompatActivity)activity).getSupportFragmentManager();
            } else if (activity instanceof FragmentActivity) {
                fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            }
            if (fragmentManager == null) {
                throw new NullPointerException("FragmentManager cannot be null");
            }
            if (!(activity instanceof IBridgePictureBehavior)) {
                throw new NullPointerException("Use only camera openCamera mode,Activity or Fragment interface needs to be implemented " + IBridgePictureBehavior.class);
            }
            Fragment fragment = fragmentManager.findFragmentByTag(PictureOnlyCameraFragment.TAG);
            if (fragment != null) {
                fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
            }
            FragmentInjectManager.injectSystemRoomFragment(fragmentManager, PictureOnlyCameraFragment.TAG, PictureOnlyCameraFragment.newInstance());
        }
    }

    public void forResult(OnResultCallbackListener<LocalMedia> call) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            if (call == null) {
                throw new NullPointerException("OnResultCallbackListener cannot be null");
            }
            this.selectionConfig.isResultListenerBack = true;
            this.selectionConfig.isActivityResultBack = false;
            PictureSelectionConfig.onResultCallListener = call;
            FragmentManager fragmentManager = null;
            if (activity instanceof AppCompatActivity) {
                fragmentManager = ((AppCompatActivity)activity).getSupportFragmentManager();
            } else if (activity instanceof FragmentActivity) {
                fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            }
            if (fragmentManager == null) {
                throw new NullPointerException("FragmentManager cannot be null");
            }
            Fragment fragment = fragmentManager.findFragmentByTag(PictureOnlyCameraFragment.TAG);
            if (fragment != null) {
                fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
            }
            FragmentInjectManager.injectSystemRoomFragment(fragmentManager, PictureOnlyCameraFragment.TAG, PictureOnlyCameraFragment.newInstance());
        }
    }

    public PictureOnlyCameraFragment build() {
        Activity activity = this.selector.getActivity();
        if (activity == null) {
            throw new NullPointerException("Activity cannot be null");
        }
        if (!(activity instanceof IBridgePictureBehavior)) {
            throw new NullPointerException("Use only build PictureOnlyCameraFragment,Activity or Fragment interface needs to be implemented " + IBridgePictureBehavior.class);
        }
        this.selectionConfig.isResultListenerBack = false;
        this.selectionConfig.isActivityResultBack = true;
        PictureSelectionConfig.onResultCallListener = null;
        return new PictureOnlyCameraFragment();
    }

    public PictureOnlyCameraFragment buildLaunch(int containerViewId, OnResultCallbackListener<LocalMedia> call) {
        Activity activity = this.selector.getActivity();
        if (activity == null) {
            throw new NullPointerException("Activity cannot be null");
        }
        if (call == null) {
            throw new NullPointerException("OnResultCallbackListener cannot be null");
        }
        this.selectionConfig.isResultListenerBack = true;
        this.selectionConfig.isActivityResultBack = false;
        PictureSelectionConfig.onResultCallListener = call;
        FragmentManager fragmentManager = null;
        if (activity instanceof AppCompatActivity) {
            fragmentManager = ((AppCompatActivity)activity).getSupportFragmentManager();
        } else if (activity instanceof FragmentActivity) {
            fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
        }
        if (fragmentManager == null) {
            throw new NullPointerException("FragmentManager cannot be null");
        }
        PictureOnlyCameraFragment onlyCameraFragment = new PictureOnlyCameraFragment();
        Fragment fragment = fragmentManager.findFragmentByTag(onlyCameraFragment.getFragmentTag());
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
        }
        fragmentManager.beginTransaction().add(containerViewId, (Fragment)onlyCameraFragment, onlyCameraFragment.getFragmentTag()).addToBackStack(onlyCameraFragment.getFragmentTag()).commitAllowingStateLoss();
        return onlyCameraFragment;
    }

    public void forResultActivity(int requestCode) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            this.selectionConfig.isResultListenerBack = false;
            this.selectionConfig.isActivityResultBack = true;
            Intent intent = new Intent((Context)activity, PictureSelectorTransparentActivity.class);
            Fragment fragment = this.selector.getFragment();
            if (fragment != null) {
                fragment.startActivityForResult(intent, requestCode);
            } else {
                activity.startActivityForResult(intent, requestCode);
            }
            activity.overridePendingTransition(R.anim.ps_anim_fade_in, 0);
        }
    }

    public void forResultActivity(ActivityResultLauncher<Intent> launcher) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            if (launcher == null) {
                throw new NullPointerException("ActivityResultLauncher cannot be null");
            }
            this.selectionConfig.isResultListenerBack = false;
            this.selectionConfig.isActivityResultBack = true;
            Intent intent = new Intent((Context)activity, PictureSelectorTransparentActivity.class);
            launcher.launch((Object)intent);
            activity.overridePendingTransition(R.anim.ps_anim_fade_in, 0);
        }
    }

    public void forResultActivity(OnResultCallbackListener<LocalMedia> call) {
        if (!DoubleUtils.isFastDoubleClick()) {
            Activity activity = this.selector.getActivity();
            if (activity == null) {
                throw new NullPointerException("Activity cannot be null");
            }
            if (call == null) {
                throw new NullPointerException("OnResultCallbackListener cannot be null");
            }
            this.selectionConfig.isResultListenerBack = true;
            this.selectionConfig.isActivityResultBack = false;
            PictureSelectionConfig.onResultCallListener = call;
            Intent intent = new Intent((Context)activity, PictureSelectorTransparentActivity.class);
            activity.startActivity(intent);
            activity.overridePendingTransition(R.anim.ps_anim_fade_in, 0);
        }
    }
}

