/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureAlbumAdapter;
import com.luck.picture.lib.decoration.WrapContentLinearLayoutManager;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.interfaces.OnAlbumItemClickListener;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.SdkVersionUtils;
import java.util.List;

public class AlbumListPopWindow
extends PopupWindow {
    private static final int ALBUM_MAX_COUNT = 8;
    private final Context mContext;
    private View windMask;
    private RecyclerView mRecyclerView;
    private boolean isDismiss = false;
    private int windowMaxHeight;
    private PictureAlbumAdapter mAdapter;
    private OnPopupWindowStatusListener windowStatusListener;

    public AlbumListPopWindow(Context context) {
        this.mContext = context;
        this.setContentView(LayoutInflater.from((Context)context).inflate(R.layout.ps_window_folder, null));
        this.setWidth(-1);
        this.setHeight(-2);
        this.setAnimationStyle(R.style.PictureThemeWindowStyle);
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.update();
        this.initViews();
    }

    private void initViews() {
        this.windowMaxHeight = (int)((double)DensityUtil.getScreenHeight(this.mContext) * 0.6);
        this.mRecyclerView = (RecyclerView)this.getContentView().findViewById(R.id.folder_list);
        this.windMask = this.getContentView().findViewById(R.id.rootViewBg);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new WrapContentLinearLayoutManager(this.mContext));
        this.mAdapter = new PictureAlbumAdapter();
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.windMask.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AlbumListPopWindow.this.dismiss();
            }
        });
        this.getContentView().findViewById(R.id.rootView).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SdkVersionUtils.isMinM()) {
                    AlbumListPopWindow.this.dismiss();
                }
            }
        });
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void bindAlbumData(List<LocalMediaFolder> list) {
        this.mAdapter.bindAlbumData(list);
        this.mAdapter.notifyDataSetChanged();
        ViewGroup.LayoutParams lp = this.mRecyclerView.getLayoutParams();
        lp.height = list.size() > 8 ? this.windowMaxHeight : -2;
    }

    public List<LocalMediaFolder> getAlbumList() {
        return this.mAdapter.getAlbumList();
    }

    public LocalMediaFolder getFolder(int position) {
        return this.mAdapter.getAlbumList().size() > 0 && position < this.mAdapter.getAlbumList().size() ? this.mAdapter.getAlbumList().get(position) : null;
    }

    public int getFirstAlbumImageCount() {
        return this.getFolderCount() > 0 ? this.getFolder(0).getFolderTotalNum() : 0;
    }

    public int getFolderCount() {
        return this.mAdapter.getAlbumList().size();
    }

    public void setOnIBridgeAlbumWidget(OnAlbumItemClickListener listener) {
        this.mAdapter.setOnIBridgeAlbumWidget(listener);
    }

    public static AlbumListPopWindow buildPopWindow(Context context) {
        return new AlbumListPopWindow(context);
    }

    public void showAsDropDown(View anchor) {
        if (this.getAlbumList() == null || this.getAlbumList().size() == 0) {
            return;
        }
        if (SdkVersionUtils.isN()) {
            int[] location = new int[2];
            anchor.getLocationInWindow(location);
            this.showAtLocation(anchor, 0, 0, location[1] + anchor.getHeight());
        } else {
            super.showAsDropDown(anchor);
        }
        this.isDismiss = false;
        if (this.windowStatusListener != null) {
            this.windowStatusListener.onShowPopupWindow();
        }
        this.windMask.animate().alpha(1.0f).setDuration(250L).setStartDelay(250L).start();
        this.changeSelectedAlbumStyle();
    }

    public void changeSelectedAlbumStyle() {
        List<LocalMediaFolder> folders = this.mAdapter.getAlbumList();
        block0: for (int i = 0; i < folders.size(); ++i) {
            LocalMediaFolder folder = folders.get(i);
            folder.setSelectTag(false);
            this.mAdapter.notifyItemChanged(i);
            for (int j = 0; j < SelectedManager.getSelectCount(); ++j) {
                LocalMedia media = SelectedManager.getSelectedResult().get(j);
                if (!TextUtils.equals((CharSequence)folder.getFolderName(), (CharSequence)media.getParentFolderName()) && folder.getBucketId() != -1L) continue;
                folder.setSelectTag(true);
                this.mAdapter.notifyItemChanged(i);
                continue block0;
            }
        }
    }

    public void dismiss() {
        if (this.isDismiss) {
            return;
        }
        this.windMask.animate().alpha(0.0f).setDuration(50L).start();
        if (this.windowStatusListener != null) {
            this.windowStatusListener.onDismissPopupWindow();
        }
        this.isDismiss = true;
        AlbumListPopWindow.super.dismiss();
        this.isDismiss = false;
    }

    public void setOnPopupWindowStatusListener(OnPopupWindowStatusListener listener) {
        this.windowStatusListener = listener;
    }

    public static interface OnPopupWindowStatusListener {
        public void onShowPopupWindow();

        public void onDismissPopupWindow();
    }
}

