/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.loader;

import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.interfaces.OnQueryAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryAllAlbumListener;
import com.luck.picture.lib.loader.IBridgeMediaLoader;
import com.luck.picture.lib.loader.SandboxFileLoader;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.SortUtils;
import java.util.ArrayList;
import java.util.List;

public final class LocalMediaLoader
extends IBridgeMediaLoader {
    private static String getSelectionArgsForVideoOrAudioMediaCondition(String sizeCondition, String queryMimeCondition) {
        return "media_type=?" + queryMimeCondition + " AND " + sizeCondition;
    }

    private static String getSelectionArgsForAllMediaCondition(String timeCondition, String sizeCondition, String queryMimeCondition) {
        return "(media_type=?" + queryMimeCondition + " OR " + "media_type" + "=? AND " + timeCondition + ") AND " + sizeCondition;
    }

    private static String getSelectionArgsForImageMediaCondition(String sizeCondition, String queryMimeCondition) {
        return "media_type=?" + queryMimeCondition + " AND " + sizeCondition;
    }

    public LocalMediaLoader(Context context, PictureSelectionConfig config) {
        this.mContext = context;
        this.config = config;
    }

    @Override
    public void loadOnlyInAppDirAllMedia(final OnQueryAlbumListener<LocalMediaFolder> listener) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<LocalMediaFolder>(){

            @Override
            public LocalMediaFolder doInBackground() {
                return SandboxFileLoader.loadInAppSandboxFolderFile(LocalMediaLoader.this.mContext, LocalMediaLoader.this.config.sandboxDir);
            }

            @Override
            public void onSuccess(LocalMediaFolder result) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                if (listener != null) {
                    listener.onComplete(result);
                }
            }
        });
    }

    @Override
    public void loadAllAlbum(final OnQueryAllAlbumListener<LocalMediaFolder> query) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<List<LocalMediaFolder>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<LocalMediaFolder> doInBackground() {
                ArrayList<LocalMediaFolder> imageFolders = new ArrayList<LocalMediaFolder>();
                Cursor data = LocalMediaLoader.this.mContext.getContentResolver().query(IBridgeMediaLoader.QUERY_URI, IBridgeMediaLoader.PROJECTION, LocalMediaLoader.this.getSelection(), LocalMediaLoader.this.getSelectionArgs(), LocalMediaLoader.this.getSortOrder());
                try {
                    if (data != null) {
                        LocalMediaFolder allImageFolder = new LocalMediaFolder();
                        ArrayList<LocalMedia> latelyImages = new ArrayList<LocalMedia>();
                        int count = data.getCount();
                        if (count > 0) {
                            int idColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[0]);
                            int dataColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[1]);
                            int mimeTypeColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[2]);
                            int widthColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[3]);
                            int heightColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[4]);
                            int durationColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[5]);
                            int sizeColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[6]);
                            int folderNameColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[7]);
                            int fileNameColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[8]);
                            int bucketIdColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[9]);
                            int dateAddedColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[10]);
                            data.moveToFirst();
                            do {
                                String url;
                                long id2 = data.getLong(idColumn);
                                String mimeType = data.getString(mimeTypeColumn);
                                mimeType = TextUtils.isEmpty((CharSequence)mimeType) ? PictureMimeType.ofJPEG() : mimeType;
                                String absolutePath = data.getString(dataColumn);
                                String string2 = url = SdkVersionUtils.isQ() ? MediaUtils.getRealPathUri(id2, mimeType) : absolutePath;
                                if (mimeType.endsWith("image/*")) {
                                    mimeType = MediaUtils.getMimeTypeFromMediaUrl(absolutePath);
                                    if (!LocalMediaLoader.this.config.isGif && PictureMimeType.isHasGif(mimeType)) continue;
                                }
                                if (mimeType.endsWith("image/*") || !LocalMediaLoader.this.config.isWebp && mimeType.startsWith(PictureMimeType.ofWEBP()) || !LocalMediaLoader.this.config.isBmp && mimeType.startsWith(PictureMimeType.ofBMP())) continue;
                                int width = data.getInt(widthColumn);
                                int height = data.getInt(heightColumn);
                                long duration = data.getLong(durationColumn);
                                long size = data.getLong(sizeColumn);
                                String folderName = data.getString(folderNameColumn);
                                String fileName = data.getString(fileNameColumn);
                                long bucketId = data.getLong(bucketIdColumn);
                                if ((PictureMimeType.isHasVideo(mimeType) || PictureMimeType.isHasAudio(mimeType)) && (LocalMediaLoader.this.config.filterVideoMinSecond > 0 && duration < (long)LocalMediaLoader.this.config.filterVideoMinSecond || LocalMediaLoader.this.config.filterVideoMaxSecond > 0 && duration > (long)LocalMediaLoader.this.config.filterVideoMaxSecond || duration == 0L || size <= 0L)) continue;
                                LocalMedia image = LocalMedia.parseLocalMedia(id2, url, absolutePath, fileName, folderName, duration, LocalMediaLoader.this.config.chooseMode, mimeType, width, height, size, bucketId, data.getLong(dateAddedColumn));
                                LocalMediaFolder folder = LocalMediaLoader.this.getImageFolder(url, mimeType, folderName, imageFolders);
                                folder.setBucketId(image.getBucketId());
                                ArrayList<LocalMedia> images = folder.getData();
                                images.add(image);
                                folder.setFolderTotalNum(folder.getFolderTotalNum() + 1);
                                folder.setBucketId(image.getBucketId());
                                latelyImages.add(image);
                                int imageNum = allImageFolder.getFolderTotalNum();
                                allImageFolder.setFolderTotalNum(imageNum + 1);
                            } while (data.moveToNext());
                            LocalMediaFolder selfFolder = SandboxFileLoader.loadInAppSandboxFolderFile(LocalMediaLoader.this.mContext, LocalMediaLoader.this.config.sandboxDir);
                            if (selfFolder != null) {
                                imageFolders.add(selfFolder);
                                allImageFolder.setFolderTotalNum(allImageFolder.getFolderTotalNum() + selfFolder.getFolderTotalNum());
                                allImageFolder.setData(selfFolder.getData());
                                latelyImages.addAll(0, selfFolder.getData());
                                if (60 > selfFolder.getFolderTotalNum()) {
                                    if (latelyImages.size() > 60) {
                                        SortUtils.sortLocalMediaAddedTime(latelyImages.subList(0, 60));
                                    } else {
                                        SortUtils.sortLocalMediaAddedTime(latelyImages);
                                    }
                                }
                            }
                            if (latelyImages.size() > 0) {
                                SortUtils.sortFolder(imageFolders);
                                imageFolders.add(0, allImageFolder);
                                allImageFolder.setFirstImagePath(((LocalMedia)latelyImages.get(0)).getPath());
                                allImageFolder.setFirstMimeType(((LocalMedia)latelyImages.get(0)).getMimeType());
                                String title = LocalMediaLoader.this.config.chooseMode == SelectMimeType.ofAudio() ? LocalMediaLoader.this.mContext.getString(R.string.ps_all_audio) : LocalMediaLoader.this.mContext.getString(R.string.ps_camera_roll);
                                allImageFolder.setFolderName(title);
                                allImageFolder.setBucketId(-1L);
                                allImageFolder.setData(latelyImages);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (data != null && !data.isClosed()) {
                        data.close();
                    }
                }
                return imageFolders;
            }

            @Override
            public void onSuccess(List<LocalMediaFolder> result) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                if (query != null) {
                    query.onComplete(result);
                }
            }
        });
    }

    private String getSelection() {
        String durationCondition = this.getDurationCondition();
        String fileSizeCondition = this.getFileSizeCondition();
        String queryMimeCondition = this.getQueryMimeCondition();
        switch (this.config.chooseMode) {
            case 0: {
                return LocalMediaLoader.getSelectionArgsForAllMediaCondition(durationCondition, fileSizeCondition, queryMimeCondition);
            }
            case 1: {
                return LocalMediaLoader.getSelectionArgsForImageMediaCondition(fileSizeCondition, queryMimeCondition);
            }
            case 2: {
                return LocalMediaLoader.getSelectionArgsForVideoOrAudioMediaCondition(fileSizeCondition, queryMimeCondition);
            }
            case 3: {
                return LocalMediaLoader.getSelectionArgsForVideoOrAudioMediaCondition(durationCondition, queryMimeCondition);
            }
        }
        return null;
    }

    private String[] getSelectionArgs() {
        switch (this.config.chooseMode) {
            case 0: {
                return LocalMediaLoader.getSelectionArgsForAllMediaType();
            }
            case 1: {
                return LocalMediaLoader.getSelectionArgsForSingleMediaType(1);
            }
            case 2: {
                return LocalMediaLoader.getSelectionArgsForSingleMediaType(3);
            }
            case 3: {
                return LocalMediaLoader.getSelectionArgsForSingleMediaType(2);
            }
        }
        return null;
    }

    private LocalMediaFolder getImageFolder(String firstPath, String firstMimeType, String folderName, List<LocalMediaFolder> imageFolders) {
        for (LocalMediaFolder folder : imageFolders) {
            String name = folder.getFolderName();
            if (TextUtils.isEmpty((CharSequence)name) || !TextUtils.equals((CharSequence)name, (CharSequence)folderName)) continue;
            return folder;
        }
        LocalMediaFolder newFolder = new LocalMediaFolder();
        newFolder.setFolderName(folderName);
        newFolder.setFirstImagePath(firstPath);
        newFolder.setFirstMimeType(firstMimeType);
        imageFolders.add(newFolder);
        return newFolder;
    }
}

