/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatTextView;
import com.luck.picture.lib.R;

public class MediumBoldTextView
extends AppCompatTextView {
    private float mStrokeWidth = 0.6f;

    public MediumBoldTextView(Context context) {
        this(context, null);
    }

    public MediumBoldTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediumBoldTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PictureMediumBoldTextView, defStyleAttr, 0);
        this.mStrokeWidth = a.getFloat(R.styleable.PictureMediumBoldTextView_stroke_Width, this.mStrokeWidth);
        a.recycle();
    }

    protected void onDraw(Canvas canvas) {
        TextPaint paint = this.getPaint();
        if (paint.getStrokeWidth() != this.mStrokeWidth) {
            paint.setStrokeWidth(this.mStrokeWidth);
            paint.setStyle(Paint.Style.FILL_AND_STROKE);
        }
        super.onDraw(canvas);
    }

    public void setStrokeWidth(float mStrokeWidth) {
        this.mStrokeWidth = mStrokeWidth;
        this.invalidate();
    }
}

