/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import com.luck.picture.lib.widget.SlideSelectTouchListener;
import java.util.HashSet;
import java.util.Set;

public class SlideSelectionHandler
implements SlideSelectTouchListener.OnAdvancedSlideSelectListener {
    private final ISelectionHandler mSelectionHandler;
    private ISelectionStartFinishedListener mStartFinishedListener;
    private HashSet<Integer> mOriginalSelection;

    public SlideSelectionHandler(ISelectionHandler selectionHandler) {
        this.mSelectionHandler = selectionHandler;
        this.mStartFinishedListener = null;
    }

    public SlideSelectionHandler withStartFinishedListener(ISelectionStartFinishedListener startFinishedListener) {
        this.mStartFinishedListener = startFinishedListener;
        return this;
    }

    @Override
    public void onSelectionStarted(int start) {
        this.mOriginalSelection = new HashSet();
        Set<Integer> selected = this.mSelectionHandler.getSelection();
        if (selected != null) {
            this.mOriginalSelection.addAll(selected);
        }
        boolean isFirstSelected = this.mOriginalSelection.contains(start);
        this.mSelectionHandler.changeSelection(start, start, !this.mOriginalSelection.contains(start), true);
        if (this.mStartFinishedListener != null) {
            this.mStartFinishedListener.onSelectionStarted(start, isFirstSelected);
        }
    }

    @Override
    public void onSelectionFinished(int end) {
        this.mOriginalSelection = null;
        if (this.mStartFinishedListener != null) {
            this.mStartFinishedListener.onSelectionFinished(end);
        }
    }

    @Override
    public void onSelectChange(int start, int end, boolean isSelected) {
        for (int i = start; i <= end; ++i) {
            this.checkedChangeSelection(i, i, isSelected != this.mOriginalSelection.contains(i));
        }
    }

    private void checkedChangeSelection(int start, int end, boolean newSelectionState) {
        this.mSelectionHandler.changeSelection(start, end, newSelectionState, false);
    }

    public static interface ISelectionStartFinishedListener {
        public void onSelectionStarted(int var1, boolean var2);

        public void onSelectionFinished(int var1);
    }

    public static interface ISelectionHandler {
        public Set<Integer> getSelection();

        public void changeSelection(int var1, int var2, boolean var3, boolean var4);
    }
}

