/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.style.BottomNavBarStyle;
import com.luck.picture.lib.style.PictureSelectorStyle;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.utils.StyleUtils;
import com.luck.picture.lib.utils.ValueOf;

public class CompleteSelectView
extends LinearLayout {
    private TextView tvSelectNum;
    private TextView tvComplete;
    private Animation numberChangeAnimation;
    private PictureSelectionConfig config;

    public CompleteSelectView(Context context) {
        super(context);
        this.init();
    }

    public CompleteSelectView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CompleteSelectView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.inflateLayout();
        this.setOrientation(0);
        this.tvSelectNum = (TextView)this.findViewById(R.id.ps_tv_select_num);
        this.tvComplete = (TextView)this.findViewById(R.id.ps_tv_complete);
        this.setGravity(16);
        this.numberChangeAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ps_anim_modal_in);
        this.config = PictureSelectionConfig.getInstance();
    }

    protected void inflateLayout() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.ps_complete_selected_layout, (ViewGroup)this);
    }

    public void setCompleteSelectViewStyle() {
        BottomNavBarStyle bottomBarStyle;
        int selectNormalTextColor;
        int selectNormalTextSize;
        String selectNormalText;
        PictureSelectorStyle selectorStyle = PictureSelectionConfig.selectorStyle;
        SelectMainStyle selectMainStyle = selectorStyle.getSelectMainStyle();
        if (StyleUtils.checkStyleValidity(selectMainStyle.getSelectNormalBackgroundResources())) {
            this.setBackgroundResource(selectMainStyle.getSelectNormalBackgroundResources());
        }
        if (StyleUtils.checkTextValidity(selectNormalText = selectMainStyle.getSelectNormalText())) {
            if (StyleUtils.checkTextTwoFormatValidity(selectNormalText)) {
                this.tvComplete.setText((CharSequence)String.format(selectNormalText, SelectedManager.getSelectCount(), this.config.maxSelectNum));
            } else {
                this.tvComplete.setText((CharSequence)selectNormalText);
            }
        }
        if (StyleUtils.checkSizeValidity(selectNormalTextSize = selectMainStyle.getSelectNormalTextSize())) {
            this.tvComplete.setTextSize((float)selectNormalTextSize);
        }
        if (StyleUtils.checkStyleValidity(selectNormalTextColor = selectMainStyle.getSelectNormalTextColor())) {
            this.tvComplete.setTextColor(selectNormalTextColor);
        }
        if ((bottomBarStyle = selectorStyle.getBottomBarStyle()).isCompleteCountTips()) {
            int selectNumTextColor;
            int selectNumTextSize;
            int selectNumRes = bottomBarStyle.getBottomSelectNumResources();
            if (StyleUtils.checkStyleValidity(selectNumRes)) {
                this.tvSelectNum.setBackgroundResource(selectNumRes);
            }
            if (StyleUtils.checkSizeValidity(selectNumTextSize = bottomBarStyle.getBottomSelectNumTextSize())) {
                this.tvSelectNum.setTextSize((float)selectNumTextSize);
            }
            if (StyleUtils.checkStyleValidity(selectNumTextColor = bottomBarStyle.getBottomSelectNumTextColor())) {
                this.tvSelectNum.setTextColor(selectNumTextColor);
            }
        }
    }

    public void setSelectedChange(boolean isPreview) {
        PictureSelectorStyle selectorStyle = PictureSelectionConfig.selectorStyle;
        SelectMainStyle selectMainStyle = selectorStyle.getSelectMainStyle();
        if (SelectedManager.getSelectCount() > 0) {
            int selectTextColor;
            this.setEnabled(true);
            int selectBackground = selectMainStyle.getSelectBackgroundResources();
            if (StyleUtils.checkStyleValidity(selectBackground)) {
                this.setBackgroundResource(selectBackground);
            } else {
                this.setBackgroundResource(R.drawable.ps_ic_trans_1px);
            }
            String selectText = selectMainStyle.getSelectText();
            if (StyleUtils.checkTextValidity(selectText)) {
                if (StyleUtils.checkTextTwoFormatValidity(selectText)) {
                    this.tvComplete.setText((CharSequence)String.format(selectText, SelectedManager.getSelectCount(), this.config.maxSelectNum));
                } else {
                    this.tvComplete.setText((CharSequence)selectText);
                }
            } else {
                this.tvComplete.setText((CharSequence)this.getContext().getString(R.string.ps_completed));
            }
            int selectTextSize = selectMainStyle.getSelectTextSize();
            if (StyleUtils.checkSizeValidity(selectTextSize)) {
                this.tvComplete.setTextSize((float)selectTextSize);
            }
            if (StyleUtils.checkStyleValidity(selectTextColor = selectMainStyle.getSelectTextColor())) {
                this.tvComplete.setTextColor(selectTextColor);
            } else {
                this.tvComplete.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ps_color_fa632d));
            }
            if (selectorStyle.getBottomBarStyle().isCompleteCountTips()) {
                if (this.tvSelectNum.getVisibility() == 8 || this.tvSelectNum.getVisibility() == 4) {
                    this.tvSelectNum.setVisibility(0);
                }
                if (!TextUtils.equals((CharSequence)ValueOf.toString(SelectedManager.getSelectCount()), (CharSequence)this.tvSelectNum.getText())) {
                    this.tvSelectNum.setText((CharSequence)ValueOf.toString(SelectedManager.getSelectCount()));
                    if (PictureSelectionConfig.onSelectAnimListener != null) {
                        PictureSelectionConfig.onSelectAnimListener.onSelectAnim((View)this.tvSelectNum);
                    } else {
                        this.tvSelectNum.startAnimation(this.numberChangeAnimation);
                    }
                }
            } else {
                this.tvSelectNum.setVisibility(8);
            }
        } else {
            if (isPreview && selectMainStyle.isCompleteSelectRelativeTop()) {
                this.setEnabled(true);
                int selectBackground = selectMainStyle.getSelectBackgroundResources();
                if (StyleUtils.checkStyleValidity(selectBackground)) {
                    this.setBackgroundResource(selectBackground);
                } else {
                    this.setBackgroundResource(R.drawable.ps_ic_trans_1px);
                }
                int selectTextColor = selectMainStyle.getSelectTextColor();
                if (StyleUtils.checkStyleValidity(selectTextColor)) {
                    this.tvComplete.setTextColor(selectTextColor);
                } else {
                    this.tvComplete.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ps_color_9b));
                }
            } else {
                this.setEnabled(this.config.isEmptyResultReturn);
                int normalBackground = selectMainStyle.getSelectNormalBackgroundResources();
                if (StyleUtils.checkStyleValidity(normalBackground)) {
                    this.setBackgroundResource(normalBackground);
                } else {
                    this.setBackgroundResource(R.drawable.ps_ic_trans_1px);
                }
                int normalTextColor = selectMainStyle.getSelectNormalTextColor();
                if (StyleUtils.checkStyleValidity(normalTextColor)) {
                    this.tvComplete.setTextColor(normalTextColor);
                } else {
                    this.tvComplete.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ps_color_9b));
                }
            }
            this.tvSelectNum.setVisibility(8);
            String selectNormalText = selectMainStyle.getSelectNormalText();
            if (StyleUtils.checkTextValidity(selectNormalText)) {
                if (StyleUtils.checkTextTwoFormatValidity(selectNormalText)) {
                    this.tvComplete.setText((CharSequence)String.format(selectNormalText, SelectedManager.getSelectCount(), this.config.maxSelectNum));
                } else {
                    this.tvComplete.setText((CharSequence)selectNormalText);
                }
            } else {
                this.tvComplete.setText((CharSequence)this.getContext().getString(R.string.ps_please_select));
            }
            int normalTextSize = selectMainStyle.getSelectNormalTextSize();
            if (StyleUtils.checkSizeValidity(normalTextSize)) {
                this.tvComplete.setTextSize((float)normalTextSize);
            }
        }
    }
}

