/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.magical;

import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.magical.ViewParams;
import java.util.ArrayList;
import java.util.List;

public class BuildRecycleItemViewParams {
    private static final List<ViewParams> viewParams = new ArrayList<ViewParams>();

    public static void clear() {
        if (viewParams.size() > 0) {
            viewParams.clear();
        }
    }

    public static ViewParams getItemViewParams(int position) {
        return viewParams.size() > position ? viewParams.get(position) : null;
    }

    public static void generateViewParams(ViewGroup viewGroup, int statusBarHeight) {
        int lastPos;
        int firstPos;
        int totalCount;
        int childCount;
        ArrayList<View> views = new ArrayList<View>();
        if (viewGroup instanceof RecyclerView) {
            childCount = ((RecyclerView)viewGroup).getChildCount();
        } else if (viewGroup instanceof ListView) {
            childCount = ((ListView)viewGroup).getChildCount();
        } else {
            throw new IllegalArgumentException(viewGroup.getClass().getCanonicalName() + " Must be " + RecyclerView.class + " or " + ListView.class);
        }
        for (int i = 0; i < childCount; ++i) {
            View view = viewGroup.getChildAt(i);
            if (view == null) continue;
            views.add(view);
        }
        if (viewGroup instanceof RecyclerView) {
            GridLayoutManager layoutManager = (GridLayoutManager)((RecyclerView)viewGroup).getLayoutManager();
            if (layoutManager == null) {
                return;
            }
            totalCount = layoutManager.getItemCount();
            firstPos = layoutManager.findFirstVisibleItemPosition();
            lastPos = layoutManager.findLastVisibleItemPosition();
        } else {
            ListAdapter listAdapter = ((ListView)viewGroup).getAdapter();
            if (listAdapter == null) {
                return;
            }
            totalCount = listAdapter.getCount();
            firstPos = ((ListView)viewGroup).getFirstVisiblePosition();
            lastPos = ((ListView)viewGroup).getLastVisiblePosition();
        }
        lastPos = lastPos > totalCount ? totalCount - 1 : lastPos;
        BuildRecycleItemViewParams.fillPlaceHolder(views, totalCount, firstPos, lastPos);
        viewParams.clear();
        for (int i = 0; i < views.size(); ++i) {
            View view = (View)views.get(i);
            ViewParams viewParam = new ViewParams();
            if (view == null) {
                viewParam.setLeft(0);
                viewParam.setTop(0);
                viewParam.setWidth(0);
                viewParam.setHeight(0);
            } else {
                int[] location = new int[2];
                view.getLocationOnScreen(location);
                viewParam.setLeft(location[0]);
                viewParam.setTop(location[1] - statusBarHeight);
                viewParam.setWidth(view.getWidth());
                viewParam.setHeight(view.getHeight());
            }
            viewParams.add(viewParam);
        }
    }

    private static void fillPlaceHolder(List<View> originImageList, int totalCount, int firstPos, int lastPos) {
        int i;
        if (firstPos > 0) {
            for (i = firstPos; i >= 1; --i) {
                originImageList.add(0, null);
            }
        }
        if (lastPos < totalCount) {
            for (i = totalCount - 1 - lastPos; i >= 1; --i) {
                originImageList.add(null);
            }
        }
    }
}

