/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.permissions;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;

public class PermissionUtil {
    public static final String ACTION_MANAGE_ALL_FILES_ACCESS_PERMISSION = "android.settings.MANAGE_ALL_FILES_ACCESS_PERMISSION";

    public static boolean hasPermissions(@NonNull Context context, String ... perms) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        for (String perm : perms) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)perm) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllGranted(int[] grantResults) {
        boolean isAllGranted = true;
        if (grantResults.length > 0) {
            for (int grant : grantResults) {
                if (grant == 0) continue;
                isAllGranted = false;
                break;
            }
        } else {
            isAllGranted = false;
        }
        return isAllGranted;
    }

    public static void goIntentSetting(Fragment fragment, int requestCode) {
        try {
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
            Uri uri = Uri.fromParts((String)"package", (String)fragment.getActivity().getPackageName(), null);
            intent.setData(uri);
            fragment.startActivityForResult(intent, requestCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

