/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.luck.picture.lib.config.PictureMimeType;
import java.io.IOException;

public class MediaPlayerView
extends FrameLayout
implements SurfaceHolder.Callback {
    private MediaPlayer mediaPlayer;
    private VideoSurfaceView surfaceView;

    public MediaPlayerView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public MediaPlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MediaPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.surfaceView = new VideoSurfaceView(this.getContext());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        layoutParams.gravity = 17;
        this.surfaceView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addView((View)this.surfaceView);
        SurfaceHolder surfaceHolder = this.surfaceView.getHolder();
        surfaceHolder.setFormat(-2);
        surfaceHolder.addCallback((SurfaceHolder.Callback)this);
    }

    public MediaPlayer initMediaPlayer() {
        if (this.mediaPlayer == null) {
            this.mediaPlayer = new MediaPlayer();
        }
        this.mediaPlayer.setOnVideoSizeChangedListener(new MediaPlayer.OnVideoSizeChangedListener(){

            public void onVideoSizeChanged(MediaPlayer mediaPlayer, int width, int height) {
                MediaPlayerView.this.surfaceView.adjustVideoSize(mediaPlayer.getVideoWidth(), mediaPlayer.getVideoHeight());
            }
        });
        return this.mediaPlayer;
    }

    public MediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public void start(String path) {
        try {
            if (PictureMimeType.isContent(path)) {
                this.mediaPlayer.setDataSource(this.getContext(), Uri.parse((String)path));
            } else {
                this.mediaPlayer.setDataSource(path);
            }
            this.mediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void surfaceCreated(@NonNull SurfaceHolder holder) {
        this.mediaPlayer.setAudioStreamType(3);
        this.mediaPlayer.setDisplay(holder);
    }

    public void surfaceChanged(@NonNull SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(@NonNull SurfaceHolder holder) {
    }

    public void clearCanvas() {
        this.surfaceView.getHolder().setFormat(-1);
        this.surfaceView.getHolder().setFormat(-2);
    }

    public void release() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.release();
            this.mediaPlayer.setOnPreparedListener(null);
            this.mediaPlayer.setOnCompletionListener(null);
            this.mediaPlayer.setOnErrorListener(null);
            this.mediaPlayer = null;
        }
    }

    public static class VideoSurfaceView
    extends SurfaceView {
        private int videoWidth;
        private int videoHeight;

        public VideoSurfaceView(Context context) {
            this(context, null);
        }

        public VideoSurfaceView(Context context, AttributeSet attrs) {
            this(context, attrs, 0);
        }

        public VideoSurfaceView(Context context, AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
        }

        public void adjustVideoSize(int videoWidth, int videoHeight) {
            if (videoWidth == 0 || videoHeight == 0) {
                return;
            }
            this.videoWidth = videoWidth;
            this.videoHeight = videoHeight;
            this.getHolder().setFixedSize(videoWidth, videoHeight);
            this.requestLayout();
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int width = VideoSurfaceView.getDefaultSize((int)this.videoWidth, (int)widthMeasureSpec);
            int height = VideoSurfaceView.getDefaultSize((int)this.videoHeight, (int)heightMeasureSpec);
            if (this.videoWidth > 0 && this.videoHeight > 0) {
                int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
                int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
                int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
                if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                    height = heightSpecSize;
                    width = widthSpecSize;
                    if (this.videoWidth * height < width * this.videoHeight) {
                        width = height * this.videoWidth / this.videoHeight;
                    } else if (this.videoWidth * height > width * this.videoHeight) {
                        height = width * this.videoHeight / this.videoWidth;
                    }
                } else if (widthSpecMode == 0x40000000) {
                    width = widthSpecSize;
                    height = width * this.videoHeight / this.videoWidth;
                    if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                        height = heightSpecSize;
                    }
                } else if (heightSpecMode == 0x40000000) {
                    height = heightSpecSize;
                    width = height * this.videoWidth / this.videoHeight;
                    if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                        width = widthSpecSize;
                    }
                } else {
                    width = this.videoWidth;
                    height = this.videoHeight;
                    if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                        height = heightSpecSize;
                        width = height * this.videoWidth / this.videoHeight;
                    }
                    if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                        width = widthSpecSize;
                        height = width * this.videoHeight / this.videoWidth;
                    }
                }
            }
            this.setMeasuredDimension(width, height);
        }
    }
}

