/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.RelativeLayout;
import com.luck.picture.lib.R;

public class RoundCornerRelativeLayout
extends RelativeLayout {
    private final Path path;
    private final float cornerSize;
    private final boolean isTopNormal;
    private final boolean isBottomNormal;
    private final RectF mRect = new RectF();

    public RoundCornerRelativeLayout(Context context) {
        this(context, null);
    }

    public RoundCornerRelativeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundCornerRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PictureRoundCornerRelativeLayout, defStyleAttr, 0);
        this.cornerSize = a.getDimension(R.styleable.PictureRoundCornerRelativeLayout_psCorners, 0.0f);
        this.isTopNormal = a.getBoolean(R.styleable.PictureRoundCornerRelativeLayout_psTopNormal, false);
        this.isBottomNormal = a.getBoolean(R.styleable.PictureRoundCornerRelativeLayout_psBottomNormal, false);
        a.recycle();
        this.path = new Path();
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        this.path.reset();
        this.mRect.right = w;
        this.mRect.bottom = h;
        if (!this.isTopNormal && !this.isBottomNormal) {
            this.path.addRoundRect(this.mRect, this.cornerSize, this.cornerSize, Path.Direction.CW);
        } else {
            float[] cornerRadii;
            if (this.isTopNormal) {
                cornerRadii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, this.cornerSize, this.cornerSize, this.cornerSize, this.cornerSize};
                this.path.addRoundRect(this.mRect, cornerRadii, Path.Direction.CW);
            }
            if (this.isBottomNormal) {
                cornerRadii = new float[]{this.cornerSize, this.cornerSize, this.cornerSize, this.cornerSize, 0.0f, 0.0f, 0.0f, 0.0f};
                this.path.addRoundRect(this.mRect, cornerRadii, Path.Direction.CW);
            }
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        canvas.save();
        canvas.clipPath(this.path);
        super.dispatchDraw(canvas);
        canvas.restore();
    }
}

