/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.BaseRecyclerMediaHolder;
import com.luck.picture.lib.config.InjectResourceSource;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.entity.LocalMedia;
import java.util.ArrayList;

public class PictureImageGridAdapter
extends RecyclerView.Adapter<BaseRecyclerMediaHolder> {
    public static final int ADAPTER_TYPE_CAMERA = 1;
    public static final int ADAPTER_TYPE_IMAGE = 2;
    public static final int ADAPTER_TYPE_VIDEO = 3;
    public static final int ADAPTER_TYPE_AUDIO = 4;
    private boolean isDisplayCamera;
    private ArrayList<LocalMedia> mData = new ArrayList();
    private final SelectorConfig mConfig;
    private final Context mContext;
    private OnItemClickListener listener;

    public void notifyItemPositionChanged(int position) {
        this.notifyItemChanged(position);
    }

    public PictureImageGridAdapter(Context context, SelectorConfig mConfig) {
        this.mConfig = mConfig;
        this.mContext = context;
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public void setDataAndDataSetChanged(ArrayList<LocalMedia> result) {
        if (result != null) {
            this.mData = result;
            this.notifyDataSetChanged();
        }
    }

    public boolean isDisplayCamera() {
        return this.isDisplayCamera;
    }

    public void setDisplayCamera(boolean displayCamera) {
        this.isDisplayCamera = displayCamera;
    }

    public ArrayList<LocalMedia> getData() {
        return this.mData;
    }

    public boolean isDataEmpty() {
        return this.mData.size() == 0;
    }

    public int getItemViewType(int position) {
        if (this.isDisplayCamera && position == 0) {
            return 1;
        }
        int adapterPosition = this.isDisplayCamera ? position - 1 : position;
        String mimeType = this.mData.get(adapterPosition).getMimeType();
        if (PictureMimeType.isHasVideo(mimeType)) {
            return 3;
        }
        if (PictureMimeType.isHasAudio(mimeType)) {
            return 4;
        }
        return 2;
    }

    @NonNull
    public BaseRecyclerMediaHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return BaseRecyclerMediaHolder.generate(parent, viewType, this.getItemResourceId(viewType), this.mConfig);
    }

    private int getItemResourceId(int viewType) {
        switch (viewType) {
            case 1: {
                return R.layout.ps_item_grid_camera;
            }
            case 3: {
                int layoutResourceId = InjectResourceSource.getLayoutResource(this.mContext, 4);
                return layoutResourceId != 0 ? layoutResourceId : R.layout.ps_item_grid_video;
            }
            case 4: {
                int layoutResourceId = InjectResourceSource.getLayoutResource(this.mContext, 5);
                return layoutResourceId != 0 ? layoutResourceId : R.layout.ps_item_grid_audio;
            }
        }
        int layoutResourceId = InjectResourceSource.getLayoutResource(this.mContext, 3);
        return layoutResourceId != 0 ? layoutResourceId : R.layout.ps_item_grid_image;
    }

    public void onBindViewHolder(BaseRecyclerMediaHolder holder, int position) {
        if (this.getItemViewType(position) == 1) {
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (PictureImageGridAdapter.this.listener != null) {
                        PictureImageGridAdapter.this.listener.openCameraClick();
                    }
                }
            });
        } else {
            int adapterPosition = this.isDisplayCamera ? position - 1 : position;
            LocalMedia media = this.mData.get(adapterPosition);
            holder.bindData(media, adapterPosition);
            holder.setOnItemClickListener(this.listener);
        }
    }

    public int getItemCount() {
        return this.isDisplayCamera ? this.mData.size() + 1 : this.mData.size();
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.listener = listener;
    }

    public static interface OnItemClickListener {
        public void openCameraClick();

        public void onItemClick(View var1, int var2, LocalMedia var3);

        public void onItemLongClick(View var1, int var2);

        public int onSelected(View var1, int var2, LocalMedia var3);
    }
}

