/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.loader;

import android.content.Context;
import android.text.TextUtils;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.config.SelectorConfig;
import com.luck.picture.lib.config.SelectorProviders;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.entity.MediaExtraInfo;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.SortUtils;
import com.luck.picture.lib.utils.ValueOf;
import java.io.File;
import java.io.FileFilter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public final class SandboxFileLoader {
    public static LocalMediaFolder loadInAppSandboxFolderFile(Context context, String sandboxDir) {
        ArrayList<LocalMedia> list = SandboxFileLoader.loadInAppSandboxFile(context, sandboxDir);
        LocalMediaFolder folder = null;
        if (list != null && list.size() > 0) {
            SortUtils.sortLocalMediaAddedTime(list);
            LocalMedia firstMedia = list.get(0);
            folder = new LocalMediaFolder();
            folder.setFolderName(firstMedia.getParentFolderName());
            folder.setFirstImagePath(firstMedia.getPath());
            folder.setFirstMimeType(firstMedia.getMimeType());
            folder.setBucketId(firstMedia.getBucketId());
            folder.setFolderTotalNum(list.size());
            folder.setData(list);
        }
        return folder;
    }

    public static ArrayList<LocalMedia> loadInAppSandboxFile(Context context, String sandboxDir) {
        if (TextUtils.isEmpty((CharSequence)sandboxDir)) {
            return null;
        }
        ArrayList<LocalMedia> list = new ArrayList<LocalMedia>();
        File sandboxFile = new File(sandboxDir);
        if (sandboxFile.exists()) {
            File[] files = sandboxFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !file.isDirectory();
                }
            });
            if (files == null) {
                return list;
            }
            SelectorConfig config = SelectorProviders.getInstance().getSelectorConfig();
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            for (File f : files) {
                long duration;
                int height;
                int width;
                long id2;
                String mimeType = MediaUtils.getMimeTypeFromMediaUrl(f.getAbsolutePath());
                if (config.chooseMode == SelectMimeType.ofImage()) {
                    if (!PictureMimeType.isHasImage(mimeType)) {
                        continue;
                    }
                } else if (config.chooseMode != SelectMimeType.ofVideo() ? config.chooseMode == SelectMimeType.ofAudio() && !PictureMimeType.isHasAudio(mimeType) : !PictureMimeType.isHasVideo(mimeType)) continue;
                if (config.queryOnlyList != null && config.queryOnlyList.size() > 0 && !config.queryOnlyList.contains(mimeType) || !config.isGif && PictureMimeType.isHasGif(mimeType)) continue;
                String absolutePath = f.getAbsolutePath();
                long size = f.length();
                if (size <= 0L) continue;
                if (md != null) {
                    md.update(absolutePath.getBytes());
                    id2 = new BigInteger(1, md.digest()).longValue();
                } else {
                    id2 = f.lastModified() / 1000L;
                }
                long bucketId = ValueOf.toLong(sandboxFile.getName().hashCode());
                long dateAdded = f.lastModified() / 1000L;
                if (PictureMimeType.isHasVideo(mimeType)) {
                    MediaExtraInfo videoSize = MediaUtils.getVideoSize(context, absolutePath);
                    width = videoSize.getWidth();
                    height = videoSize.getHeight();
                    duration = videoSize.getDuration();
                } else if (PictureMimeType.isHasAudio(mimeType)) {
                    MediaExtraInfo audioSize = MediaUtils.getAudioSize(context, absolutePath);
                    width = audioSize.getWidth();
                    height = audioSize.getHeight();
                    duration = audioSize.getDuration();
                } else {
                    MediaExtraInfo imageSize = MediaUtils.getImageSize(context, absolutePath);
                    width = imageSize.getWidth();
                    height = imageSize.getHeight();
                    duration = 0L;
                }
                if ((PictureMimeType.isHasVideo(mimeType) || PictureMimeType.isHasAudio(mimeType)) && (config.filterVideoMinSecond > 0 && duration < (long)config.filterVideoMinSecond || config.filterVideoMaxSecond > 0 && duration > (long)config.filterVideoMaxSecond || duration == 0L)) continue;
                LocalMedia media = LocalMedia.create();
                media.setId(id2);
                media.setPath(absolutePath);
                media.setRealPath(absolutePath);
                media.setFileName(f.getName());
                media.setParentFolderName(sandboxFile.getName());
                media.setDuration(duration);
                media.setChooseModel(config.chooseMode);
                media.setMimeType(mimeType);
                media.setWidth(width);
                media.setHeight(height);
                media.setSize(size);
                media.setBucketId(bucketId);
                media.setDateAddedTime(dateAdded);
                if (config.onQueryFilterListener != null && config.onQueryFilterListener.onFilter(media)) continue;
                media.setSandboxPath(SdkVersionUtils.isQ() ? absolutePath : null);
                list.add(media);
            }
        }
        return list;
    }
}

