/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.statusbar;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.appcompat.app.AppCompatActivity;
import com.yalantis.ucrop.statusbar.LightStatusBarUtils;
import com.yalantis.ucrop.util.DensityUtil;

public class ImmersiveManager {
    private static final String TAG_FAKE_STATUS_BAR_VIEW = "TAG_FAKE_STATUS_BAR_VIEW";
    private static final String TAG_MARGIN_ADDED = "TAG_MARGIN_ADDED";

    public static void immersiveAboveAPI23(AppCompatActivity baseActivity, int statusBarColor, int navigationBarColor, boolean isDarkStatusBarIcon) {
        ImmersiveManager.immersiveAboveAPI23(baseActivity, false, false, statusBarColor, navigationBarColor, isDarkStatusBarIcon);
    }

    public static void immersiveAboveAPI23(AppCompatActivity baseActivity, boolean isMarginStatusBar, boolean isMarginNavigationBar, int statusBarColor, int navigationBarColor, boolean isDarkStatusBarIcon) {
        try {
            Window window = baseActivity.getWindow();
            if (Build.VERSION.SDK_INT < 21) {
                if (isDarkStatusBarIcon) {
                    ImmersiveManager.initBarBelowLOLLIPOP((Activity)baseActivity);
                } else {
                    window.setFlags(0x4000000, 0x4000000);
                }
            } else {
                if (isMarginStatusBar && isMarginNavigationBar) {
                    window.clearFlags(0xC000000);
                    LightStatusBarUtils.setLightStatusBar((Activity)baseActivity, true, true, statusBarColor == 0, isDarkStatusBarIcon);
                    window.addFlags(Integer.MIN_VALUE);
                } else if (!isMarginStatusBar && !isMarginNavigationBar) {
                    if (Build.VERSION.SDK_INT < 23 && isDarkStatusBarIcon) {
                        ImmersiveManager.initBarBelowLOLLIPOP((Activity)baseActivity);
                    } else {
                        window.requestFeature(1);
                        window.clearFlags(0xC000000);
                        LightStatusBarUtils.setLightStatusBar((Activity)baseActivity, false, false, statusBarColor == 0, isDarkStatusBarIcon);
                        window.addFlags(Integer.MIN_VALUE);
                    }
                } else if (!isMarginStatusBar) {
                    window.requestFeature(1);
                    window.clearFlags(0xC000000);
                    LightStatusBarUtils.setLightStatusBar((Activity)baseActivity, false, true, statusBarColor == 0, isDarkStatusBarIcon);
                    window.addFlags(Integer.MIN_VALUE);
                } else {
                    return;
                }
                window.setStatusBarColor(statusBarColor);
                window.setNavigationBarColor(navigationBarColor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initBarBelowLOLLIPOP(Activity activity) {
        Window mWindow = activity.getWindow();
        mWindow.addFlags(0x4000000);
        ImmersiveManager.setupStatusBarView(activity);
    }

    private static void setupStatusBarView(Activity activity) {
        Window mWindow = activity.getWindow();
        View statusBarView = mWindow.getDecorView().findViewWithTag((Object)TAG_FAKE_STATUS_BAR_VIEW);
        if (statusBarView == null) {
            statusBarView = new View((Context)activity);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, DensityUtil.getStatusBarHeight((Context)activity));
            params.gravity = 48;
            statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
            statusBarView.setVisibility(0);
            statusBarView.setTag((Object)TAG_MARGIN_ADDED);
            ((ViewGroup)mWindow.getDecorView()).addView(statusBarView);
        }
        statusBarView.setBackgroundColor(0);
    }
}

